/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.net.URLStreamHandlerFactory;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ideimpl.net.LazyURLFileSystemHelper;
import oracle.ideimpl.net.LazyURLFileSystemHelperDecorator;
import oracle.ideimpl.net.LazyURLStreamHandlerFactory;

public final class URLFileSystemHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem";
    private static final ElementName STREAMFACTORY = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "streamfactory");
    private static final ElementName FSHELPER = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "fshelper");
    private static final ElementName FSDECORATOR = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "fsdecorator");
    private final ElementVisitor _streamFactoryHandler = new StreamFactoryHandler();
    private final ElementVisitor _helperHandler = new HelperHandler();
    private final ElementVisitor _decoratorHandler = new DecoratorHandler();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(FSHELPER, this._helperHandler);
        context.registerChildVisitor(STREAMFACTORY, this._streamFactoryHandler);
        context.registerChildVisitor(FSDECORATOR, this._decoratorHandler);
    }

    private class DecoratorHandler
    extends ElementVisitor {
        private DecoratorHandler() {
        }

        public void start(ElementStartContext context) {
            String protocol = context.getAttributeValue("protocol");
            String className = context.getAttributeValue("class");
            if (protocol == null) {
                context.getLogger().severe("Required attribute protocol missing from decorator");
                return;
            }
            if (className == null) {
                context.getLogger().severe("Required attribute class missing from decorator");
                return;
            }
            MetaClass cls = new MetaClass(DecoratorHandler.getClassLoader((ElementContext)context), className);
            URLFileSystemHelper helper = URLFileSystem.findHelper((String)protocol);
            URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)new LazyURLFileSystemHelperDecorator(helper, cls));
        }
    }

    private class HelperHandler
    extends ElementVisitor {
        private HelperHandler() {
        }

        public void start(ElementStartContext context) {
            String protocol = context.getAttributeValue("protocol");
            String className = context.getAttributeValue("class");
            if (protocol == null) {
                context.getLogger().severe("Required attribute protocol missing from helper");
                return;
            }
            if (className == null) {
                context.getLogger().severe("Required attribute class missing from helper");
                return;
            }
            MetaClass cls = new MetaClass(HelperHandler.getClassLoader((ElementContext)context), className);
            URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)new LazyURLFileSystemHelper(cls));
        }
    }

    private class StreamFactoryHandler
    extends ElementVisitor {
        private StreamFactoryHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            String protocolName = context.getAttributeValue("protocol");
            if (className == null) {
                context.getLogger().severe("Missing required attribute 'class'");
                return;
            }
            if (protocolName == null) {
                context.getLogger().severe("Missing required attribute 'protocol'");
                URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new LazyURLStreamHandlerFactory(new MetaClass(StreamFactoryHandler.getClassLoader((ElementContext)context), className)));
                return;
            }
            MetaClass cls = new MetaClass(StreamFactoryHandler.getClassLoader((ElementContext)context), className);
            URLFileSystem.addURLStreamHandlerFactory((String)protocolName, (URLStreamHandlerFactory)new LazyURLStreamHandlerFactory(cls));
        }
    }
}

