/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.PilotInfo;
import ice.storm.ScripterInfo;
import ice.util.encoding.ReaderUTF8;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class StormPropertiesLoader {
    Vector infos = new Vector();
    Vector scripters = new Vector();

    StormPropertiesLoader() {
    }

    void loadProperties(InputStream in, Hashtable fileExtHash) throws IOException {
        int mode = 0;
        String name = null;
        String version = null;
        String author = null;
        String description = null;
        String contentType = null;
        String fileExtensions = null;
        String className = null;
        String urls = null;
        String alias = null;
        BufferedReader r = null;
        r = new BufferedReader(new ReaderUTF8(in));
        String line = r.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                boolean record = false;
                if (!line.endsWith("\\")) {
                    record = true;
                } else {
                    int semi_idx = line.indexOf(";");
                    line = semi_idx < 0 ? line.substring(0, line.length() - 1) : line.substring(0, semi_idx);
                }
                line = line.trim();
                if (line.endsWith(":")) {
                    String s = line.substring(0, line.length() - 1);
                    if (s.equals("pilot")) {
                        mode = 1;
                    } else if (s.equals("scripter")) {
                        mode = 2;
                    } else {
                        contentType = s;
                        mode = 0;
                    }
                } else {
                    int eq_idx = line.indexOf(61);
                    if (eq_idx >= 0) {
                        String val = line.substring(eq_idx + 1).trim();
                        if (line.startsWith("file_extensions") && mode == 0) {
                            fileExtensions = val.replace(',', ' ');
                        } else if (line.startsWith("description")) {
                            description = val;
                        } else if (line.startsWith("name") && mode > 0) {
                            name = val;
                        } else if (line.startsWith("version") && mode > 0) {
                            version = val;
                        } else if (line.startsWith("author") && mode > 0) {
                            author = val;
                        } else if (line.startsWith("classname") && mode > 0) {
                            className = val;
                        } else if (line.startsWith("urls") && mode > 0) {
                            urls = val.replace(',', ' ');
                        } else if (line.startsWith("content_types") && mode == 1) {
                            contentType = val.replace(',', ' ');
                        } else if (line.startsWith("aliases") && mode == 2) {
                            alias = val.replace(',', ' ');
                        }
                        if (record) {
                            URL u;
                            int i;
                            Vector<URL> uv;
                            Object p;
                            if (mode == 0 && contentType != null && fileExtensions != null) {
                                String[] ss = this.parseList(fileExtensions);
                                for (int i2 = 0; i2 < ss.length; ++i2) {
                                    fileExtHash.put(ss[i2], contentType);
                                }
                            } else if (mode == 1 && name != null && className != null && contentType != null) {
                                if (version == null) {
                                    version = "0";
                                }
                                if (author == null) {
                                    author = "";
                                }
                                if (description == null) {
                                    description = "";
                                }
                                p = new PilotInfo();
                                ((PilotInfo)p).name = name;
                                ((PilotInfo)p).version = version;
                                ((PilotInfo)p).author = author;
                                ((PilotInfo)p).description = description;
                                ((PilotInfo)p).className = className;
                                ((PilotInfo)p).supportedContentTypes = this.parseList(contentType);
                                String[] ss = this.parseList(urls);
                                uv = new Vector<URL>();
                                for (i = 0; i < ss.length; ++i) {
                                    try {
                                        u = new URL(ss[i]);
                                        uv.addElement(u);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                ((PilotInfo)p).codeBaseURLs = new URL[uv.size()];
                                uv.copyInto(((PilotInfo)p).codeBaseURLs);
                                this.infos.addElement(p);
                            } else if (mode == 2 && name != null && className != null && alias != null) {
                                if (version == null) {
                                    version = "0";
                                }
                                if (author == null) {
                                    author = "";
                                }
                                if (description == null) {
                                    description = "";
                                }
                                p = new ScripterInfo();
                                ((ScripterInfo)p).name = name;
                                ((ScripterInfo)p).version = version;
                                ((ScripterInfo)p).author = author;
                                ((ScripterInfo)p).description = description;
                                ((ScripterInfo)p).className = className;
                                ((ScripterInfo)p).aliases = this.parseList(alias);
                                String[] ss = this.parseList(urls);
                                uv = new Vector();
                                for (i = 0; i < ss.length; ++i) {
                                    try {
                                        u = new URL(ss[i]);
                                        uv.addElement(u);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                ((ScripterInfo)p).codeBaseURLs = new URL[uv.size()];
                                uv.copyInto(((ScripterInfo)p).codeBaseURLs);
                                this.scripters.addElement(p);
                            }
                            name = null;
                            version = null;
                            author = null;
                            description = null;
                            contentType = null;
                            fileExtensions = null;
                            className = null;
                            urls = null;
                        }
                    }
                }
            }
            line = r.readLine();
        }
        r.close();
    }

    private String[] parseList(String list) {
        if (list == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(list);
        String[] vals = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            vals[i++] = st.nextToken();
        }
        return vals;
    }
}

