/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Properties;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.Library;

public interface JDK
extends Library {
    public static final String JDK_NAME_PROPERTY = "description";
    public static final String JDK_EXEC_PROPERTY = "javaExecutable";
    public static final String JDK_INSTALLED_VMS_PROPERTY = "installedVMs";
    public static final String JDK_VERSION_NUMBER_PROPERTY = "version";
    public static final String JDK_SDK_BIN_DIR_PROPERTY = "sdkBinDir";

    public URL getJavaExecutable();

    public void setJavaExecutable(URL var1);

    public String[] getInstalledVMs();

    public void setInstalledVMs(String[] var1);

    public static VersionNumber sanitizeVersionNumber(VersionNumber version) {
        if (version != null) {
            String versionString = version.toString();
            for (int index = 0; index < versionString.length(); ++index) {
                char c = versionString.charAt(index);
                if (Character.isDigit(c)) continue;
                if (c == '.') {
                    return version;
                }
                return new VersionNumber(versionString.substring(0, index) + ".0" + versionString.substring(index));
            }
        }
        return version;
    }

    public VersionNumber getJavaVersion();

    public void setJavaVersion(VersionNumber var1);

    public URL getSDKBinDir();

    public void setSDKBinDir(URL var1);

    public String getSDKBinJavaExecutableNoConsole();

    public String getJavaExecutableNoConsole();

    public Properties getSystemProperties();

    default public URL getJrtfsJar() {
        URL dir = this.getSDKBinDir();
        URL uRL = dir = dir != null ? URLFileSystem.getParent((URL)dir) : null;
        while (dir != null) {
            URL jrtfsJar = URLFactory.newURL((URL)dir, (String)"lib/jrt-fs.jar");
            if (URLFileSystem.exists((URL)jrtfsJar)) {
                return jrtfsJar;
            }
            if (URLFileSystem.exists((URL)URLFactory.newURL((URL)dir, (String)"lib"))) break;
            dir = URLFileSystem.getParent((URL)dir);
        }
        return null;
    }

    @Override
    public URLPath getClassPath();

    @Override
    public void setClassPath(URLPath var1);
}

