/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class NodesWMatchingSrc
extends IdentedPredicate {
    String nodeVar1;
    String nodeVar2;

    public NodesWMatchingSrc(String nodeVar1, String nodeVar2) {
        this.nodeVar1 = nodeVar1;
        this.nodeVar2 = nodeVar2;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src) {
        ParseNode node1 = this.getNode(this.nodeVar1, attributePositions, tuple);
        if (node1 == null) {
            return false;
        }
        ParseNode node2 = this.getNode(this.nodeVar2, attributePositions, tuple);
        if (node2 == null) {
            return false;
        }
        return node1.content(src).equals(node2.content(src));
    }

    public String toString() {
        return "?" + this.nodeVar1 + " = ?" + this.nodeVar2;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        NodesWMatchingSrc.variables(this.nodeVar1, ret);
        NodesWMatchingSrc.variables(this.nodeVar2, ret);
    }

    @Override
    public void signature(Set<String> ret) {
        this.variables(ret, false);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        Attribute attr1 = varDefs.get(this.nodeVar1);
        Attribute attr2 = varDefs.get(this.nodeVar2);
        if (attr1.isDependent(var1, varDefs) && attr2.isDependent(var2, varDefs) || attr2.isDependent(var1, varDefs) && attr1.isDependent(var2, varDefs)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.nodeVar1.indexOf(46);
        if (0 < pos) {
            ret.put(this.nodeVar1.substring(0, pos), true);
        }
        if (0 < (pos = this.nodeVar2.indexOf(46))) {
            ret.put(this.nodeVar2.substring(0, pos), true);
        }
        return ret;
    }
}

