/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.NamedValue;

public class TypeMetadata {
    private Map<Attribute, Object> attributes;
    private boolean syntaxSynonym;
    private Integer hashCode;
    public static final String CHAR_FLAG = "C";
    public static final String BYTE_FLAG = "B";
    public static final String NULL_FLAG = "0";

    public List<NamedValue<TypeMetadata>> get_type_components() {
        return TypeMetadata.get_type_components((List)this.attributes.get((Object)Attribute.TYPE_COMPONENTS));
    }

    static List<NamedValue<TypeMetadata>> get_type_components(List<NamedValue<TypeMetadata>> components) {
        if (components != null) {
            return new ArrayList<NamedValue<TypeMetadata>>(components);
        }
        return components;
    }

    public String get_type_subname() {
        return (String)this.attributes.get((Object)Attribute.TYPE_SUBNAME);
    }

    public String get_type_owner() {
        return (String)this.attributes.get((Object)Attribute.TYPE_OWNER);
    }

    public String get_type_link() {
        return (String)this.attributes.get((Object)Attribute.TYPE_LINK);
    }

    public Integer get_data_length() {
        return (Integer)this.attributes.get((Object)Attribute.DATA_LENGTH);
    }

    public String get_type_name() {
        return (String)this.attributes.get((Object)Attribute.TYPE_NAME);
    }

    public Integer get_data_scale() {
        return (Integer)this.attributes.get((Object)Attribute.DATA_SCALE);
    }

    public Integer get_radix() {
        return (Integer)this.attributes.get((Object)Attribute.DATA_RADIX);
    }

    public Integer get_data_precision() {
        return (Integer)this.attributes.get((Object)Attribute.DATA_PRECISION);
    }

    public String get_data_type() {
        return (String)this.attributes.get((Object)Attribute.DATA_TYPE);
    }

    public String get_pls_type() {
        return (String)this.attributes.get((Object)Attribute.PLS_TYPE);
    }

    public String get_char_used() {
        return (String)this.attributes.get((Object)Attribute.CHAR_USED);
    }

    public Integer get_char_length() {
        return (Integer)this.attributes.get((Object)Attribute.CHAR_LENGTH);
    }

    public String get_char_set_name() {
        return (String)this.attributes.get((Object)Attribute.CHAR_SET_NAME);
    }

    public Integer get_type_code() {
        return (Integer)this.attributes.get((Object)Attribute.TYPE_CODE);
    }

    public String get_base_type() {
        return (String)this.attributes.get((Object)Attribute.BASE_TYPE);
    }

    public Class<? extends DataType> get_impl_class() {
        return (Class)this.attributes.get((Object)Attribute.IMPL_CLASS);
    }

    public String get_impl_data_type() {
        return (String)this.attributes.get((Object)Attribute.IMPL_DATA_TYPE);
    }

    public Object getAttribute(Attribute attribute) {
        return this.attributes.get((Object)attribute);
    }

    public boolean isIncomplete() {
        return this.attributes.containsValue(null);
    }

    public boolean isSyntaxSynonym() {
        return this.syntaxSynonym;
    }

    TypeMetadata(Map<Attribute, Object> attributeMap) {
        this(attributeMap, false);
    }

    TypeMetadata(Map<Attribute, Object> attributeMap, boolean syntaxSynonym) {
        this.syntaxSynonym = syntaxSynonym;
        this.hashCode = null;
        this.attributes = new HashMap<Attribute, Object>();
        if (attributeMap != null) {
            this.attributes.putAll(attributeMap);
        }
    }

    TypeMetadata(final Integer typeCode, final String dataType, final Integer precision, final Integer scale) {
        this((Map<Attribute, Object>)new HashMap<Attribute, Object>(){
            {
                if (typeCode != null) {
                    this.put(Attribute.TYPE_CODE, typeCode);
                }
                if (dataType != null) {
                    this.put(Attribute.DATA_TYPE, dataType);
                }
                if (precision != null) {
                    this.put(Attribute.DATA_PRECISION, precision);
                }
                if (scale != null) {
                    this.put(Attribute.DATA_SCALE, scale);
                }
            }
        });
    }

    static TypeMetadata overideTypeMetadata(TypeMetadata source, Map<Attribute, Object> attributeMap, boolean fromTypeMetadata) {
        if (source != null && (attributeMap == null || TypeMetadata.containsAll(source.attributes, attributeMap))) {
            return source;
        }
        HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
        if (source != null) {
            attributes.putAll(source.attributes);
        }
        if (!attributes.containsKey((Object)Attribute.IMPL_CLASS)) {
            attributes.remove((Object)Attribute.IMPL_DATA_TYPE);
        }
        if (attributes.containsKey((Object)Attribute.DATA_TYPE)) {
            String datatype = (String)attributes.get((Object)Attribute.DATA_TYPE);
            String basetype = (String)attributes.get((Object)Attribute.BASE_TYPE);
            if (basetype == null && datatype != null) {
                attributes.put(Attribute.BASE_TYPE, datatype);
            }
            attributes.remove((Object)Attribute.DATA_TYPE);
        }
        if (attributeMap != null) {
            attributes.putAll(attributeMap);
        }
        if (!fromTypeMetadata && attributeMap.containsKey((Object)Attribute.TYPE_COMPONENTS)) {
            attributes.put(Attribute.TYPE_COMPONENTS, TypeMetadata.get_type_components((List)attributeMap.get((Object)Attribute.TYPE_COMPONENTS)));
        }
        if (attributes.containsKey((Object)Attribute.IMPL_CLASS) && attributes.containsKey((Object)Attribute.DATA_TYPE) && !attributes.containsKey((Object)Attribute.IMPL_DATA_TYPE)) {
            attributes.put(Attribute.IMPL_DATA_TYPE, attributes.get((Object)Attribute.DATA_TYPE));
        }
        return new TypeMetadata(attributes);
    }

    static TypeMetadata overideTypeMetadata(TypeMetadata source, Map<Attribute, Object> attributeMap) {
        return TypeMetadata.overideTypeMetadata(source, attributeMap, false);
    }

    static TypeMetadata overideTypeMetadata(TypeMetadata source, TypeMetadata source2) {
        if (source2 == source || source2 != null && (source == null || TypeMetadata.containsAll(source2.attributes, source.attributes))) {
            return source2;
        }
        return TypeMetadata.overideTypeMetadata(source, source2.attributes, true);
    }

    public void export(Map<Attribute, Object> attributeMap) {
        attributeMap.putAll(this.attributes);
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof TypeMetadata) {
            TypeMetadata objTypeMetadata = (TypeMetadata)obj;
            isEqual = TypeMetadata.areEquals(this.attributes, objTypeMetadata.attributes);
        }
        return isEqual;
    }

    private static boolean containsAll(Map<Attribute, Object> source, Map<Attribute, Object> attributeMap) {
        for (Map.Entry<Attribute, Object> entry : attributeMap.entrySet()) {
            if (TypeMetadata.areEquals(entry.getValue(), source.get((Object)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hash = 7;
            hash = 31 * hash + (null == this.attributes ? 0 : this.attributes.hashCode());
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public static enum Attribute {
        DATA_TYPE,
        DATA_LENGTH,
        DATA_PRECISION,
        DATA_SCALE,
        DATA_RADIX,
        PLS_TYPE,
        TYPE_OWNER,
        TYPE_NAME,
        TYPE_SUBNAME,
        TYPE_LINK,
        CHAR_LENGTH,
        CHAR_USED,
        CHAR_SET_NAME,
        TYPE_COMPONENTS,
        TYPE_CODE,
        BASE_TYPE,
        IMPL_CLASS,
        IMPL_DATA_TYPE;

    }
}

