/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.raptor.datatypes.blob.BlobMimeType;
import oracle.dbtools.raptor.datatypes.blob.IBlobMimeXmlParser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BlobMimeXmlParser
extends DefaultHandler
implements IBlobMimeXmlParser {
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int NO_OF_BYTES = 520;
    private String m_hexMimeString = null;
    ArrayList<BlobMimeType> mimeType;
    private String tempVal;
    private BlobMimeType tempBlobMime;
    private String m_magicNumber = null;
    private String m_mimeType = null;
    private String m_applicationType = null;
    private String m_extension = null;
    private String m_description = null;
    private static final int NO_OF_OLE_BYTES = 20400;
    private boolean m_isMimeTypeSupported = false;

    public BlobMimeXmlParser() {
    }

    public BlobMimeXmlParser(InputStream inputstream) throws IOException {
        this.initializeBlobParser(inputstream);
    }

    @Override
    public void initializeBlobParser(InputStream inputstream) throws IOException {
        this.mimeType = new ArrayList();
        this.m_isMimeTypeSupported = this.getHexStream(inputstream);
        if (this.m_isMimeTypeSupported) {
            this.parseBlobXML(this.getHexMimeString());
            this.getMimeAndApplicationType();
        }
    }

    private boolean parseBlobXML(String magicNumber) {
        this.setMagicNumber(magicNumber);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getMimeMagicNumberXmlFile().openStream(), (DefaultHandler)this);
        }
        catch (SAXException se) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, se.getStackTrace()[0].toString(), se);
            ExceptionHandler.handleException(se);
        }
        catch (ParserConfigurationException pce) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, pce.getStackTrace()[0].toString(), pce);
            ExceptionHandler.handleException(pce);
        }
        catch (IOException ie) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ie.getStackTrace()[0].toString(), ie);
            ExceptionHandler.handleException(ie);
        }
        return true;
    }

    private boolean getMimeAndApplicationType() {
        for (BlobMimeType tempBlobMimeType : this.mimeType) {
            if (!this.compareMagicNumber(tempBlobMimeType.getMagicNumber(), tempBlobMimeType.getMagicNumberLength())) continue;
            if (tempBlobMimeType.getOffset() != 0) {
                if (!this.compareOffsetNumber(tempBlobMimeType.getOffset(), tempBlobMimeType.getOffsetNumber(), tempBlobMimeType.getOffsetNumberLength())) continue;
                this.setMimeType(tempBlobMimeType.getMimeType());
                this.setApplicationType(tempBlobMimeType.getApplicationType());
                this.setExtension(tempBlobMimeType.getExtension());
                this.setDescription(tempBlobMimeType.getDescription());
                break;
            }
            this.setMimeType(tempBlobMimeType.getMimeType());
            this.setApplicationType(tempBlobMimeType.getApplicationType());
            this.setExtension(tempBlobMimeType.getExtension());
            this.setDescription(tempBlobMimeType.getDescription());
            break;
        }
        return false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (qName.equalsIgnoreCase("match")) {
            this.tempBlobMime = new BlobMimeType();
        } else if (qName.equalsIgnoreCase("MagicNumber") && attributes.getLength() > 0) {
            this.tempBlobMime.setOffset(Integer.parseInt(attributes.getValue("offset")));
            this.tempBlobMime.setMagicNumberLength(Integer.parseInt(attributes.getValue("length")));
        } else if (qName.equalsIgnoreCase("OffsetNumber") && attributes.getLength() > 0) {
            this.tempBlobMime.setOffsetNumberLength(Integer.parseInt(attributes.getValue("length")));
            this.tempBlobMime.setOffsetNumber(attributes.getValue("OffsetNumber"));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("match")) {
            this.mimeType.add(this.tempBlobMime);
        } else if (!qName.equalsIgnoreCase("datatype")) {
            if (qName.equalsIgnoreCase("offset")) {
                this.tempBlobMime.setOffset(Integer.parseInt(this.tempVal));
            } else if (qName.equalsIgnoreCase("OffsetNumber")) {
                this.tempBlobMime.setOffsetNumber(this.tempVal);
            } else if (qName.equalsIgnoreCase("length")) {
                this.tempBlobMime.setMagicNumberLength(Integer.parseInt(this.tempVal));
            } else if (qName.equalsIgnoreCase("MagicNumber")) {
                this.tempBlobMime.setMagicNumber(this.tempVal);
            } else if (qName.equalsIgnoreCase("Mimetype")) {
                this.tempBlobMime.setMimeType(this.tempVal);
            } else if (qName.equalsIgnoreCase("Extension")) {
                this.tempBlobMime.setExtension(this.tempVal);
            } else if (qName.equalsIgnoreCase("Application")) {
                this.tempBlobMime.setApplicationType(this.tempVal);
            } else if (qName.equalsIgnoreCase("Description")) {
                this.tempBlobMime.setDescription(this.tempVal);
            }
        }
    }

    private boolean compareMagicNumber(String xmlMagicNumber, int length) {
        String hexCodeNumber = this.getMagicNumber();
        String compHexCode = hexCodeNumber.substring(0, length);
        return hexCodeNumber.substring(0, length).equals(xmlMagicNumber);
    }

    private boolean compareOffsetNumber(int bytesOffset, String xmlOffsetNumber, int length) {
        String hexCodeNumber = this.getMagicNumber();
        String compHexCode = hexCodeNumber.substring(bytesOffset * 2, bytesOffset * 2 + length);
        return hexCodeNumber.substring(bytesOffset * 2, bytesOffset * 2 + length).equals(xmlOffsetNumber);
    }

    @Override
    public String getMagicNumber() {
        return this.m_magicNumber;
    }

    private void setMagicNumber(String magicNumber) {
        this.m_magicNumber = magicNumber;
    }

    @Override
    public String getExtension() {
        return this.m_extension;
    }

    private void setExtension(String extension) {
        this.m_extension = extension;
    }

    @Override
    public String getMimeType() {
        return this.m_mimeType;
    }

    private void setMimeType(String mimeType) {
        this.m_mimeType = mimeType;
    }

    @Override
    public String getApplicationType() {
        return this.m_applicationType;
    }

    private void setApplicationType(String applicationType) {
        this.m_applicationType = applicationType;
    }

    private void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean isMimeTypeSupported() {
        return this.m_isMimeTypeSupported;
    }

    private URL getMimeMagicNumberXmlFile() {
        String path = "/oracle/dbtools/raptor/datatypes/blob/MimeMagicNumber.xml";
        return this.getClass().getResource(path);
    }

    private boolean getHexStream(InputStream instream) throws IOException {
        try {
            byte[] myByteArray = new byte[520];
            instream.mark(521);
            instream.read(myByteArray);
            this.setHexMimeString(this.getHexString(myByteArray));
            instream.reset();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getOleHexStream(InputStream instream) throws IOException {
        try {
            byte[] myByteArray = new byte[20400];
            instream.mark(20401);
            instream.read(myByteArray);
            instream.reset();
            return this.getHexString(myByteArray);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getHexString(byte[] raw) throws UnsupportedEncodingException {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex, "ASCII");
    }

    public void setHexMimeString(String hexString) {
        this.m_hexMimeString = hexString;
    }

    public String getHexMimeString() {
        return this.m_hexMimeString;
    }
}

