/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataUtil;
import oracle.dbtools.raptor.datatypes.metadata.ProgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.SigMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public final class PLSQMetadataBuilder {
    final Map<ProgMetadata.ProgIdentifier, ProgMetadata> programs;
    final Stack<ArgMetadata> argStack = new Stack();
    ProgMetadata program = null;
    SigMetadata signature = null;

    public PLSQMetadataBuilder() {
        this.programs = new HashMap<ProgMetadata.ProgIdentifier, ProgMetadata>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ProgMetadata.ProgIdentifier, ProgMetadata> createArguments(Connection conn, String _objName, String _objOwner, String _objCall, Integer _objOverload) throws SQLException {
        Map<ProgMetadata.ProgIdentifier, ProgMetadata> ret = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(conn, "loadArguments");
            binds.put("OBJECT_OWNER", _objOwner);
            binds.put("OBJECT_NAME", _objName);
            binds.put("OBJECT_CALL", _objCall);
            binds.put("OVERLOAD", _objOverload != null ? _objOverload.toString() : null);
            rset = dbUtil.executeOracleQuery(query, binds);
            if (rset != null) {
                ret = this.createArguments(rset);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rset);
            throw throwable;
        }
        DBUtil.closeResultSet(rset);
        return ret;
    }

    private Map<ProgMetadata.ProgIdentifier, ProgMetadata> createArguments(ResultSet rset) throws SQLException {
        while (rset.next()) {
            ProgMetadata.ProgIdentifier progIdentifier = new ProgMetadata.ProgIdentifier(rset.getString("OWNER"), rset.getString("OBJECT_NAME"), rset.getString("PACKAGE_NAME"));
            SigMetadata.SigIdentifier siglIdentifier = new SigMetadata.SigIdentifier(PLSQMetadataBuilder.getIntegerResult(rset, "OVERLOAD"), PLSQMetadataBuilder.getIntegerResult(rset, "OBJECT_ID"), PLSQMetadataBuilder.getIntegerResult(rset, "SUBPROGRAM_ID"));
            this.switchTo(progIdentifier, siglIdentifier);
            String dataType = rset.getString("DATA_TYPE");
            if (dataType == null) continue;
            String plsType = rset.getString("PLS_TYPE");
            String argName = rset.getString("ARGUMENT_NAME");
            int position = rset.getInt("POSITION");
            int sequence = rset.getInt("SEQUENCE");
            int level = rset.getInt("DATA_LEVEL");
            String inOut = rset.getString("IN_OUT");
            Integer charLen = PLSQMetadataBuilder.getIntegerResult(rset, "CHAR_LENGTH");
            String defaulted = rset.getString("DEFAULTED");
            String defaultValue = rset.getString("DEFAULT_VALUE");
            Integer defaultLen = PLSQMetadataBuilder.getIntegerResult(rset, "DEFAULT_LENGTH");
            HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_TYPE, DataTypesUtil.reformatDataTypeString(dataType));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.PLS_TYPE, DataTypesUtil.reformatDataTypeString(plsType));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_LENGTH, PLSQMetadataBuilder.getIntegerResult(rset, "DATA_LENGTH"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_PRECISION, PLSQMetadataBuilder.getIntegerResult(rset, "DATA_PRECISION"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_SCALE, PLSQMetadataBuilder.getIntegerResult(rset, "DATA_SCALE"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_RADIX, PLSQMetadataBuilder.getIntegerResult(rset, "RADIX"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_OWNER, rset.getString("TYPE_OWNER"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_NAME, rset.getString("TYPE_NAME"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_SUBNAME, rset.getString("TYPE_SUBNAME"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_LINK, rset.getString("TYPE_LINK"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_SET_NAME, rset.getString("CHARACTER_SET_NAME"));
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_LENGTH, charLen);
            PLSQMetadataBuilder.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_USED, rset.getString("CHAR_USED"));
            ArgMetadata.ArgIdentifier argIdentifier = new ArgMetadata.ArgIdentifier(position, sequence, level);
            ArgMetadata argMetadata = new ArgMetadata(argIdentifier, argName, inOut, attributeMap, defaulted, defaultValue, defaultLen);
            this.rollupArgStack(level);
            this.argStack.push(argMetadata);
        }
        this.rollupProgram();
        return this.programs;
    }

    private void rollupArgStack(Integer level) {
        while (!(this.argStack.empty() || level != null && this.argStack.peek().identifier.level != null && level > this.argStack.peek().identifier.level)) {
            ArgMetadata top = this.argStack.pop();
            if (this.argStack.empty()) {
                this.signature.addArgument(top);
                continue;
            }
            this.argStack.peek().addComponent(top);
        }
    }

    private void rollupArgStack() {
        this.rollupArgStack(-1);
    }

    private void rollupSignature() {
        if (this.signature != null) {
            this.rollupArgStack();
            this.program.addSignature(this.signature);
            this.signature = null;
        }
    }

    private void rollupProgram() {
        if (this.program != null) {
            this.rollupSignature();
            this.programs.put(this.program.getIdentifier(), this.program);
            this.program = null;
        }
    }

    private void switchTo(ProgMetadata.ProgIdentifier progIdentifier, SigMetadata.SigIdentifier sigIdentifier) {
        Boolean implMatches;
        if (this.signature != null) {
            implMatches = this.signature.identifiedBy(sigIdentifier);
            if (implMatches == null) {
                if (this.program.identifiedBy(progIdentifier)) {
                    this.signature.identifier = sigIdentifier;
                    return;
                }
            } else if (implMatches.booleanValue()) {
                return;
            }
            this.rollupSignature();
        }
        if (this.program != null && !this.program.identifiedBy(progIdentifier)) {
            this.rollupProgram();
        }
        if (this.program == null) {
            this.program = this.programs.get(progIdentifier);
            if (this.program == null) {
                this.program = new ProgMetadata(progIdentifier);
            }
        }
        if (this.signature == null) {
            this.signature = this.program.getSignature(sigIdentifier.overload);
            if (this.signature == null) {
                this.signature = new SigMetadata(sigIdentifier);
            } else {
                implMatches = this.signature.identifiedBy(sigIdentifier);
                if (implMatches == null) {
                    this.signature.identifier = sigIdentifier;
                }
            }
        }
    }

    private static boolean addAttribute(Map<TypeMetadata.Attribute, Object> attributeMap, TypeMetadata.Attribute attribute, Object value) {
        if (value != null) {
            attributeMap.put(attribute, value);
            return true;
        }
        return false;
    }

    private static Integer getIntegerResult(ResultSet rset, String name) throws SQLException {
        return rset.getObject(name) != null ? Integer.valueOf(rset.getInt(name)) : null;
    }
}

