/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.TemporalDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class DATE
extends TemporalDatum {
    protected DATE(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                try {
                    OraDATEFormat formatter = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraDATEFormat(FormatType.REST);
                    return new StringValue(formatter.format(internalValue));
                }
                catch (ParseException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
            case GENERIC: {
                return new StringValue(((oracle.sql.DATE)internalValue).timestampValue().toString().substring(0, 19));
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return Timestamp.class;
            }
            case DEFAULT: {
                return oracle.sql.DATE.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 91;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof oracle.sql.DATE) {
            return value;
        }
        if (value instanceof byte[]) {
            return new oracle.sql.DATE(Arrays.copyOf((byte[])value, ((byte[])value).length));
        }
        Object superObject = super.customInternalValue(connectionProvider, value);
        if (superObject instanceof Timestamp) {
            return new oracle.sql.DATE((Timestamp)superObject);
        }
        return this.typedValueFromNLSString(connectionProvider, superObject.toString());
    }

    protected oracle.sql.DATE typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) {
        OraDATEFormat format;
        try {
            format = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraDATEFormat();
        }
        catch (ParseException pe) {
            format = null;
        }
        return format.parse(value, new ParsePosition(0));
    }
}

