/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;

public abstract class TemporalUtil {
    private static final DecimalFormat FRACTIONAL_FORMAT = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final DecimalFormat PADDED_FRACTIONAL_FORMAT = new DecimalFormat("0.000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final SimpleDateFormat RFC_3339_MUNGED = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final Pattern TIMESTAMP = Pattern.compile("^\\d{4}-[01]\\d-[0123]\\dT[012]\\d:[0-5]\\d:[0-5]\\d(.\\d+)?(Z|([-+][012]\\d:[0-5]\\d))$");
    private static final MessageFormat RFC_3339_TEXT = new MessageFormat("{0,number,0000}-{1,number,00}-{2,number,00}T{3,number,00}:{4,number,00}:{5,number,00}");
    private static final TimeZone UTC = TimeZone.getTimeZone("Z");
    private static final Pattern YM_PATTERN = Pattern.compile("([-+]?)P(?:([0-9]+)Y)?(?:([0-9]+)M)?", 2);
    private static final Pattern DS_PATTERN = Pattern.compile("([-+]?)P(?:([0-9]+)D)?(T(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);

    public static boolean isTimestamp(CharSequence text) {
        return TIMESTAMP.matcher(text).matches();
    }

    public static String toString(Timestamp timestamp) {
        return TemporalUtil.toString(timestamp.getTime());
    }

    public static String toString(long date) {
        return TemporalUtil.toString(FRACTIONAL_FORMAT, date);
    }

    public static String toPaddedString(long date) {
        return TemporalUtil.toString(PADDED_FRACTIONAL_FORMAT, date);
    }

    private static String toString(DecimalFormat fractionFormat, long date) {
        Calendar c = Calendar.getInstance(UTC);
        c.setTimeInMillis(date);
        StringBuilder b = new StringBuilder();
        b.append(RFC_3339_TEXT.format(new Object[]{c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13)}));
        int millis = c.get(14);
        if (PADDED_FRACTIONAL_FORMAT == fractionFormat || millis > 0) {
            DecimalFormat fmt = fractionFormat;
            b.append(fmt.format((double)millis / 1000.0).substring(1));
        }
        b.append('Z');
        return b.toString();
    }

    public static OraTemporalDatum toOraTemporalDatum(String date) {
        if (TemporalUtil.isTimestamp(date)) {
            long millis = 0L;
            StringBuilder text = new StringBuilder(date);
            Date d = null;
            if (date.endsWith("Z")) {
                text.replace(text.length() - 1, text.length(), "-0000");
            } else {
                text.deleteCharAt(text.length() - 3);
            }
            int fraction = date.indexOf(46);
            if (fraction > 0) {
                int end = text.length() - 5;
                millis = (long)(1000.0 * Double.parseDouble("0" + text.substring(fraction, end)));
                text.delete(fraction, end);
            }
            String munged = text.toString();
            try {
                d = RFC_3339_MUNGED.parse(munged);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return OraTIMESTAMPTZ.getInstance(new Timestamp(d.getTime() + millis), UTC);
        }
        throw new IllegalArgumentException("Not a correctly formatted timestamp: " + date);
    }

    public static OraTemporalDatum toOraTemporalDatum(String date, TimeZone timezone) {
        OraTemporalDatum datum = TemporalUtil.toOraTemporalDatum(date);
        if (timezone != null) {
            datum.setTimeZone(timezone);
        }
        return datum;
    }

    public static Timestamp toTimestamp(String date) {
        return TemporalUtil.toOraTemporalDatum(date).toTimestamp();
    }

    @Deprecated
    public static long valueOf(String date) {
        return TemporalUtil.toTimestamp(date).getTime();
    }

    public static String ISO8601format(OraINTERVALYM interval) {
        StringBuilder sb = new StringBuilder();
        if (interval != null) {
            int sign = interval.get(0);
            int years = interval.get(1);
            int months = interval.get(2);
            if (years != 0 || months != 0) {
                if (sign == -1) {
                    sb.append('-');
                }
                sb.append('P');
                if (years != 0) {
                    sb.append(String.format("%d", years));
                    sb.append('Y');
                }
                if (months != 0) {
                    sb.append(String.format("%d", months));
                    sb.append('M');
                }
            } else {
                sb.append("P0Y0M");
            }
            return sb.toString();
        }
        return null;
    }

    public static OraINTERVALYM YM_ISO8601parse(CharSequence text) {
        OraINTERVALYM interval = OraINTERVALYM.getInstance();
        if (text != null) {
            Matcher matcher = YM_PATTERN.matcher(text);
            if (matcher.matches()) {
                boolean negate = "-".equals(matcher.group(1));
                String yearMatch = matcher.group(2);
                String monthMatch = matcher.group(3);
                int sign = negate ? -1 : 1;
                int years = yearMatch != null && yearMatch.length() > 0 ? Integer.valueOf(yearMatch) : 0;
                int months = monthMatch != null && monthMatch.length() > 0 ? Integer.valueOf(monthMatch) : 0;
                interval.set(0, sign);
                interval.set(1, years);
                interval.set(2, months);
            }
        } else {
            return null;
        }
        return interval;
    }

    public static String ISO8601format(OraINTERVALDS interval) {
        StringBuilder sb = new StringBuilder();
        if (interval != null) {
            int sign = interval.get(0);
            int days = interval.get(1);
            int hours = interval.get(2);
            int minutes = interval.get(3);
            int seconds = interval.get(4);
            int nanos = interval.get(5);
            if (days != 0 || hours != 0 || minutes != 0 || seconds != 0 || nanos != 0) {
                if (sign == -1) {
                    sb.append('-');
                }
                sb.append('P');
                if (days != 0) {
                    sb.append(String.format("%d", days));
                    sb.append('D');
                }
                if (hours != 0 || minutes != 0 || seconds != 0 || nanos != 0) {
                    sb.append('T');
                    if (hours != 0) {
                        sb.append(String.format("%d", hours));
                        sb.append('H');
                    }
                    if (minutes != 0) {
                        sb.append(String.format("%d", minutes));
                        sb.append('M');
                    }
                    String frationalNanos = TemporalUtil.formatNanos(nanos);
                    if (seconds != 0 || frationalNanos != null) {
                        sb.append(String.format("%d", seconds));
                        if (frationalNanos != null) {
                            sb.append('.');
                            sb.append(frationalNanos);
                        }
                        sb.append('S');
                    }
                }
            } else {
                sb.append("P0DT0H0M0S");
            }
            return sb.toString();
        }
        return null;
    }

    public static OraINTERVALDS DS_ISO8601parse(CharSequence text) {
        OraINTERVALDS interval = OraINTERVALDS.getInstance();
        if (text != null) {
            Matcher matcher = DS_PATTERN.matcher(text);
            if (matcher.matches()) {
                boolean negate = "-".equals(matcher.group(1));
                String daysMatch = matcher.group(2);
                String timeMatch = matcher.group(3);
                String hoursMatch = matcher.group(4);
                String minutesMatch = matcher.group(5);
                String secondsMatch = matcher.group(6);
                String nanosMatch = matcher.group(7);
                int sign = negate ? -1 : 1;
                int days = daysMatch != null && daysMatch.length() > 0 ? Integer.valueOf(daysMatch) : 0;
                int hours = hoursMatch != null && hoursMatch.length() > 0 ? Integer.valueOf(hoursMatch) : 0;
                int minutes = minutesMatch != null && minutesMatch.length() > 0 ? Integer.valueOf(minutesMatch) : 0;
                int seconds = secondsMatch != null && secondsMatch.length() > 0 ? Integer.valueOf(secondsMatch) : 0;
                int nanos = TemporalUtil.formatNanos(nanosMatch);
                interval.set(0, sign);
                interval.set(1, days);
                interval.set(2, hours);
                interval.set(3, minutes);
                interval.set(4, seconds);
                interval.set(5, nanos);
            }
        } else {
            return null;
        }
        return interval;
    }

    private static String formatNanos(int nanos) {
        if (nanos == 0) {
            return null;
        }
        String fractionalNanos = String.format("%09d", nanos);
        return fractionalNanos.replaceAll("0*$", "");
    }

    private static int formatNanos(String fractionalNanos) {
        if (fractionalNanos == null || fractionalNanos.length() == 0) {
            return 0;
        }
        fractionalNanos = fractionalNanos + "000000000";
        fractionalNanos = fractionalNanos.substring(0, 9);
        try {
            return Integer.parseInt(fractionalNanos);
        }
        catch (ArithmeticException | NumberFormatException ex) {
            return 0;
        }
    }
}

