/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.util.Arrays;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class SQLPLUSFormatter
extends ResultsFormatter {
    public SQLPLUSFormatter() {
        super("SqlPlus", "SqlPlus File", "sql");
    }

    @Override
    public void start() throws IOException {
        int i;
        StringBuffer header = new StringBuffer();
        int count = this.getColumnCount() + 1;
        for (i = 1; i < count; ++i) {
            char[] chars = new char[this.getColumnSize(i)];
            Arrays.fill(chars, ' ');
            header.append(chars);
            header.append("|");
        }
        this.write(header.toString());
        this.write("\n");
        int ii = header.length();
        for (i = 0; i < ii; ++i) {
            this.write("-");
        }
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        StringBuffer temp = new StringBuffer();
        if (col != null) {
            temp.append(this.getValue(col).toString());
        }
        int colSize = this.getColumnSize(viewIndex);
        if (temp.length() < colSize) {
            char[] chars = new char[colSize - temp.length()];
            Arrays.fill(chars, ' ');
            temp.append(chars);
        }
        temp.append(" ");
        this.write(temp.toString());
    }

    @Override
    public void endRow() throws IOException {
        this.write("\n");
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

