/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class WrapListenBufferOutputStream
extends BufferedOutputStream {
    private BufferedOutputStream m_out = null;
    private ArrayList<BufferedOutputStream> m_alout = new ArrayList();
    private File m_fileOutput = null;
    private boolean m_removeForcePrint = false;
    private ScriptRunnerContext ctx = null;
    private ByteArrayOutputStream blankStore = null;
    private BufferedOutputStream blankBuff = null;
    private static String ENCODING = "UTF-8";
    private boolean bufferEmpty = true;

    public WrapListenBufferOutputStream(OutputStream out) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (out instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)out;
        this.addToList((BufferedOutputStream)out);
    }

    public WrapListenBufferOutputStream(OutputStream out, int size) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()), size);
        assert (out instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)out;
        this.addToList((BufferedOutputStream)out);
    }

    public WrapListenBufferOutputStream(OutputStream out, ScriptRunnerContext ctxin) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (out instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)out;
        this.addToList((BufferedOutputStream)out);
        this.ctx = ctxin;
    }

    public BufferedOutputStream getMainStream() {
        return this.m_out;
    }

    public void writeToNotSpool(byte[] bytes) throws IOException {
        IOException io = null;
        if (this.ctx != null) {
            BufferedOutputStream spool = (BufferedOutputStream)this.ctx.getProperty("Spool.out.buffer");
            this.flush();
            for (BufferedOutputStream buf : this.m_alout) {
                try {
                    if (!this.doIWrite(buf)) continue;
                    if (spool == null) {
                        buf.write(bytes);
                        buf.flush();
                        continue;
                    }
                    if (spool.equals(buf)) continue;
                    buf.write(bytes);
                    buf.flush();
                }
                catch (IOException ioe) {
                    io = ioe;
                }
            }
            if (io != null) {
                throw io;
            }
        }
    }

    private boolean doIWrite(BufferedOutputStream amIMain) {
        Boolean onMaxRows;
        if (this.ctx != null && (onMaxRows = (Boolean)this.ctx.getProperty("sqlcl.spool.spoolonly")) != null) {
            BufferedOutputStream buff = (BufferedOutputStream)this.ctx.getProperty("Spool.out.buffer");
            if (onMaxRows.booleanValue() && buff != null && this.equals(buff)) {
                return true;
            }
            if (onMaxRows.booleanValue() && (buff == null || !buff.equals(amIMain))) {
                return false;
            }
            if (onMaxRows.booleanValue()) {
                return true;
            }
        }
        if (this.ctx != null && !this.ctx.getTopLevel() && this.ctx.isOutputSupressed()) {
            BufferedOutputStream buff = (BufferedOutputStream)this.ctx.getProperty("Spool.out.buffer");
            return buff != null && (this.equals(buff) || amIMain.equals(buff));
        }
        return true;
    }

    public void replaceMainStream(BufferedOutputStream newMain) throws IOException {
        if (!this.m_out.equals(newMain)) {
            this.flush();
            this.removeFromList(this.m_out);
            this.addToList(newMain);
            this.m_out = newMain;
        }
    }

    public void addToList(BufferedOutputStream bo) {
        this.m_alout.add(bo);
    }

    public boolean removeFromList(BufferedOutputStream bo) {
        return this.m_alout.remove(bo);
    }

    @Override
    public void flush() throws IOException {
        IOException io = null;
        for (BufferedOutputStream buf : this.m_alout) {
            try {
                buf.flush();
            }
            catch (IOException ioe) {
                io = ioe;
            }
        }
        if (io != null) {
            throw io;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkForExit();
        if (len != 0) {
            if (this.ctx != null && (Boolean)this.ctx.getProperty("script.runner.settrimspool") != null && Boolean.valueOf(this.ctx.getProperty("script.runner.settrimspool").equals(Boolean.TRUE)).booleanValue() && this.ctx.getProperty("Spool.out.buffer") != null && this.ctx.getProperty("Spool.out.buffer").equals(this) || !this.bufferEmpty) {
                if (this.blankStore == null) {
                    this.blankStore = new ByteArrayOutputStream();
                }
                if (this.blankBuff == null) {
                    this.blankBuff = new BufferedOutputStream(this.blankStore);
                }
                StringBuffer stringStore = new StringBuffer("");
                byte[] toByte = new byte[len];
                System.arraycopy(b, off, toByte, 0, len);
                String current = new String(toByte, ENCODING);
                block10: for (int i = 0; i < current.length(); ++i) {
                    String thisOne;
                    switch (thisOne = current.substring(i, i + 1)) {
                        case "\r": 
                        case "\n": {
                            this.blankStore = new ByteArrayOutputStream();
                            this.blankBuff = new BufferedOutputStream(this.blankStore);
                            stringStore.append(thisOne);
                            this.bufferEmpty = true;
                            continue block10;
                        }
                        case "\t": 
                        case " ": {
                            this.blankStore.write(thisOne.getBytes(Charset.forName(ENCODING)));
                            this.bufferEmpty = false;
                            continue block10;
                        }
                        default: {
                            this.blankBuff.flush();
                            byte[] bA = this.blankStore.toByteArray();
                            this.blankStore = new ByteArrayOutputStream();
                            this.blankBuff = new BufferedOutputStream(this.blankStore);
                            this.bufferEmpty = true;
                            if (bA.length > 0) {
                                stringStore.append(new String(bA, ENCODING));
                            }
                            stringStore.append(thisOne);
                        }
                    }
                }
                if (stringStore.length() > 0) {
                    byte[] myBytes = stringStore.toString().getBytes(Charset.forName(ENCODING));
                    this.reallywrite(myBytes, 0, myBytes.length);
                }
            } else {
                this.reallywrite(b, off, len);
            }
        }
    }

    public void reallywrite(byte[] b, int off, int len) throws IOException {
        for (BufferedOutputStream buf : this.m_alout) {
            IOException io = null;
            try {
                if (this.doIWrite(buf)) {
                    buf.write(b, off, len);
                }
            }
            catch (IOException ioe) {
                io = ioe;
            }
            if (io == null) continue;
            throw io;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkForExit();
        byte[] b1 = new byte[]{(byte)b};
        this.write(b1, 0, 1);
    }

    @Override
    public void close() throws IOException {
        for (BufferedOutputStream buf : this.m_alout) {
            IOException io = null;
            try {
                buf.close();
            }
            catch (IOException ioe) {
                io = ioe;
            }
            if (io == null) continue;
            throw io;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkForExit();
        if (this.ctx != null && (Boolean)this.ctx.getProperty("script.runner.settrimspool") != null && Boolean.valueOf(this.ctx.getProperty("script.runner.settrimspool").equals(Boolean.TRUE)).booleanValue() && this.ctx.getProperty("Spool.out.buffer") != null && this.ctx.getProperty("Spool.out.buffer").equals(this) || !this.bufferEmpty) {
            if (!this.m_removeForcePrint || !Arrays.equals("force_print".getBytes("UTF8"), b) && !Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, b)) {
                this.write(b, 0, b.length);
            }
        } else {
            for (BufferedOutputStream buf : this.m_alout) {
                IOException io = null;
                try {
                    if ((!this.m_removeForcePrint || !Arrays.equals("force_print".getBytes("UTF8"), b) && !Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, b)) && this.doIWrite(buf)) {
                        buf.write(b);
                    }
                }
                catch (IOException ioe) {
                    io = ioe;
                }
                if (io == null) continue;
                throw io;
            }
        }
    }

    protected void checkForExit() throws IOException {
        if (this.ctx != null && this.ctx.isCommandLine() && this.ctx.isInterrupted()) {
            throw new InterruptedIOException();
        }
    }

    public File getFileOutput() {
        return this.m_fileOutput;
    }

    public void setFileOutput(File fileOutput) {
        this.m_fileOutput = fileOutput;
    }

    public boolean isRemoveForcePrint() {
        return this.m_removeForcePrint;
    }

    public void setRemoveForcePrint(boolean forcePrint) {
        this.m_removeForcePrint = forcePrint;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.ctx;
    }
}

