/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Messages;
import oracle.dbtools.raptor.query.Bind;

public class AliasCommand
extends CommandListener
implements IHelp {
    private static String LIST = "list";
    private static String DROP = "drop";
    private static String ALIAS = "alias";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static String DESC = "desc";

    @Override
    public String getCommand() {
        return "ALIAS";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int i;
        Iterator<String> it;
        ArrayList<String> aliases;
        String[] tokens = cmd.getSql().trim().split("[ \t\n]+");
        if (tokens.length <= 0) return false;
        String query = null;
        if (!tokens[0].toLowerCase().equals(this.getCommandName())) return false;
        if (tokens.length == 1) {
            ArrayList<String> aliases2 = Aliases.getInstance().getAliases();
            Iterator<String> it2 = aliases2.iterator();
            while (it2.hasNext()) {
                ctx.write(it2.next() + "\n");
            }
            return this.handleReturn(true);
        }
        if (tokens.length <= 1) {
            ctx.write(Messages.getString("AliasCommand.32"));
            ctx.write(this.getHelp());
            return this.handleReturn(true);
        }
        String key = "";
        if (tokens[1].toLowerCase().equals(DROP)) {
            if (tokens.length == 3) {
                ctx.write(Aliases.getInstance().drop(tokens[2]) + "\n");
                return this.handleReturn(true);
            }
            ctx.write(Messages.getString("AliasCommand.21"));
            return true;
        }
        if (tokens[1].toLowerCase().equals(DESC)) {
            String alias = "";
            if (tokens.length > 2) {
                alias = tokens[2];
            }
            if (tokens.length < 4) {
                ctx.write(MessageFormat.format("ALIAS-22: {0} Not enough arguments", alias));
                return false;
            }
            ArrayList<String> aliases3 = Aliases.getInstance().getAliases();
            if (!aliases3.contains(alias)) return false;
            Alias a = Aliases.getInstance().get(alias);
            String newValue = "";
            int i2 = 0;
            while (true) {
                if (i2 >= 3) {
                    a.setDesc(newValue);
                    return true;
                }
                newValue = cmd.getSql().substring(cmd.getSql().indexOf(" ") + 1);
                ++i2;
            }
        }
        if (tokens[1].toLowerCase().equals(LIST)) {
            String alias = "";
            aliases = Aliases.getInstance().getAliases();
            if (tokens.length > 2 && tokens[2].length() > 0) {
                alias = tokens[2];
                if (!aliases.contains(alias)) {
                    ctx.write(MessageFormat.format(Messages.getString("AliasCommand.27"), alias));
                    return this.handleReturn(true);
                }
                String aliasdesc = alias;
                if (Aliases.getInstance().get(alias).getDesc().length() > 0) {
                    aliasdesc = alias + " - " + Aliases.getInstance().get(alias).getDesc();
                }
                String line = new String(new char[aliasdesc.length()]).replace("\u0000", "-");
                ctx.write(MessageFormat.format("{0}\n{1}\n\n", aliasdesc, line));
                ctx.write(Aliases.getInstance().get(alias).getQuery() + "\n\n");
                return this.handleReturn(true);
            }
            it = aliases.iterator();
            i = 0;
            while (it.hasNext()) {
                String a = it.next().trim();
                if (a.length() <= i) continue;
                i = a.length();
            }
        } else {
            if (tokens[1].toLowerCase().equals(SAVE)) {
                if (ctx.getProperty("script.runner.jline") == null) {
                    ctx.write(Messages.getString("AliasCommand.29"));
                    return this.handleReturn(true);
                }
                if (tokens.length > 2 && tokens[2] != null) {
                    ctx.write(Aliases.getInstance().save(tokens[2]));
                    return this.handleReturn(true);
                }
                ctx.write(Aliases.getInstance().save());
                return this.handleReturn(true);
            }
            if (tokens[1].toLowerCase().equals(LOAD)) {
                if (ctx.getProperty("script.runner.jline") == null) {
                    ctx.write(Messages.getString("AliasCommand.30"));
                    return this.handleReturn(true);
                }
                if (tokens.length > 2 && tokens[2] != null) {
                    ctx.write(Aliases.getInstance().load(tokens[2]));
                    return this.handleReturn(true);
                }
                ctx.write(Aliases.getInstance().load());
                return this.handleReturn(true);
            }
            if (cmd.getSql().contains("=") && !tokens[1].startsWith("=")) {
                String[] preEqSplit = cmd.getSql().trim().split("=")[0].split("\\s+");
                key = preEqSplit[1];
                if (preEqSplit.length > 2) {
                    key = key + preEqSplit[2];
                }
                if (key.equalsIgnoreCase("alias")) {
                    ctx.write(Messages.getString("AliasCommand.10"));
                    return true;
                }
                String payload = cmd.getSql().substring(cmd.getSql().toLowerCase().indexOf("=") + 1).trim();
                if (payload.startsWith(":")) {
                    if (payload.length() > 1) {
                        payload = payload.substring(1);
                        Bind b = ctx.getVarMap().get(payload.toUpperCase());
                        if (b != null) {
                            query = b.getValue();
                        }
                    }
                    if (query == null || query.equals("")) {
                        ctx.write(Messages.getString("AliasCommand.16"));
                        return this.handleReturn(true);
                    }
                } else {
                    String payloadUpper = payload.toUpperCase();
                    if (payload.length() > 5 && payloadUpper.startsWith("Q'") && payload.endsWith(ScriptParser.getEndQuoteString(payload.substring(2, 3)) + "'")) {
                        payload = payload.substring(3, payload.length() - 2);
                    } else if (payload == null || payload.equals("")) {
                        ctx.write(Messages.getString("AliasCommand.20"));
                        return this.handleReturn(true);
                    }
                    query = payload;
                }
                Aliases.getInstance().add(key, query);
                return this.handleReturn(true);
            }
            ctx.write(Messages.getString("AliasCommand.31"));
            return this.handleReturn(true);
        }
        it = aliases.iterator();
        while (it.hasNext()) {
            String x = it.next();
            Alias a = Aliases.getInstance().get(x);
            x = i < 30 ? String.format("%0$-" + i + "s", x) : String.format("%0$-30s", x);
            if (a.getDesc().length() > 0) {
                ctx.write(x + " - " + a.getDesc() + "\n");
                continue;
            }
            ctx.write(x + "\n");
        }
        return this.handleReturn(true);
    }

    public String getCommandName() {
        return ALIAS;
    }

    boolean handleReturn(boolean b) {
        if (!b) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

