/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowAppicmd
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWAPPICMD = new String[]{"appi", "appin", "appinf", "appinfo"};

    @Override
    public String[] getShowAliases() {
        return SHOWAPPICMD;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowAppicmd(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAppicmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            String appiString;
            String appinfoValue = SetAppinfo.APPINFO;
            boolean appi = (Boolean)ctx.getProperty("script.runner.appinfo");
            String string = appiString = ctx.getProperty("script.runner.appinfostring") != null ? String.valueOf(ctx.getProperty("script.runner.appinfostring")) : null;
            if (appiString == null) {
                appiString = SQLPLUS.PRODUCT_NAME;
            }
            String onOrOff = "OFF";
            appinfoValue = !appi ? appiString : this.newValue(ctx, appinfoValue);
            if (ctx.getProperty("script.runner.appinfo") != null && Boolean.valueOf(ctx.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
                onOrOff = "ON";
            }
            ctx.write(MessageFormat.format(Messages.getString("APPINFO"), onOrOff, appinfoValue) + "\n");
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newValue(ScriptRunnerContext ctx, String appinfoValue) throws SQLException {
        if (ctx.getCurrentConnection() instanceof OracleConnection && !ctx.getCurrentConnection().isClosed()) {
            CallableStatement myCallable = null;
            if (LockManager.lock(ctx.getCurrentConnection())) {
                try {
                    myCallable = ctx.getCurrentConnection().prepareCall("BEGIN DBMS_APPLICATION_INFO.READ_MODULE(:MOD, :ACT); END;");
                    myCallable.registerOutParameter(1, 12);
                    myCallable.registerOutParameter(2, 12);
                    myCallable.execute();
                    appinfoValue = myCallable.getString(1);
                }
                finally {
                    if (myCallable != null) {
                        try {
                            myCallable.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        LockManager.unlock(ctx.getCurrentConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return appinfoValue;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String store = "";
        try {
            String appinfoValue = "";
            boolean appi = (Boolean)ctx.getProperty("script.runner.appinfo");
            String onOrOff = "OFF";
            appinfoValue = !appi ? SQLPLUS.PRODUCT_NAME : this.newValue(ctx, appinfoValue);
            if (ctx.getProperty("script.runner.appinfo") != null && Boolean.valueOf(ctx.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
                onOrOff = "ON";
            }
            store = MessageFormat.format("set appinfo {0}\n", onOrOff);
            store = store + MessageFormat.format("set appinfo \"{0}\"\n", appinfoValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return store;
    }
}

