/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.jdbc.OracleConnection;

public class ShowConnection
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWCONNECTION = new String[]{"connection"};

    @Override
    public String[] getShowAliases() {
        return SHOWCONNECTION;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowConnection(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doShowConnection(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        StringBuffer sb;
        block9: {
            sb = new StringBuffer();
            try {
                if (conn == null || !LockManager.lock(conn)) break block9;
                try {
                    DatabaseMetaData dbmd = conn.getMetaData();
                    String url = dbmd.getURL();
                    String user = dbmd.getUserName();
                    String role = ctx.getPrivilege(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString());
                    String conid = ctx.getConnectionID(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString());
                    String version = dbmd.getDatabaseProductVersion();
                    ctx.write("CONNECTION:\n " + user + "@" + url + " " + role + "\n");
                    if (conid != null && !conid.equals("")) {
                        ctx.write("CONNECTION_IDENTIFIER:\n " + conid + "\n");
                    }
                    if (!(version == null || version.equals("") || ctx.getProperty("script.runner.PRELIM_AUTH") != null && Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)).booleanValue())) {
                        ctx.write("CONNECTION_DB_VERSION:\n " + version.replace("\n", "\n ") + "\n");
                    }
                    Boolean nologBool = (Boolean)ctx.getProperty("script.runner.sqlplus.nolog");
                    String nologReport = "false";
                    if (nologBool != null && nologBool.equals(Boolean.TRUE)) {
                        nologReport = "true";
                    }
                    ctx.write("NOLOG:\n " + nologReport);
                    Boolean prelimAuth = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                    String prelimAuthReport = "false";
                    if (prelimAuth != null && prelimAuth.equals(Boolean.TRUE)) {
                        prelimAuthReport = "true";
                    }
                    ctx.write("\nPRELIMAUTH:\n " + prelimAuthReport + "\n");
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (Exception e) {
                sb.append("\nUnable to gather information\n");
            }
        }
        ctx.write(sb.toString());
        return true;
    }
}

