/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowDescribe
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWDESCRIBE = new String[]{"desc", "descr", "descri", "describ", "describe"};
    private static final String COMMAND_DEPTH = "DEPTH";
    private static final String COMMAND_LINENUM = "LINENUM";
    private static final String COMMAND_INDENT = "INDENT";

    @Override
    public String[] getShowAliases() {
        return SHOWDESCRIBE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowDescribe(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowDescribe(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        HashMap properties = (HashMap)ctx.getProperty("script.runner.setdescribe");
        int depth = (Integer)properties.get(COMMAND_DEPTH);
        boolean linenum = (Boolean)properties.get(COMMAND_LINENUM);
        boolean indent = (Boolean)properties.get(COMMAND_INDENT);
        String str = MessageFormat.format(Messages.getString("SHOW_DESCRIBE"), String.valueOf(depth), linenum ? "ON" : "OFF", indent ? "ON" : "OFF") + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("describe", String.valueOf(ctx.getProperty("script.runner.setdescribe")));
    }
}

