/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.util.Encodings;
import oracle.jdbc.OracleConnection;

public class ShowEncodings
implements IShowCommand {
    private static final String[] SHOWENCODINGS = new String[]{"encodings"};

    @Override
    public String[] getShowAliases() {
        return SHOWENCODINGS;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEncodings(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowEncodings(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getEncoding() != null) {
                ctx.write("current Encoding:" + ctx.getEncoding() + "\n");
            }
            ctx.write(this.listAvailableEncodings());
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    private String listAvailableEncodings() {
        String[] encodings = Encodings.getEncodingsWithoutAlias();
        StringBuffer sb = new StringBuffer("List of available encodings:\n");
        int count = 0;
        for (String encoding : encodings) {
            if (++count != 1) {
                sb.append("\n");
            }
            sb.append(encoding);
        }
        return sb.toString();
    }
}

