/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowNull
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNULL = new String[]{"null"};

    @Override
    public String[] getShowAliases() {
        return SHOWNULL;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowNull(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowNull(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            String format = ctx.getProperties().containsKey("script.runner.setnull") && ctx.getProperties().get("script.runner.setnull") != null ? "\"" + (String)ctx.getProperties().get("script.runner.setnull") + "\"" : Messages.getString("NOTSET");
            ctx.write(MessageFormat.format(Messages.getString("SETNULL"), format) + "\n");
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage() + "\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String format = ctx.getProperties().containsKey("script.runner.setnull") && ctx.getProperties().get("script.runner.setnull") != null ? "\"" + (String)ctx.getProperties().get("script.runner.setnull") + "\"" : Messages.getString("NOTSET");
        return StoreRegistry.getCommand("null", format);
    }
}

