/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.util.Logger;

class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static final String NS_PROXY_AUTO_CONFIG_URL = "META-INF/nsProxyAutoConfig.js";
    private Invocable inv = null;
    private RaptorTask<Invocable> initTask;
    private final URI pacURI;
    public static final String DIRECT = "DIRECT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ProxyAutoConfig get(String pacFile) {
        if (file2pac.get(pacFile) == null) {
            Logger.fine(ProxyAutoConfig.class, "Init ProxyAutoConfig for " + pacFile);
            ProxyAutoConfig instance = null;
            try {
                instance = new ProxyAutoConfig(pacFile);
            }
            catch (URISyntaxException ex) {
                Logger.warn(ProxyAutoConfig.class, "Parsing " + pacFile + " to URI throws " + ex);
            }
            finally {
                file2pac.put(pacFile, instance);
            }
        }
        return file2pac.get(pacFile);
    }

    private ProxyAutoConfig(String pacURL) throws URISyntaxException {
        assert (file2pac.get(pacURL) == null) : "Only once object for " + pacURL + " must exist.";
        String normPAC = this.normalizePAC(pacURL);
        this.pacURI = new URI(normPAC);
        this.initTask = new InitTask(pacURL);
        RaptorTaskManager.getInstance().addTask(this.initTask);
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Proxy> findProxyForURL(URI u) {
        ProxyAutoConfig proxyAutoConfig = this;
        synchronized (proxyAutoConfig) {
            if (this.initTask != null) {
                try {
                    this.inv = this.initTask.getResult();
                }
                catch (InterruptedException e) {
                    Logger.warn(ProxyAutoConfig.class, "While loading PAC: " + e);
                }
                catch (ExecutionException e) {
                    Logger.warn(ProxyAutoConfig.class, "While loading PAC: " + e);
                }
                this.initTask = null;
            }
        }
        if (this.inv == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        Object proxies = null;
        try {
            proxies = this.inv.invokeFunction("FindProxyForURL", u.toString(), u.getHost());
        }
        catch (ScriptException ex) {
            Logger.fine(ProxyAutoConfig.class, "While invoking FindProxyForURL(" + u + ", " + u.getHost() + " thrown " + ex, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.fine(ProxyAutoConfig.class, "While invoking FindProxyForURL(" + u + ", " + u.getHost() + " thrown " + ex, ex);
        }
        List<Proxy> res = this.analyzeResult(u, proxies);
        if (res == null) {
            Logger.info(ProxyAutoConfig.class, "findProxyForURL(" + u + ") returns null.");
            res = Collections.emptyList();
        }
        Logger.fine(ProxyAutoConfig.class, "findProxyForURL(" + u + ") returns " + Arrays.asList(res));
        return res;
    }

    private static InputStream downloadPAC(String pacURL) throws IOException {
        InputStream is = null;
        URL url = null;
        try {
            url = new URL(pacURL);
        }
        catch (MalformedURLException ex) {
            Logger.info(ProxyAutoConfig.class, "Malformed " + pacURL, ex);
            return null;
        }
        URLConnection conn = url.openConnection(Proxy.NO_PROXY);
        is = conn.getInputStream();
        return is;
    }

    private static ScriptEngine evalPAC(InputStream is, String utils) throws FileNotFoundException, ScriptException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        InputStreamReader pacReader = new InputStreamReader(is);
        engine.eval(pacReader);
        engine.eval(utils);
        return engine;
    }

    private List<Proxy> analyzeResult(URI uri, Object proxiesString) {
        if (proxiesString == null) {
            Logger.fine(ProxyAutoConfig.class, "Null result for " + uri);
            return null;
        }
        String protocol = uri.getScheme();
        if (protocol == null) {
            return null;
        }
        Proxy.Type proxyType = "http".equals(protocol) || "https".equals(protocol) ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
        StringTokenizer st = new StringTokenizer(proxiesString.toString(), ";");
        LinkedList<Proxy> proxies = new LinkedList<Proxy>();
        while (st.hasMoreTokens()) {
            String proxy = st.nextToken();
            if (DIRECT.equals(proxy.trim())) {
                proxies.add(Proxy.NO_PROXY);
                continue;
            }
            String host = ProxyAutoConfig.getHost(proxy);
            Integer port = ProxyAutoConfig.getPort(proxy);
            if (host == null || port == null) continue;
            proxies.add(new Proxy(proxyType, new InetSocketAddress(host, (int)port)));
        }
        return proxies;
    }

    private static String getHost(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            Logger.info(ProxyAutoConfig.class, "No port in " + proxy);
            return null;
        }
        String host = proxy.substring(0, i);
        return ProxyAutoConfig.normalizeProxyHost(host);
    }

    private static Integer getPort(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            Logger.info(ProxyAutoConfig.class, "No port in " + proxy);
            return null;
        }
        String port = proxy.substring(i + 1);
        if (port.indexOf(47) >= 0) {
            port = port.substring(0, port.indexOf(47));
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            Logger.info(ProxyAutoConfig.class, ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    private static String downloadUtils() {
        StringBuilder builder = new StringBuilder();
        URL url = ProxyAutoConfig.class.getClassLoader().getResource(NS_PROXY_AUTO_CONFIG_URL);
        if (url != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line = null;
                boolean doAppend = false;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("var pacUtils =")) {
                        doAppend = true;
                    }
                    if (!doAppend) continue;
                    if (line.endsWith("+")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    builder.append(line.replaceAll("\"", "").replaceAll("\\\\n", "").replaceAll("\\\\\\\\", "\\\\"));
                    builder.append(System.getProperty("line.separator"));
                }
            }
            catch (IOException ex) {
                Logger.info(ProxyAutoConfig.class, "While downloading nsProxyAutoConfig.js thrown " + ex.getMessage(), ex);
            }
        }
        return builder.toString();
    }

    private String normalizePAC(String pacURL) {
        int index = pacURL.indexOf("\n");
        if (index != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((index = pacURL.indexOf("\r")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((index = pacURL.indexOf(" ")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        return pacURL.trim();
    }

    public static String normalizeProxyHost(String proxyHost) {
        if (proxyHost.toLowerCase(Locale.US).startsWith("http://")) {
            return proxyHost.substring(7, proxyHost.length());
        }
        return proxyHost;
    }

    private static final class InitTask
    extends RaptorTask<Invocable> {
        final String pacURL;

        InitTask(String pacURL) {
            super("load PAC", true, IRaptorTaskRunMode.NO_GUI);
            this.setCancellable(false);
            this.setPausable(false);
            this.pacURL = pacURL;
        }

        @Override
        protected Invocable doWork() throws TaskException {
            ScriptEngine eng = null;
            try (InputStream pacIS = ProxyAutoConfig.downloadPAC(this.pacURL);){
                if (pacIS != null) {
                    String utils = ProxyAutoConfig.downloadUtils();
                    eng = ProxyAutoConfig.evalPAC(pacIS, utils);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.fine(ProxyAutoConfig.class, "While constructing ProxyAutoConfig thrown " + ex, ex);
                return null;
            }
            catch (ScriptException ex) {
                Logger.fine(ProxyAutoConfig.class, "While constructing ProxyAutoConfig thrown " + ex, ex);
                return null;
            }
            catch (IOException ex) {
                Logger.fine(ProxyAutoConfig.class, "While constructing ProxyAutoConfig thrown " + ex, ex);
                return null;
            }
            if (eng == null) {
                Logger.warn(ProxyAutoConfig.class, "JavaScript engine cannot be null");
                return null;
            }
            return (Invocable)((Object)eng);
        }
    }
}

