/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.query.db.QueryItem;

public class QueryDB {
    private static QueryDB INSTANCE;
    private Object LOCK = new Object();
    private long SEQ = 0L;
    private Map<String, Long> QI_CHECKSUM_CACHE = new HashMap<String, Long>();
    private Map<Long, QueryItem> QI_CACHE = new HashMap<Long, QueryItem>();

    public static synchronized QueryDB getDatabase() {
        if (INSTANCE == null) {
            INSTANCE = new QueryDB();
        }
        return INSTANCE;
    }

    private QueryDB() {
    }

    public QueryItem getNewQueryItem() {
        QueryItem ret = new QueryItem();
        this.put(ret);
        return ret;
    }

    public QueryItem get(long id) {
        return this.QI_CACHE.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueryItem item) {
        Object object = this.LOCK;
        synchronized (object) {
            if (item.getPk() == null) {
                item.setPk(this.SEQ++);
            }
            this.QI_CACHE.put(item.getPk(), item);
            if (item.getChecksum() != null) {
                this.QI_CHECKSUM_CACHE.put(item.getChecksum(), item.getPk());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncate() {
        Object object = this.LOCK;
        synchronized (object) {
            int size = this.QI_CACHE.size();
            this.QI_CACHE.clear();
            return size;
        }
    }

    public long getRowCount() {
        return this.QI_CACHE.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryItem findSharedQuery(String shareId) {
        QueryItem ret = null;
        if (shareId != null) {
            Object object = this.LOCK;
            synchronized (object) {
                Collection<QueryItem> qis = this.QI_CACHE.values();
                for (QueryItem qi : qis) {
                    if (!shareId.equals(qi.getId())) continue;
                    ret = qi;
                    break;
                }
            }
        }
        return ret;
    }

    public boolean containsChecksum(String md) {
        return this.QI_CHECKSUM_CACHE.containsKey(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSeq() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.SEQ++;
        }
    }
}

