/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

public class Array {
    public static void main(String[] args) throws Exception {
        int i;
        int size = 1000000;
        int[] a = new int[size / 2];
        int[] b = new int[size / 2];
        for (i = 0; i < a.length; ++i) {
            a[i] = 2 * i;
        }
        for (i = 0; i < b.length; ++i) {
            a[i] = 2 * i + 1;
        }
        long t1 = System.nanoTime();
        Array.merge(a, b);
        System.out.println(System.nanoTime() - t1);
    }

    public static int indexOf(int[] array, int value) {
        return Array.indexOf(array, 0, array.length - 1, value);
    }

    public static int indexOf(long[] array, long value) {
        return Array.indexOf(array, 0, array.length - 1, value);
    }

    private static int indexOf(int[] array, int x, int y, int value) {
        if (x + 1 == y || x == y) {
            return array[x] < value ? y : x;
        }
        int mid = (x + y) / 2;
        if (value < array[mid]) {
            return Array.indexOf(array, x, mid, value);
        }
        return Array.indexOf(array, mid, y, value);
    }

    private static int indexOf(long[] array, int x, int y, long value) {
        if (x + 1 == y || x == y) {
            return array[x] < value ? y : x;
        }
        int mid = (x + y) / 2;
        if (value < array[mid]) {
            return Array.indexOf(array, x, mid, value);
        }
        return Array.indexOf(array, mid, y, value);
    }

    public static int[] insert(int[] array, int value) {
        int i;
        if (array == null || array.length == 0) {
            array = new int[]{value};
            return array;
        }
        int index = Array.indexOf(array, 0, array.length, value);
        if (index < array.length && array[index] == value) {
            return array;
        }
        int[] ret = new int[array.length + 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        ret[index] = value;
        for (i = index + 1; i < ret.length; ++i) {
            ret[i] = array[i - 1];
        }
        return ret;
    }

    public static long[] insert(long[] array, long value) {
        int i;
        if (array == null || array.length == 0) {
            array = new long[]{value};
            return array;
        }
        int index = Array.indexOf(array, 0, array.length, value);
        if (index < array.length && array[index] == value) {
            return array;
        }
        long[] ret = new long[array.length + 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        ret[index] = value;
        for (i = index + 1; i < ret.length; ++i) {
            ret[i] = array[i - 1];
        }
        return ret;
    }

    public static int[] delete(int[] array, int value) {
        int i;
        int index = Array.indexOf(array, 0, array.length, value);
        if (index == array.length || array[index] != value) {
            return array;
        }
        int[] ret = new int[array.length - 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        for (i = index; i < ret.length; ++i) {
            ret[i] = array[i + 1];
        }
        return ret;
    }

    public static int[] merge(int[] x, int[] y) {
        int p;
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        int m = x.length;
        int n = y.length;
        int[] tmp = new int[m + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m && j < n) {
            if (x[i] == y[j]) {
                tmp[k++] = x[i++];
                ++j;
                continue;
            }
            if (x[i] < y[j]) {
                tmp[k++] = x[i++];
                continue;
            }
            tmp[k++] = y[j++];
        }
        if (i < m) {
            for (p = i; p < m; ++p) {
                tmp[k++] = x[p];
            }
        } else {
            for (p = j; p < n; ++p) {
                tmp[k++] = y[p];
            }
        }
        int[] ret = new int[k];
        for (int ii = 0; ii < k; ++ii) {
            ret[ii] = tmp[ii];
        }
        return ret;
    }

    public static long[] merge(long[] x, long[] y) {
        int p;
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        int m = x.length;
        int n = y.length;
        long[] tmp = new long[m + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m && j < n) {
            if (x[i] == y[j]) {
                tmp[k++] = x[i++];
                ++j;
                continue;
            }
            if (x[i] < y[j]) {
                tmp[k++] = x[i++];
                continue;
            }
            tmp[k++] = y[j++];
        }
        if (i < m) {
            for (p = i; p < m; ++p) {
                tmp[k++] = x[p];
            }
        } else {
            for (p = j; p < n; ++p) {
                tmp[k++] = y[p];
            }
        }
        long[] ret = new long[k];
        for (int ii = 0; ii < k; ++ii) {
            ret[ii] = tmp[ii];
        }
        return ret;
    }

    public static boolean next(int[] state, int[] limit) {
        return Array.next(state, limit, 0);
    }

    public static boolean next(int[] state, int[] limit, int init) {
        for (int pos = 0; pos < state.length; ++pos) {
            if (state[pos] < limit[pos] - 1) {
                int n = pos;
                state[n] = state[n] + 1;
                return true;
            }
            state[pos] = init;
        }
        return false;
    }
}

