/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.parser.java.v2.classfile.ClassFile;

public class ClassFiles {
    private static final int PUBLIC_OR_PROTECTED = 5;
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    static Constructor<ClassFile> classFileConstructor;
    private static byte[] bytes;
    static long maxTypeSize;
    static int typeCount;
    static long sumTypeSize;

    public static int getTypeCount() {
        return typeCount;
    }

    public static long getAverageTypeSize() {
        return typeCount > 0 ? sumTypeSize / (long)typeCount : 0L;
    }

    public static long getMaxTypeSize() {
        return maxTypeSize;
    }

    private ClassFiles() {
    }

    static boolean publicOrProtected(int modifiers) {
        return (5 & modifiers) != 0;
    }

    static boolean bridge(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    static ClassFile readClassFile(Path path, SeekableByteChannel openChannel) throws IOException {
        int size;
        try (SeekableByteChannel channel = openChannel != null ? openChannel : Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuffer buffer;
            int count;
            long longSize = channel.size();
            if (longSize > 0x7FFFFFF7L) {
                throw new IOException("Size " + longSize + " of " + path + " too close to Integer.MAX_VALUE");
            }
            if (longSize > maxTypeSize) {
                maxTypeSize = longSize;
            }
            sumTypeSize += longSize;
            ++typeCount;
            size = (int)longSize;
            int capacity = bytes.length;
            if (size > capacity) {
                while (size > (capacity *= 2)) {
                }
                bytes = new byte[capacity];
            }
            if ((count = channel.read(buffer = ByteBuffer.wrap(bytes, 0, size))) != size) {
                throw new IOException("Expected " + size + " but got " + count + " bytes from " + path);
            }
        }
        if (classFileConstructor == null) {
            try {
                classFileConstructor = ClassFile.class.getDeclaredConstructor(byte[].class, Integer.TYPE, URL.class);
                classFileConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Exception getting ClassFile(byte[],int,URL) constructor: " + e, e);
            }
        }
        try {
            return classFileConstructor.newInstance(bytes, size, null);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException("Exception creating ClassFile for " + path + ": " + e, e);
        }
    }

    static MethodDescriptor parseMethodDescriptor(ClassPathModel.Type type, String name, String descriptor) {
        return new MethodDescriptor(type, name, descriptor);
    }

    static String parseFieldDescriptor(String descriptor) {
        StringBuilder builder = new StringBuilder();
        int i = ClassFiles.parseFieldDescriptor(descriptor, 0, builder);
        if (++i != descriptor.length()) {
            throw new IllegalStateException("malformed descriptor " + descriptor);
        }
        return builder.toString();
    }

    private static int parseFieldDescriptor(String descriptor, int i, StringBuilder builder) {
        if (i >= descriptor.length()) {
            throw new IllegalStateException("malformed descriptor " + descriptor);
        }
        block0 : switch (descriptor.charAt(i)) {
            case 'B': {
                builder.append("byte");
                break;
            }
            case 'C': {
                builder.append("char");
                break;
            }
            case 'D': {
                builder.append("double");
                break;
            }
            case 'F': {
                builder.append("float");
                break;
            }
            case 'I': {
                builder.append("int");
                break;
            }
            case 'J': {
                builder.append("long");
                break;
            }
            case 'S': {
                builder.append("short");
                break;
            }
            case 'Z': {
                builder.append("boolean");
                break;
            }
            case 'L': {
                while (true) {
                    if (++i >= descriptor.length()) {
                        throw new IllegalStateException("malformed descriptor " + descriptor);
                    }
                    char c = descriptor.charAt(i);
                    if (c == ';') break block0;
                    builder.append(c);
                }
            }
            case '[': {
                i = ClassFiles.parseFieldDescriptor(descriptor, i + 1, builder);
                builder.append("[]");
            }
        }
        return i;
    }

    static {
        bytes = new byte[131072];
    }

    static class MethodDescriptor {
        private String methodName;
        private ArrayList<String> parameterTypeNames;
        private String returnTypeName;

        private MethodDescriptor(ClassPathModel.Type type, String name, String descriptor) {
            StringBuilder builder;
            int length = descriptor.length();
            this.methodName = name;
            this.parameterTypeNames = new ArrayList();
            int i = 0;
            if (i >= length) {
                throw new IllegalStateException("malformed descriptor " + descriptor);
            }
            if (descriptor.charAt(i) != '(') {
                throw new IllegalStateException("malformed descriptor " + descriptor);
            }
            if (++i >= length) {
                throw new IllegalStateException("malformed descriptor " + descriptor);
            }
            if (this.methodName.isEmpty() && type.isNonStaticInnerClass()) {
                if (descriptor.charAt(i) == ')') {
                    return;
                }
                builder = new StringBuilder();
                i = ClassFiles.parseFieldDescriptor(descriptor, i, builder);
                if (++i >= length) {
                    throw new IllegalStateException("malformed descriptor " + descriptor);
                }
                String typeName = builder.toString();
                if (!type.getOuterType().getFullName().equals(typeName.replace('/', '.').replace('$', '.'))) {
                    this.parameterTypeNames.add(typeName);
                }
            }
            while (descriptor.charAt(i) != ')') {
                builder = new StringBuilder();
                i = ClassFiles.parseFieldDescriptor(descriptor, i, builder);
                if (++i >= length) {
                    throw new IllegalStateException("malformed descriptor " + descriptor);
                }
                this.parameterTypeNames.add(builder.toString());
            }
            if (++i == length) {
                throw new IllegalStateException("malformed descriptor " + descriptor);
            }
            if (descriptor.charAt(i) == 'V' && i + 1 == length) {
                this.returnTypeName = "void";
            } else {
                builder = new StringBuilder();
                i = ClassFiles.parseFieldDescriptor(descriptor, i, builder);
                if (++i != length) {
                    throw new IllegalStateException("malformed descriptor " + descriptor);
                }
                this.returnTypeName = builder.toString();
            }
        }

        String getMethodName() {
            return this.methodName;
        }

        List<String> getParameterTypeNames() {
            return this.parameterTypeNames;
        }

        String getReturnTypeName() {
            return this.returnTypeName;
        }

        boolean matches(String name) {
            if (!name.startsWith(this.methodName)) {
                return false;
            }
            int next = this.methodName.length();
            if (name.charAt(next) != '(') {
                return false;
            }
            block3: for (String typeName : this.parameterTypeNames) {
                int length;
                if (!name.regionMatches(++next, typeName, 0, length = typeName.length())) {
                    return false;
                }
                switch (name.charAt(next += length)) {
                    case ',': {
                        continue block3;
                    }
                }
                return false;
            }
            return next + 1 == name.length();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.methodName).append('(');
            if (!this.parameterTypeNames.isEmpty()) {
                builder.append(this.parameterTypeNames.get(0).replace('/', '.').replace('$', '.'));
                for (int i = 1; i < this.parameterTypeNames.size(); ++i) {
                    builder.append(',').append(this.parameterTypeNames.get(i).replace('/', '.').replace('$', '.'));
                }
            }
            builder.append(')');
            return builder.toString();
        }
    }
}

