/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.ClassFiles;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInterface;
import oracle.javatools.exports.command.CommandLog;
import oracle.javatools.exports.command.ComparisonIterators;
import oracle.javatools.exports.extension.Extension;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.installation.Installation;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryWriter;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.exports.specification.FileExportSpecification;
import oracle.javatools.exports.specification.FileExportSpecificationReader;
import oracle.javatools.exports.uses.Uses;
import org.xml.sax.SAXException;

public class Command {
    private static final Charset PROPERTIES_ENCODING = Charset.forName("ISO-8859-1");
    private static Matcher baselineMatcher;

    public static int execute(CommandInterface ui) throws CommandException {
        long time1 = System.currentTimeMillis();
        Path middlewareHome = ui.getMiddlewareHome();
        if (middlewareHome != null) {
            Path jdeveloper;
            if (!Files.isDirectory(middlewareHome, new LinkOption[0])) {
                ui.error("Middleware home %s not a directory", middlewareHome);
                return 1;
            }
            ui.note("Middleware home %s", middlewareHome);
            Path oracleCommon = middlewareHome.resolve("oracle_common");
            if (!Files.exists(oracleCommon, new LinkOption[0])) {
                ui.warning("Middleware oracle_common directory %s not present", oracleCommon);
            }
            Path wlserver = middlewareHome.resolve("wlserver");
            if (!Files.exists(oracleCommon, new LinkOption[0])) {
                ui.warning("Middleware wlserver directory %s not present", wlserver);
            }
            if (!Files.exists(jdeveloper = middlewareHome.resolve("jdeveloper"), new LinkOption[0])) {
                ui.warning("Middleware jdeveloper directory %s not present", jdeveloper);
            } else {
                Path macros = jdeveloper.resolve("ide/macros");
                if (!Files.isDirectory(macros, new LinkOption[0])) {
                    ui.warning("Middleware jdeveloper macros directory %s not present", macros);
                }
            }
        } else {
            ui.note("No middleware home defined", new Object[0]);
        }
        switch (ui.getOperation()) {
            case GENERATE: {
                if (ui.getClassPath().isEmpty()) {
                    throw new CommandException("generate operation requires %s", ui.parameter("classpath"));
                }
                if (!ui.getLibraries().isEmpty()) {
                    throw new CommandException("generate operation prohibits %s", ui.parameter("libraries"));
                }
                if (ui.getBaseline0() == null && ui.getBaseline1() == null) break;
                throw new CommandException("generate operation prohibits %s or %s", ui.parameter("baseline1"), ui.parameter("baseline2"));
            }
            case ANALYZE: {
                if (ui.getLibraries().isEmpty()) {
                    throw new CommandException("analyze operation requires %s", ui.parameter("libraries"));
                }
                if (!ui.getClassPath().isEmpty()) {
                    throw new CommandException("analyze operation prohibits %s", ui.parameter("classpath"));
                }
                for (Path path : ui.getClassPath()) {
                    if (Files.exists(path, new LinkOption[0])) continue;
                    throw new CommandException("Path to scan %s not found", path);
                }
                if (ui.getBaseline0() == null && ui.getBaseline1() == null) break;
                throw new CommandException("analyzer operation prohibits %s or %s", ui.parameter("baseline1"), ui.parameter("baseline2"));
            }
            case MERGE: {
                if (ui.getLibraries().isEmpty()) {
                    throw new CommandException("merge operation requires %s", ui.parameter("libraries"));
                }
                if (!ui.getClassPath().isEmpty()) {
                    throw new CommandException("merge operation prohibits %s", ui.parameter("classpath"));
                }
                if (ui.getBaseline0() == null && ui.getBaseline1() == null) break;
                throw new CommandException("merge operation prohibits %s or %s", ui.parameter("baseline1"), ui.parameter("baseline2"));
            }
            case CAPTURE: {
                if (ui.getLibraries().isEmpty()) {
                    throw new CommandException("capture operation requires %s", ui.parameter("libraries"));
                }
                if (ui.getBaselineFile() == null) {
                    throw new CommandException("capture operation requires %s", ui.output(CommandInterface.Output.BASELINE));
                }
                if (!ui.getClassPath().isEmpty()) {
                    throw new CommandException("capture operation prohibits %s", ui.parameter("classpath"));
                }
                if (ui.getBaseline0() == null && ui.getBaseline1() == null) break;
                throw new CommandException("capture operation prohibits %s or %s", ui.parameter("baseline1"), ui.parameter("baseline2"));
            }
            case COMPARE: {
                if (!ui.getClassPath().isEmpty()) {
                    throw new CommandException("compare operation prohibits %s", ui.parameter("classpath"));
                }
                if (!ui.getLibraries().isEmpty()) {
                    throw new CommandException("compare operation prohibits %s", ui.parameter("libraries"));
                }
                if (ui.getBaseline0() == null) {
                    throw new CommandException("compare operation requires %s and %s", ui.parameter("baseline1"), ui.parameter("baseline2"));
                }
                if (ui.getBaseline1() != null) break;
                throw new CommandException("compare operation requires %s", ui.parameter("baseline2"));
            }
        }
        CommandLog log = new CommandLog(middlewareHome, ui);
        int exitStatus = 0;
        if (ui.getOperation() == CommandInterface.Operation.COMPARE) {
            Throwable throwable;
            BufferedWriter writer;
            ui.note("Comparing baselines %s and %s", ui.getBaseline0(), ui.getBaseline1());
            LinkedHashMap<String, Kind> added = new LinkedHashMap<String, Kind>();
            LinkedHashMap<String, Kind> removed = new LinkedHashMap<String, Kind>();
            Command.compareBaselines(ui.getBaseline0(), ui.getBaseline1(), added, removed, log);
            Command.createDirectory(ui.getAddedFile());
            try {
                writer = Files.newBufferedWriter(ui.getAddedFile(), Charset.defaultCharset(), new OpenOption[0]);
                throwable = null;
                try {
                    for (Map.Entry entry : added.entrySet()) {
                        writer.write(((Kind)((Object)entry.getValue())).toString());
                        writer.write(32);
                        writer.write((String)entry.getKey());
                        writer.newLine();
                    }
                    ui.note("Added API list (%s) written to %s", ui.output(CommandInterface.Output.ADDED), ui.getAddedFile());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Added API file %s not created: %s", ui.getAddedFile(), e);
            }
            Command.createDirectory(ui.getRemovedFile());
            try {
                writer = Files.newBufferedWriter(ui.getRemovedFile(), Charset.defaultCharset(), new OpenOption[0]);
                throwable = null;
                try {
                    for (Map.Entry entry : removed.entrySet()) {
                        writer.write(((Kind)((Object)entry.getValue())).toString());
                        writer.write(32);
                        writer.write((String)entry.getKey());
                        writer.newLine();
                    }
                    ui.note("Removed API list (%s) written to %s", ui.output(CommandInterface.Output.REMOVED), ui.getRemovedFile());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Removed API file %s not created: %s", ui.getRemovedFile(), e);
            }
            int add = added.size();
            int remove = removed.size();
            ui.note("%d element%s added, %d element%s removed", add, add == 1 ? "" : "s", remove, remove == 1 ? "" : "s");
            exitStatus = removed.size();
        } else {
            List<Object> list;
            ExportDomains domains;
            ui.note("Schema validation %s", ui.isValidating() ? "enabled" : "disabled");
            if (ui.getDomainFile() != null) {
                try {
                    FileExportSpecificationReader reader = new FileExportSpecificationReader();
                    reader.setSchemaValidating(true);
                    reader.setDomainValidating(true);
                    ArrayList<String> issues = new ArrayList<String>();
                    domains = ((FileExportSpecification)reader.read(ui.getDomainFile(), issues)).getDomains();
                    log.log("", CommandLog.NOTE, "export file domains: %s", domains);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new CommandException(e, "Domains %s not read: %s", ui.getDomainFile(), e);
                }
            } else {
                domains = new ExportDomains(new String[0]);
            }
            Installation installation = new Installation(middlewareHome, ui.isValidating(), log);
            LinkedHashMap<Path, ClassPathRoot> roots = new LinkedHashMap<Path, ClassPathRoot>();
            LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries = new LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>>();
            StringBuilder message = new StringBuilder();
            switch (ui.getOperation()) {
                case GENERATE: {
                    message.append("Generating export specification from annotations in");
                    list = ui.getClassPath();
                    for (Path path : ui.getClassPath()) {
                        String[] origin = ui.parameter("classpath");
                        ClassPathRoot root = new ClassPathRoot((Object)origin, path, ClassPathRoot.annotationAccessPolicy(ui.getOwner(), (String)origin, domains), null, log);
                        if (!root.exists()) {
                            if (ui.isFailOnClassPathError()) {
                                throw new CommandException("%s entry %s not found", origin, path);
                            }
                            ui.warning("%s entry %s not found", origin, path);
                        }
                        roots.putIfAbsent(root.getReferencePath(), root);
                    }
                    break;
                }
                case ANALYZE: {
                    message.append("Analyzing");
                    list = ui.getLibraries();
                    Command.createRootsFromSources(ui.parameter("libraries"), ui, installation, ui.getLibraries(), true, libraries, roots, log);
                    break;
                }
                case MERGE: {
                    message.append("Merging");
                    list = ui.getLibraries();
                    Command.createRootsFromSources(ui.parameter("libraries"), ui, installation, ui.getLibraries(), true, libraries, roots, log);
                    break;
                }
                case CAPTURE: {
                    message.append("Capturing baseline for");
                    list = ui.getLibraries();
                    Command.createRootsFromSources(ui.parameter("libraries"), ui, installation, ui.getLibraries(), true, libraries, roots, log);
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected state " + (Object)((Object)ui.getOperation()));
                }
            }
            switch (list.size()) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    message.append(' ').append(list.get(0));
                    break;
                }
                default: {
                    message.append(':');
                    for (Object item : list) {
                        message.append("\n    ").append(item);
                    }
                }
            }
            ui.note("%s", message);
            Command.createRootsFromSources(ui.option("dependencies"), ui, installation, ui.getDependencies(), false, null, roots, log);
            List<Path> bootClassPath = ui.getBootClassPath();
            if (bootClassPath.isEmpty()) {
                bootClassPath = new ArrayList<Path>();
                String property = System.getProperty("sun.boot.class.path");
                if (property == null) {
                    throw new CommandException("Boot class path unspecified and JVM fallback property \"sun.boot.class.path\" undefined");
                }
                for (String path : property.split(File.pathSeparator)) {
                    bootClassPath.add(Paths.get(path, new String[0]));
                }
            }
            for (Path bootPath : bootClassPath) {
                ClassPathRoot root = new ClassPathRoot((Object)ui.option("bootclasspath"), bootPath, ClassPathRoot.jdkAccessPolicy(), null, log);
                roots.putIfAbsent(root.getReferencePath(), root);
            }
            ClassPathModel model = new ClassPathModel(roots, log);
            ui.note("Found %d librar%s and %d class path root%s", libraries.size(), libraries.size() != 1 ? "ies" : "y", roots.size(), roots.size() != 1 ? "s" : "");
            long time2 = System.currentTimeMillis();
            log.log(CommandLog.NOTE, "time to read classes: %dms", time2 - time1);
            if (ui.getOutputDirectory() != null) {
                ui.note("Default output directory is %s", ui.getOutputDirectory());
            }
            if (ui.getExportsFile() != null) {
                Command.createDirectory(ui.getExportsFile());
                model.writeExportSpecification(ui.getOwner(), ui.getConsumers(), domains, ui.getExportsFile());
                ui.note("Export specification (%s) written to %s", ui.output(CommandInterface.Output.EXPORTS), ui.getExportsFile());
            }
            if (ui.getCommentsFile() != null) {
                Command.createDirectory(ui.getCommentsFile());
                Command.writeCommentsFile(model, ui.getCommentsFile(), domains);
                ui.note("Remediation comment list (%s) written to %s", ui.output(CommandInterface.Output.COMMENTS), ui.getCommentsFile());
            }
            if (ui.getLibraryFile() != null) {
                Command.createDirectory(ui.getLibraryFile());
                Command.writeLibraryFile(model, ui.getLibraryName(), ui.getLibraryId(), ui.getLibraryDescription(), ui.getExportsFile(), ui.getCommentsFile(), ui.getLibraryFile());
                ui.note("Library (%s) written to %s", ui.output(CommandInterface.Output.LIBRARY), ui.getLibraryFile());
            }
            if (ui.getExportedFile() != null) {
                Command.createDirectory(ui.getExportedFile());
                Command.writeSignatureFile(model, Access.EXPORTED, ui.getExportedFile());
                ui.note("Exported signatures list (%s) written to %s", ui.output(CommandInterface.Output.EXPORTED), ui.getExportedFile());
            }
            if (ui.getConcealedFile() != null) {
                Command.createDirectory(ui.getConcealedFile());
                Command.writeSignatureFile(model, Access.CONCEALED, ui.getConcealedFile());
                ui.note("Concealed signatures list (%s) written to %s", ui.output(CommandInterface.Output.CONCEALED), ui.getConcealedFile());
            }
            if (ui.getLibrariesFile() != null) {
                Command.createDirectory(ui.getLibrariesFile());
                Command.writeLibrariesFile(installation, libraries, ui.getLibrariesFile(), log);
                ui.note("Libraries list (%s) written to %s", ui.output(CommandInterface.Output.LIBRARIES), ui.getLibrariesFile());
            }
            long time3 = System.currentTimeMillis();
            log.log(CommandLog.NOTE, "time to write export, package, and signature files: %dms", time3 - time2);
            if (ui.getProblemsFile() != null) {
                Command.createDirectory(ui.getProblemsFile());
                Command.writeProblemTypesFile(model, ui.getProblemsFile(), ui.getMiddlewareHome());
                ui.note("Problem types list (%s) written to %s", ui.output(CommandInterface.Output.PROBLEMS), ui.getProblemsFile());
            }
            long time4 = System.currentTimeMillis();
            log.log(CommandLog.NOTE, "time to write problem types: %dms", time4 - time3);
            if (ui.getUsedConcealedFile() != null || ui.getUnusedExportedFile() != null || ui.getUsedCommentedFile() != null || ui.getUsedUncommentedFile() != null) {
                long time45 = System.currentTimeMillis();
                Uses.readUses(model);
                long time5 = System.currentTimeMillis();
                log.log(CommandLog.NOTE, "time to process FA uses: %dms", time5 - time45);
                Command.createDirectory(ui.getUsedConcealedFile());
                Command.createDirectory(ui.getUnusedExportedFile());
                Command.createDirectory(ui.getUsedCommentedFile());
                Command.createDirectory(ui.getUsedUncommentedFile());
                Uses.writeUsedFiles(model, ui.getUsedConcealedFile(), ui.getUnusedExportedFile(), ui.getUsedCommentedFile(), ui.getUsedUncommentedFile(), log);
                long time6 = System.currentTimeMillis();
                log.log(CommandLog.NOTE, "time to write FA uses: %dms", time6 - time5);
            }
            if (ui.getBaselineFile() != null) {
                Command.createDirectory(ui.getBaselineFile());
                Command.writeBaselineFile(model, libraries.keySet(), ui.getBaselineFile(), middlewareHome);
                ui.note("Baseline list (%s) written to %s", ui.output(CommandInterface.Output.BASELINE), ui.getBaselineFile());
            }
            model.closeFileSystems();
        }
        log.log(CommandLog.NOTE, "total processing time: %dms", System.currentTimeMillis() - time1);
        if (ui.getIssuesFile() != null) {
            log.log(CommandLog.NOTE, "%d class files read, %d bytes average, %d bytes max", ClassFiles.getTypeCount(), ClassFiles.getAverageTypeSize(), ClassFiles.getMaxTypeSize());
            log.writeIssues(ui.getIssuesFile());
            ui.note("Issues log (%s) written to %s", ui.output(CommandInterface.Output.ISSUES), ui.getIssuesFile());
        }
        switch (ui.getOperation()) {
            case GENERATE: {
                ui.note(ui.getExportsFile() + " created in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
                break;
            }
            case ANALYZE: {
                ui.note("Analysis completed in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
                break;
            }
            case MERGE: {
                ui.note("Merge completed in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
                break;
            }
            case CAPTURE: {
                ui.note("Capture completed in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
                break;
            }
            case COMPARE: {
                ui.note("Comparison completed in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
                break;
            }
            default: {
                ui.note("Processing completed in " + (System.currentTimeMillis() - time1) + "ms", new Object[0]);
            }
        }
        return exitStatus;
    }

    private static void createDirectory(Path path) throws CommandException {
        if (path == null) {
            return;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CommandException(e, "Directory %s not created: %s", path, e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createRootsFromSources(String origin, CommandInterface ui, Installation installation, List<ClassesSource> sources, boolean librariesOnly, LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries, LinkedHashMap<Path, ClassPathRoot> roots, CommandLog log) throws CommandException {
        for (ClassesSource source : sources) {
            Path path = source.getPath();
            String id = source.getId();
            ClassesSource.Type type = source.getType();
            try {
                Object extension;
                ClassesSource.Type resolvedType;
                Object resolvedObject;
                block57: {
                    block58: {
                        block56: {
                            if (path == null) break block56;
                            assert (type != ClassesSource.Type.INSTALLATION);
                            ArrayList<String> issues = new ArrayList<String>();
                            block3 : switch (type) {
                                case LIBRARY: {
                                    if (!Paths.hasSuffix(path, ".library")) {
                                        throw new CommandException("Library expected to have .library file type");
                                    }
                                    resolvedObject = installation.getManifestLibrary(path, issues);
                                    resolvedType = ClassesSource.Type.LIBRARY;
                                    break;
                                }
                                case EXTENSION: {
                                    void var16_20;
                                    Extension extension2 = installation.findExtension(path);
                                    if (extension2 == null) {
                                        try {
                                            Path rootPath = FileSystems.newFileSystem(path, null).getPath("/", new String[0]);
                                            Path manifestPath = rootPath.resolve("META-INF/extension.xml");
                                            if (!Files.exists(manifestPath, new LinkOption[0])) {
                                                throw new CommandException("META-INF/extension.xml not found in expected extension %s", path);
                                            }
                                            Extension extension3 = installation.getExtension(origin, path, manifestPath, issues);
                                        }
                                        catch (NoSuchFileException e) {
                                            throw new CommandException(e, "Extension %s does not exist", path);
                                        }
                                        catch (FileSystemNotFoundException e) {
                                            throw new CommandException(e, "Extension %s not a jar", path);
                                        }
                                        catch (IOException e) {
                                            throw new CommandException(e, "Extension %s not opened", path);
                                        }
                                    }
                                    resolvedObject = var16_20;
                                    resolvedType = ClassesSource.Type.EXTENSION;
                                    break;
                                }
                                case PATH: {
                                    if (!Files.exists(path, new LinkOption[0]) && librariesOnly) {
                                        throw new CommandException("%s not found", path);
                                    }
                                    resolvedObject = path;
                                    resolvedType = ClassesSource.Type.PATH;
                                    break;
                                }
                                case UNKNOWN: {
                                    if (installation.findExtension(path) != null) {
                                        resolvedObject = installation.findExtension(path);
                                        resolvedType = ClassesSource.Type.EXTENSION;
                                        break;
                                    }
                                    if (installation.findManifestLibrary(path) != null) {
                                        resolvedObject = installation.findManifestLibrary(path);
                                        resolvedType = ClassesSource.Type.LIBRARY;
                                        break;
                                    }
                                    if (Files.isDirectory(path, new LinkOption[0])) {
                                        if (librariesOnly) {
                                            throw new CommandException("Directory %s not a library or extension", path);
                                        }
                                        resolvedObject = path;
                                        resolvedType = ClassesSource.Type.PATH;
                                        break;
                                    }
                                    if (Files.isRegularFile(path, new LinkOption[0])) {
                                        switch (Paths.getFileType(path)) {
                                            case ".library": {
                                                resolvedObject = installation.getManifestLibrary(path, issues);
                                                resolvedType = ClassesSource.Type.LIBRARY;
                                                break block3;
                                            }
                                            case ".jar": {
                                                Path rootPath;
                                                try {
                                                    rootPath = FileSystems.newFileSystem(path, null).getPath("/", new String[0]);
                                                }
                                                catch (IOException | FileSystemNotFoundException e) {
                                                    if (librariesOnly) {
                                                        throw new CommandException("Jar %s not a library or extension", path);
                                                    }
                                                    resolvedObject = path;
                                                    resolvedType = ClassesSource.Type.PATH;
                                                    break block3;
                                                }
                                                Path manifestPath = rootPath.resolve("META-INF/extension.xml");
                                                if (Files.exists(manifestPath, new LinkOption[0])) {
                                                    resolvedObject = installation.getExtension(origin, path, manifestPath, issues);
                                                    resolvedType = ClassesSource.Type.EXTENSION;
                                                    break block3;
                                                }
                                                if (librariesOnly) {
                                                    throw new CommandException("Jar %s not a library or extension", path);
                                                }
                                                resolvedObject = rootPath;
                                                resolvedType = ClassesSource.Type.PATH;
                                                break block3;
                                            }
                                        }
                                        if (librariesOnly) {
                                            throw new CommandException("File %s not a library or extension", path);
                                        }
                                        resolvedObject = path;
                                        resolvedType = ClassesSource.Type.PATH;
                                        break;
                                    }
                                    if (librariesOnly) {
                                        throw new CommandException("%s not found", path);
                                    }
                                    resolvedObject = path;
                                    resolvedType = ClassesSource.Type.PATH;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException(type.toString());
                                }
                            }
                            log.log(path, issues);
                            break block57;
                        }
                        if (id == null) break block58;
                        switch (type) {
                            case LIBRARY: {
                                resolvedObject = installation.findLibrary(id);
                                if (resolvedObject == null) {
                                    throw new CommandException("Library %s not found", id);
                                }
                                resolvedType = ClassesSource.Type.LIBRARY;
                                break block57;
                            }
                            case EXTENSION: {
                                resolvedObject = installation.findExtension(id);
                                if (resolvedObject == null) {
                                    throw new CommandException("Extension %s not found", id);
                                }
                                resolvedType = ClassesSource.Type.EXTENSION;
                                break block57;
                            }
                            case UNKNOWN: {
                                extension = installation.findExtension(id);
                                FileExportLibrary fileExportLibrary = installation.findLibrary(id);
                                if (extension != null && fileExportLibrary != null) {
                                    Path mwh = ui.getMiddlewareHome();
                                    throw new CommandException("Id \"%s\" ambiguous:\n  Library %1$s (\"%s\") at %s\n  Extension %1$s at %s\n  Use %s", id, fileExportLibrary.getName(), Command.origin(fileExportLibrary, mwh), Paths.relativize(((Extension)extension).getFilePath(), mwh), ui.libraryOrExtension(fileExportLibrary.getId(), ((Extension)extension).getId()));
                                }
                                if (extension != null) {
                                    resolvedObject = extension;
                                    resolvedType = ClassesSource.Type.EXTENSION;
                                } else {
                                    if (fileExportLibrary == null) throw new CommandException("Library or extension %s not found", id);
                                    resolvedObject = fileExportLibrary;
                                    resolvedType = ClassesSource.Type.LIBRARY;
                                }
                                break block57;
                            }
                            default: {
                                throw new IllegalStateException(type.toString());
                            }
                        }
                    }
                    resolvedObject = installation;
                    resolvedType = ClassesSource.Type.INSTALLATION;
                }
                assert (resolvedObject != null) : "source " + source;
                assert (resolvedType != ClassesSource.Type.UNKNOWN) : "source " + source;
                source.resolve(resolvedType);
                if (resolvedObject instanceof Installation) {
                    for (FileExportLibrary fileExportLibrary : installation.getLibraries()) {
                        Command.createRootsFromLibrary(installation, fileExportLibrary, librariesOnly, libraries, roots, log);
                    }
                    continue;
                }
                if (resolvedObject instanceof Extension) {
                    extension = (Extension)resolvedObject;
                    for (FileExportLibrary library : ((Extension)extension).getLibraries()) {
                        Command.createRootsFromLibrary(installation, library, librariesOnly, libraries, roots, log);
                    }
                    if (!((Extension)extension).getLibraries().isEmpty()) continue;
                    ui.warning("Extension %s has no libraries", path);
                    continue;
                }
                if (resolvedObject instanceof ExportLibrary) {
                    Command.createRootsFromLibrary(installation, (FileExportLibrary)resolvedObject, librariesOnly, libraries, roots, log);
                    continue;
                }
                if (!(resolvedObject instanceof Path)) throw new IllegalStateException();
                AccessPolicy<?> policy = ClassPathRoot.foreignAccessPolicy();
                ClassPathRoot classPathRoot = new ClassPathRoot((Object)origin, path, policy, null, log);
                roots.putIfAbsent(classPathRoot.getReferencePath(), classPathRoot);
            }
            catch (CommandException e) {
                if (librariesOnly) {
                    throw e;
                }
                ui.error(e.getMessage(), new Object[0]);
            }
        }
    }

    private static void createRootsFromLibrary(Installation installation, FileExportLibrary library, boolean proprietaryContext, LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries, LinkedHashMap<Path, ClassPathRoot> mergedRoots, CommandLog log) {
        LinkedHashMap<ClassPathEntry, ClassPathRoot> libraryRoots = new LinkedHashMap<ClassPathEntry, ClassPathRoot>();
        if (libraries != null) {
            libraries.put(library, libraryRoots);
        }
        for (ClassPathEntry entry : library.getResolvedClassPath()) {
            AccessPolicy<?> policy = (AccessPolicy<?>)entry.getResolvedExportSpecification();
            if (policy == null || !proprietaryContext) {
                policy = ClassPathRoot.foreignAccessPolicy();
            }
            ClassPathRoot root = new ClassPathRoot((Object)library.getOrigin(), entry.getUrl(), policy, null, log);
            root = mergedRoots.merge(root.getReferencePath(), root, (l, r) -> Command.reconcile(l, r));
            libraryRoots.put(entry, root);
        }
    }

    private static List<Path> absolutePaths(Path directory, String path, List<Path> paths) {
        for (String name : path.split(",")) {
            paths.add(directory.resolve(name));
        }
        return paths;
    }

    private static void compareBaselines(Path baseline0Path, Path baseline1Path, Map<String, Kind> added, Map<String, Kind> removed, CommandLog log) throws CommandException {
        TreeMap<String, Kind> elements0 = new TreeMap<String, Kind>();
        TreeMap<String, Kind> elements1 = new TreeMap<String, Kind>();
        TreeSet<String> libraries0 = new TreeSet<String>();
        TreeSet<String> libraries1 = new TreeSet<String>();
        Command.readBaseline(baseline0Path, libraries0, elements0, log);
        Command.readBaseline(baseline1Path, libraries1, elements1, log);
        ComparisonIterators.ComparisonIterator<String> libraries = ComparisonIterators.comparisonIterator(libraries0, libraries1);
        while (libraries.hasNext()) {
            switch (libraries.next()) {
                case LESS_THAN: {
                    removed.put(libraries.left(), Kind.LIBRARY);
                    break;
                }
                case EQUAL: {
                    break;
                }
                case GREATER_THAN: {
                    added.put(libraries.right(), Kind.LIBRARY);
                }
            }
        }
        ComparisonIterators.MapComparisonIterator<String, Kind> elements = ComparisonIterators.iterator(elements0, elements1);
        while (elements.hasNext()) {
            switch (elements.next()) {
                case LESS_THAN: {
                    removed.put(elements.left().getKey(), elements.left().getValue());
                    break;
                }
                case EQUAL: {
                    break;
                }
                case GREATER_THAN: {
                    added.put(elements.right().getKey(), elements.right().getValue());
                }
            }
        }
    }

    private static SortedMap<String, Kind> readBaseline(Path path, SortedSet<String> libraries, SortedMap<String, Kind> elements, CommandLog log) throws CommandException {
        if (baselineMatcher == null) {
            Pattern pattern = Pattern.compile("(LIBRARY|PACKAGE|CLASS|INTERFACE|RESOURCE|CONSTRUCTOR|METHOD|FIELD) *(.*)$");
            baselineMatcher = pattern.matcher("");
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            int count = 0;
            String line = reader.readLine();
            while (line != null) {
                block23: {
                    block22: {
                        ++count;
                        baselineMatcher.reset(line);
                        if (!baselineMatcher.matches()) break block22;
                        Kind kind = Kind.valueOf(baselineMatcher.group(1));
                        String name = baselineMatcher.group(2);
                        switch (kind) {
                            case LIBRARY: {
                                if (!libraries.add(name)) {
                                    log.warning("duplicate name at %s:%d", path, count);
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                if (elements.putIfAbsent(name, kind) != null) {
                                    log.warning("duplicate name at %s:%d", path, count);
                                    break;
                                }
                                break block23;
                            }
                        }
                        break block23;
                    }
                    log.warning("invalid line at %s:%d", path, count);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline %s not read: %s", path, e);
        }
        return elements;
    }

    static ClassPathRoot reconcile(ClassPathRoot left, ClassPathRoot right) {
        AccessPolicy<?> leftPolicy = left.getAccessPolicy();
        AccessPolicy<?> rightPolicy = right.getAccessPolicy();
        if (left.isJDK()) {
            if (!right.isJDK()) {
                throw new IllegalStateException("Non-JDK root conflicts with already present JDK root");
            }
            return left;
        }
        if (right.isJDK()) {
            right.getLog().error(right.getPath(), "%s claimed JDK path %s", leftPolicy, right.getPath());
            return right;
        }
        if (left.isProprietary()) {
            if (right.isForeign()) {
                return left;
            }
            if (Objects.equals(leftPolicy.getOwner(), rightPolicy.getOwner())) {
                if (!leftPolicy.getId().equals(rightPolicy.getId())) {
                    left.getLog().warning(right.getPath(), "conflicting export specifications with same owner %s for %s: should merge but for now first wins: %s precedes %s", leftPolicy.getOwner(), left.getPath(), leftPolicy.getId(), rightPolicy.getId());
                }
            } else {
                left.getLog().error(right.getPath(), "conflicting owners %s and %s for %s: %s precedes %s", leftPolicy.getOwner(), rightPolicy.getOwner(), left.getPath(), leftPolicy.getId(), rightPolicy.getId());
            }
            return left;
        }
        return right.isProprietary() ? right : left;
    }

    static void writeCommentsFile(ClassPathModel model, Path path, ExportDomains domains) throws CommandException {
        if (path == null) {
            return;
        }
        try (PrintWriter writer = Command.getPrintWriter(path);){
            writer.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>");
            writer.print("<lib-comments");
            writer.print(" xmlns=\"http://xmlns.oracle.com/ide/comment\"");
            int rootCloses = 0;
            for (ClassPathModel.Package packag : model.getPackages()) {
                String packageName = packag.getName();
                if (!domains.controls(packageName) || !packag.hasProprietaryChildren() || !packag.hasConcealedTypesOrResources()) continue;
                if (packag.getAccessComment() != null) {
                    if (rootCloses++ == 0) {
                        writer.println('>');
                    }
                    Command.writeIndent(1, writer);
                    writer.print("<comment name=\"");
                    writer.print(packageName);
                    writer.print("\" comment=\"");
                    writer.print(Command.escape(packag.getAccessComment()));
                    writer.println("\"/>");
                }
                for (ClassPathModel.Type type : packag.getTypes()) {
                    if (!type.isProprietary()) continue;
                    if (type.isSelfOrMemberConcealed() && type.getAccessComment() != null) {
                        if (rootCloses++ == 0) {
                            writer.println('>');
                        }
                        Command.writeIndent(1, writer);
                        writer.print("<comment name=\"");
                        writer.print(type.getFullName());
                        writer.print("\" comment=\"");
                        writer.print(Command.escape(type.getAccessComment()));
                        writer.println("\"/>");
                    }
                    if (!type.hasConcealedChildren()) continue;
                    for (ClassPathModel.Member<?> member : type.getDeclaredMembers()) {
                        if (!member.isConcealed() || member.getAccessComment() == null) continue;
                        if (rootCloses++ == 0) {
                            writer.println('>');
                        }
                        Command.writeIndent(1, writer);
                        writer.print("<comment name=\"");
                        writer.print(member.getFullName());
                        writer.print("\" comment=\"");
                        writer.print(Command.escape(member.getAccessComment()));
                        writer.println("\"/>");
                    }
                }
            }
            writer.println(rootCloses++ == 0 ? "/>" : "</lib-comments>");
        }
        catch (IOException e) {
            throw new CommandException("Comments file %s not created: %s", path, e);
        }
    }

    static String escape(String text) {
        StringBuilder builder = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    builder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    builder.append("&apos;");
                    continue block7;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block7;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static void writeSignatureFile(ClassPathModel model, Access access, Path path) throws CommandException {
        assert (access != null);
        boolean wantConcealed = access == Access.CONCEALED;
        try (PrintWriter writer = Command.getPrintWriter(path);){
            for (ClassPathModel.Package packag : model.getPackages()) {
                if (!packag.hasProprietaryChildren()) continue;
                for (ClassPathModel.Type type : packag.getTypes()) {
                    if (!type.isReachable() || !type.isProprietary()) continue;
                    if (!type.isSelfOrMemberExported() == wantConcealed) {
                        writer.print(type.isInterface() ? "INTERFACE " : "CLASS ");
                        writer.println(type.getFullName());
                    }
                    for (ClassPathModel.Member<?> member : type.getDeclaredMembers()) {
                        if (member.isConcealed() != wantConcealed) continue;
                        writer.print(member.getClass().getSimpleName().toUpperCase());
                        writer.print(' ');
                        writer.println(member.getFullName());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "%c%s signature file %s not created: %s", Character.valueOf(access.toString().charAt(0)), access.toString().substring(1).toLowerCase(), path, e);
        }
    }

    public static void writeBaselineFile(ClassPathModel model, Collection<FileExportLibrary> libraries, Path path, Path middlewareHome) throws CommandException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (FileExportLibrary library : Command.sorted(libraries, (l, r) -> l.getId().compareTo(r.getId()))) {
                ClassPathEntry entry;
                boolean exporting = false;
                Iterator<ClassPathEntry> iterator = library.getSuppliedClassPath().iterator();
                while (iterator.hasNext() && !(exporting = (entry = iterator.next()).getResolvedExportSpecification() != null)) {
                }
                if (!exporting) continue;
                writer.write("LIBRARY ");
                writer.write(library.getId());
                writer.write(" \"");
                writer.write(library.getName());
                writer.write("\" ");
                writer.write(Command.origin(library, middlewareHome));
                writer.newLine();
            }
            for (ClassPathModel.Package packag : model.getPackages()) {
                if (!packag.hasProprietaryChildren()) continue;
                for (ClassPathModel.Type type : packag.getTypes()) {
                    if (!type.isReachable() || !type.isProprietary()) continue;
                    if (type.isSelfOrMemberExported()) {
                        writer.write(type.isInterface() ? "INTERFACE " : "CLASS ");
                        writer.write(type.getFullName());
                        writer.newLine();
                    }
                    for (ClassPathModel.Member<?> member : type.getDeclaredMembers()) {
                        if (member.isConcealed()) continue;
                        writer.write(member.getClass().getSimpleName().toUpperCase());
                        writer.write(32);
                        writer.write(member.getFullName());
                        if (member instanceof ClassPathModel.Method) {
                            writer.write(" : ");
                            writer.write(((ClassPathModel.Method)member).getReturnTypeName().replace('/', '.'));
                        }
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Signature file %s not created: %s", path, e);
        }
    }

    public static void writeProblemTypesFile(ClassPathModel model, Path path, Path baseDirectory) throws CommandException {
        TreeMap<ClassPathModel.Element, Set> problemTypes = new TreeMap<ClassPathModel.Element, Set>(new FullNameComparator());
        ArrayList<ClassPathModel.Package> packages = new ArrayList<ClassPathModel.Package>(model.getPackages());
        for (ClassPathModel.Package packag : packages) {
            if (!packag.hasExportedTypesOrResources()) continue;
            for (ClassPathModel.Type type : new ArrayList<ClassPathModel.Type>(packag.getTypes())) {
                if (!type.hasExportedChildren()) continue;
                for (ClassPathModel.Member<?> member : type.getDeclaredMembers()) {
                    if (!member.isExported()) continue;
                    for (ClassPathModel.Type problemType : member.getProblemTypes(model)) {
                        problemTypes.computeIfAbsent(problemType, v -> new TreeSet()).add(type);
                    }
                }
            }
        }
        try (PrintWriter writer = Command.getPrintWriter(path);){
            int count = 0;
            for (Map.Entry entry : problemTypes.entrySet()) {
                ClassPathModel.Type problemType;
                if (count++ > 0) {
                    writer.println();
                }
                if ((problemType = (ClassPathModel.Type)entry.getKey()).isUnresolved()) {
                    writer.print("unresolved: ");
                } else if (!problemType.isReachable()) {
                    writer.print("private:    ");
                } else if (problemType.isForeign()) {
                    writer.print("foreign:    ");
                } else if (!problemType.isSelfOrMemberExported()) {
                    writer.print("concealed:  ");
                } else {
                    throw new IllegalStateException("unexpected problem type " + problemType);
                }
                writer.println(problemType.getFullName());
                if (!problemType.isUnresolved()) {
                    writer.print("  at:       ");
                    writer.println(problemType.getLocation(baseDirectory));
                    writer.print("  from:     ");
                    if (problemType.getOrigin() instanceof Path) {
                        Path origin = (Path)problemType.getOrigin();
                        if (origin.getFileSystem() == FileSystems.getDefault()) {
                            writer.println(baseDirectory != null ? baseDirectory.relativize(origin).toString().replace('\\', '/') : origin.toString());
                        } else {
                            Path filePath = Paths.get(origin.getFileSystem().toString(), new String[0]);
                            String fileString = baseDirectory != null ? baseDirectory.relativize(filePath).toString().replace('\\', '/') : filePath.toString();
                            writer.println(fileString + '!' + path.toString());
                        }
                    } else {
                        writer.println(String.valueOf(problemType.getOrigin()));
                    }
                }
                for (ClassPathModel.Type referringType : (Set)entry.getValue()) {
                    writer.print("  by:       ");
                    writer.println(referringType.getFullName());
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Problem types file %s not created: %s", path, e);
        }
    }

    public static void writeLibrariesFile(Installation installation, LinkedHashMap<FileExportLibrary, Map<ClassPathEntry, ClassPathRoot>> libraries, Path path, CommandLog log) throws CommandException {
        Path middlewareHome = installation.getMiddlewareHome();
        int count = 0;
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            for (FileExportLibrary library : Command.sorted(libraries.keySet(), (l, r) -> l.getId().compareTo(r.getId()))) {
                if (count++ > 0) {
                    writer.println();
                }
                writer.print("Library ");
                writer.println(library.getId());
                writer.print("id:         ");
                writer.println(library.getId());
                writer.print("name:       \"");
                writer.print(library.getName());
                writer.println('\"');
                writer.print("origin:     ");
                writer.println(Command.origin(library, middlewareHome));
                LibraryDependency lastDependency = null;
                int entryCount = 0;
                for (ClassPathEntry classPathEntry : library.getResolvedClassPath()) {
                    if (classPathEntry.getDependencyOrigin() != lastDependency) {
                        lastDependency = classPathEntry.getDependencyOrigin();
                        writer.print("dependency: ");
                        writer.print(lastDependency.getId());
                        writer.print(" in ");
                        writer.println(Command.origin((ExportLibrary)lastDependency.getLibrary(), middlewareHome));
                    }
                    writer.print(entryCount++ == 0 ? "classpath:  " : "            ");
                    if (classPathEntry.getResolvedExportSpecification() != null) {
                        writer.print("[export] ");
                    }
                    writer.println(Paths.relativize(classPathEntry.getUrl(), middlewareHome));
                    ClassPathRoot root = libraries.get(library).get(classPathEntry);
                    if (root == null) continue;
                    for (String packag : root.getContainedPackages()) {
                        writer.print("                     ");
                        writer.println(packag);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Libraries file %s not created: %s", path, e);
        }
    }

    private static String origin(ExportLibrary library, Path middlewareHome) {
        URL origin = library.getOrigin();
        return origin != null ? Paths.relativize(origin, middlewareHome) : "unknown";
    }

    private static <T> Collection<T> sorted(Collection<T> list, Comparator<? super T> comparator) {
        ArrayList<T> sortedList = new ArrayList<T>(list);
        Collections.sort(sortedList, comparator);
        return sortedList;
    }

    private static void writeLibraryFile(ClassPathModel model, String libraryName, String libraryId, String libraryDescription, Path exportsPath, Path commentsPath, Path libraryPath) throws CommandException {
        try {
            ArrayList<ClassPathEntry> classPath = new ArrayList<ClassPathEntry>();
            HashMap<String, List<URL>> exportSpecifications = new HashMap<String, List<URL>>();
            exportSpecifications.computeIfAbsent("", v -> new ArrayList()).add(exportsPath.toUri().toURL());
            for (ClassPathRoot root : model.getRoots()) {
                if (root.isJDK()) continue;
                URL url = root.getPath().toUri().toURL();
                ClassPathEntry.EntryType type = root.isProprietary() ? ClassPathEntry.EntryType.SUPPLIED_LIBRARY : ClassPathEntry.EntryType.SUPPLIED_ABSENT;
                String key = root.isProprietary() ? "" : null;
                ClassPathEntry entry = new ClassPathEntry(url, type, key, false);
                classPath.add(entry);
            }
            ExportLibraryWriter.write(libraryPath, "UTF-8", libraryId, libraryName, libraryDescription, EnumSet.noneOf(FileExportLibrary.LibraryFlag.class), classPath, exportSpecifications, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        catch (IOException e) {
            throw new CommandException(e, "Library file %s not created: %s", libraryPath, e);
        }
    }

    private static void writeIndent(int depth, PrintWriter writer) {
        for (int i = 0; i < depth; ++i) {
            writer.print("  ");
        }
    }

    private static PrintWriter getPrintWriter(Path path) throws IOException {
        return new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
    }

    private static class FullNameComparator
    implements Comparator<ClassPathModel.Element> {
        private FullNameComparator() {
        }

        @Override
        public int compare(ClassPathModel.Element left, ClassPathModel.Element right) {
            return left.getFullName().compareTo(right.getFullName());
        }
    }

    static enum Kind {
        LIBRARY,
        PACKAGE,
        CLASS,
        INTERFACE,
        RESOURCE,
        CONSTRUCTOR,
        METHOD,
        FIELD;

    }
}

