/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;

public class ExportLibraryWriter {
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public static void write(FileExportLibrary library, File file, String encoding) throws IOException {
        ExportLibraryWriter.write(file, encoding, library.getId(), library.getName(), library.getDescription(), library.getFlags(), library.getSuppliedClassPath(), library.getExportSpecificationPaths(), library.getDependencies(), library.getSourcePath(), library.getDocPath());
    }

    public static void write(File file, String encoding, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> statedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        ExportLibraryWriter.write(new FileOutputStream(file), encoding, URLFactory.newFileURL((File)file.getParentFile()), id, name, description, flags, statedClassPath, exportSpecificationPaths, dependencies, sourcePath, docPath);
    }

    public static void write(URL url, String encoding, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> statedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        ExportLibraryWriter.write(URLFileSystem.openOutputStream((URL)url), encoding, URLFileSystem.getParent((URL)url), id, name, description, flags, statedClassPath, exportSpecificationPaths, dependencies, sourcePath, docPath);
    }

    public static void write(Path path, String encoding, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> statedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.forName(encoding), new OpenOption[0]);){
            ExportLibraryWriter.write(writer, encoding, URLFactory.newDirURL((String)path.getParent().toString()), id, name, description, flags, statedClassPath, exportSpecificationPaths, dependencies, sourcePath, docPath);
        }
    }

    public static void write(OutputStream stream, String encoding, URL contextUrl, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> statedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, encoding));){
            ExportLibraryWriter.write(writer, encoding, contextUrl, id, name, description, flags, statedClassPath, exportSpecificationPaths, dependencies, sourcePath, docPath);
        }
    }

    private static void write(BufferedWriter writer, String encoding, URL contextUrl, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> statedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>");
        ExportLibraryWriter.newLine(0, writer);
        writer.write("<library");
        ExportLibraryWriter.writeAttribute("name", name, writer);
        ExportLibraryWriter.writeAttribute("id", id, writer);
        for (FileExportLibrary.LibraryFlag libraryFlag : flags) {
            ExportLibraryWriter.writeAttribute(libraryFlag.getAttributeName(), true, writer);
        }
        ExportLibraryWriter.writeAttribute("xmlns", "http://xmlns.oracle.com/jdeveloper/1013/manifest-libraries", writer);
        writer.write(">");
        ExportLibraryWriter.newLine(1, writer);
        if (description != null && !description.isEmpty()) {
            writer.write("<description>");
            writer.write(description);
            writer.write("</description>");
        } else {
            writer.write("<description/>");
        }
        for (ClassPathEntry classPathEntry : statedClassPath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<classpath");
            switch (classPathEntry.getType()) {
                case SUPPLIED_NONE: {
                    ExportLibraryWriter.writeAttribute("export", "none", writer);
                    break;
                }
                case SUPPLIED_EMBEDDED: {
                    ExportLibraryWriter.writeAttribute("export", "embedded", writer);
                    break;
                }
                case SUPPLIED_LIBRARY: {
                    ExportLibraryWriter.writeAttribute("export", "library", writer);
                    break;
                }
                case SUPPLIED_ALL: {
                    ExportLibraryWriter.writeAttribute("export", "all", writer);
                    break;
                }
            }
            if (classPathEntry.isManifest()) {
                ExportLibraryWriter.writeAttribute("manifest", true, writer);
            }
            if (classPathEntry.getType() == ClassPathEntry.EntryType.SUPPLIED_LIBRARY && !classPathEntry.getKey().isEmpty()) {
                ExportLibraryWriter.writeAttribute("key", classPathEntry.getKey(), writer);
            }
            writer.write(">");
            writer.write(ExportLibraryWriter.toPath(classPathEntry.getUrl(), contextUrl));
            writer.write("</classpath>");
        }
        for (Map.Entry entry : exportSpecificationPaths.entrySet()) {
            for (URL url : (List)entry.getValue()) {
                ExportLibraryWriter.newLine(1, writer);
                writer.write("<export-specification");
                if (!((String)entry.getKey()).isEmpty()) {
                    ExportLibraryWriter.writeAttribute("key", entry.getKey(), writer);
                }
                writer.write(">");
                writer.write(ExportLibraryWriter.toPath(url, contextUrl));
                writer.write("</export-specification>");
            }
        }
        for (LibraryDependency libraryDependency : dependencies) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<dependency");
            if (libraryDependency.isReexported()) {
                ExportLibraryWriter.writeAttribute("reexport", libraryDependency.isReexported(), writer);
            }
            writer.write(62);
            writer.write(libraryDependency.getId());
            writer.write("</dependency>");
        }
        for (URL uRL : sourcePath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<sourcepath>");
            writer.write(ExportLibraryWriter.toPath(uRL, contextUrl));
            writer.write("</sourcepath>");
        }
        for (URL uRL : docPath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<docpath>");
            writer.write(ExportLibraryWriter.toPath(uRL, contextUrl));
            writer.write("</docpath>");
        }
        ExportLibraryWriter.newLine(0, writer);
        writer.write("</library>");
        ExportLibraryWriter.newLine(0, writer);
    }

    private static void writeAttribute(String name, Object value, BufferedWriter writer) throws IOException {
        writer.write(32);
        writer.write(name);
        writer.write("=\"");
        if (value != null) {
            writer.write(value.toString());
        }
        writer.write(34);
    }

    private static void newLine(int depth, BufferedWriter writer) throws IOException {
        writer.newLine();
        for (int i = 0; i < depth; ++i) {
            writer.write("  ");
        }
    }

    protected static String toPath(URL url, URL contextUrl) {
        switch (url.getProtocol()) {
            case "jar": 
            case "zip": 
            case "ear": 
            case "war": {
                if (url.getAuthority() != null && !url.getAuthority().isEmpty()) {
                    return url.toExternalForm();
                }
                String path = url.getPath();
                if (!path.startsWith("file:")) {
                    return url.toExternalForm();
                }
                int entryIndex = (path = path.substring("file:".length())).indexOf("!/");
                if (entryIndex < 0) {
                    return url.toExternalForm();
                }
                String filePath = path.substring(0, entryIndex);
                String entryPath = path.substring(entryIndex + 2);
                filePath = URLFileSystem.toRelativeSpec((URL)URLFactory.newFileURL((String)filePath), (URL)contextUrl);
                int dot = filePath.lastIndexOf(46);
                if (entryPath.isEmpty() && ARCHIVE_SUFFIXES.contains(filePath.substring(dot)) && url.getQuery() == null && url.getRef() == null) {
                    return filePath;
                }
                StringBuilder builder = new StringBuilder(filePath);
                builder.append("!/").append(entryPath);
                if (url.getQuery() != null) {
                    builder.append('?').append(url.getQuery());
                }
                if (url.getRef() != null) {
                    builder.append("#").append(url.getRef());
                }
                return builder.toString();
            }
            case "file": {
                if (url.getAuthority() != null && !url.getAuthority().isEmpty()) {
                    return url.toExternalForm();
                }
                String path = URLFileSystem.toRelativeSpec((URL)URLFactory.newFileURL((String)url.getPath()), (URL)contextUrl);
                if (url.getQuery() == null && url.getRef() == null) {
                    return path;
                }
                StringBuilder builder = new StringBuilder(path);
                if (url.getQuery() != null) {
                    builder.append('?').append(url.getQuery());
                }
                if (url.getRef() != null) {
                    builder.append("#").append(url.getRef());
                }
                return builder.toString();
            }
        }
        return url.toExternalForm();
    }
}

