/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JrfUtils {
    public static String JRF_LOGGER = "oracle.jrf";
    public static final String APP_DEPLOYMENT = "app-deployment";
    public static final String LIBRARY = "library";
    public static final String STARTUP_CLASS = "startup-class";
    public static final String SHUTDOWN_CLASS = "shutdown-class";
    public static final String JDBC_SYSTEM_RESOURCE = "jdbc-system-resource";
    public static final String WLDF_SYSTEM_RESOURCE = "wldf-system-resource";

    public static String getDomainHome() throws PortabilityLayerException {
        String domainHome = System.getProperty("domain.home");
        if (domainHome == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10007"));
        }
        return domainHome;
    }

    public static String getServersConfigDir(String domainHome) throws PortabilityLayerException {
        if (domainHome == null || domainHome.trim().equals("")) {
            domainHome = JrfUtils.getDomainHome();
        }
        File serversConfigDir = new File(domainHome, File.separator + "config" + File.separator + "fmwconfig" + File.separator + "servers");
        return serversConfigDir.getAbsolutePath();
    }

    public static Map<String, List<String>> getResourceMapFromDomainConfig(String resourceType) throws PortabilityLayerException {
        File domainConfigXml = new File(JrfUtils.getDomainHome(), File.separator + "config" + File.separator + "config.xml");
        try {
            return JrfUtils.getJRFResourceMap(resourceType, new FileInputStream(domainConfigXml));
        }
        catch (FileNotFoundException ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10010", new String[]{JrfUtils.getDomainHome()}), ex);
        }
    }

    private static Map<String, List<String>> getJRFResourceMap(String resourceType, InputStream configInput) throws PortabilityLayerException {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        Document dom = null;
        try {
            dom = dbf.newDocumentBuilder().parse(configInput);
        }
        catch (Exception ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10011"), ex);
        }
        Element parent = dom.getDocumentElement();
        NodeList resources = parent.getElementsByTagName(resourceType);
        if (resources != null) {
            for (int i = 0; i < resources.getLength(); ++i) {
                Element app = (Element)resources.item(i);
                String appName = app.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
                String targets = "*";
                NodeList nameList = app.getElementsByTagName("target");
                if (nameList != null && nameList.getLength() > 0) {
                    targets = nameList.item(0).getChildNodes().item(0).getNodeValue();
                }
                resMap.put(appName, JrfUtils.convertStringToList(targets));
            }
        }
        return resMap;
    }

    private static List<String> convertStringToList(String targetString) {
        ArrayList<String> targets = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(targetString, ",");
        while (st.hasMoreTokens()) {
            targets.add(st.nextToken());
        }
        return targets;
    }

    public static String getCommonComponentsHome() throws PortabilityLayerException {
        String oraHome = System.getProperty("common.components.home");
        if (oraHome == null) {
            oraHome = System.getenv("COMMON_COMPONENTS_HOME");
        }
        if (oraHome == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012"));
        }
        File oraHomeDir = new File(oraHome);
        if (!oraHomeDir.exists()) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012", new String[]{oraHome}));
        }
        return oraHome;
    }

    public static String getJrfTemplateJar() throws PortabilityLayerException {
        return JrfUtils.getCommonComponentsHome() + File.separator + "common" + File.separator + "templates" + File.separator + "wls" + File.separator + "oracle.jrf_template.jar";
    }
}

