/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionFactory;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.InSenHashtable;
import oracle.jdeveloper.cm.WritableConnectionStore;

public final class ConnectionManager {
    private static final Object __LOCK__ = new Object();
    private static ConnectionManager _singleton = null;
    private Map _connectionDescriptors = new InSenHashtable();
    private Map _connectionFactories = Collections.synchronizedMap(new HashMap());
    private Map _connectionTypes = new HashMap();
    private List _connectionTypeNames = new ArrayList();
    private boolean _loadedConnectionTypes;
    private boolean _loadedConnectionDescriptors = false;
    private List _connectionListeners = new ArrayList();
    private ConnectInfoPrompter _defaultPrompter;
    private ConnectionStore _cStore = new DefaultConnectionStore();
    private boolean _defaultPrompterSet = false;
    private String _connectionTypesProperties = "ConnectionTypes.properties";
    public static final String JDEV_CONNECTIONTYPES_PROPERTIES = "JDevConnectionTypes.properties";

    public String[] getConnectionTypeNames() {
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        return this._connectionTypeNames.toArray(new String[this._connectionTypeNames.size()]);
    }

    public ConnectionType getConnectionType(String type) {
        if (type == null) {
            return null;
        }
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        return (ConnectionType)this._connectionTypes.get(type);
    }

    public Iterator getConnectionTypes() {
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        ArrayList l = new ArrayList();
        Iterator iter = this._connectionTypeNames.iterator();
        while (iter.hasNext()) {
            l.add(this._connectionTypes.get(iter.next()));
        }
        return l.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnectionDescriptor(String name, ConnectionDescriptor descriptor) throws IOException {
        ConnectionDescriptor oldDescriptor;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            oldDescriptor = this.getConnectionDescriptorImpl(name);
            descriptor = (ConnectionDescriptor)descriptor.clone();
            descriptor.put("ConnectionName", name);
            if (null != oldDescriptor && oldDescriptor.equals(descriptor)) {
                return;
            }
            this._connectionDescriptors.put(name, descriptor);
        }
        if (null == oldDescriptor) {
            this.fireConnectionEvent(0, descriptor);
        } else {
            this.fireConnectionEvent(1, oldDescriptor, descriptor);
        }
    }

    public void deployToFile(String destination) throws CMException {
        this.deployToFile(destination, false);
    }

    public void deployToFile(String destination, boolean stripPasswords) throws CMException {
        ArrayList l;
        if (!this._loadedConnectionDescriptors) {
            try {
                this.loadConnectionDescriptors();
            }
            catch (IOException ioEx) {
                throw new CMException(ioEx);
            }
        }
        WritableConnectionStore wcs = null;
        if (this._cStore instanceof WritableConnectionStore) {
            wcs = (WritableConnectionStore)this._cStore;
            l = new ArrayList();
            Iterator iter = this._connectionDescriptors.values().iterator();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
        } else {
            throw new CMException(new IllegalArgumentException("ConnectionStore is not a WritableConnectionStore"));
        }
        wcs.write(destination, l, stripPasswords);
        l = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (null == _singleton) {
                ConnectionManager cm;
                _singleton = cm = new ConnectionManager();
                return cm;
            }
        }
        return _singleton;
    }

    public void setConnectionTypesProperties(String connectionTypesProperties) {
        this._connectionTypesProperties = connectionTypesProperties;
        this._loadedConnectionTypes = false;
    }

    public static ConnectionManager getPrivateInstance() {
        return new ConnectionManager();
    }

    public ConnectionWrapper getConnection(String name) throws IOException, CMException {
        return this.getConnection(name, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(String name, ConnectInfoPrompter prompter) throws IOException, CMException {
        return this.createNewConnection(name, prompter);
    }

    public ConnectionWrapper getConnection(String name, Properties properties) throws CMException, IOException {
        return this.getConnection(name, properties, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(String name, Properties properties, ConnectInfoPrompter prompter) throws CMException, IOException {
        ConnectionDescriptor descriptor = this.getConnectionDescriptor(name);
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            descriptor.put(key, properties.get(key));
        }
        return this.createNewConnectionImpl(descriptor, prompter);
    }

    public ConnectionWrapper getConnection(ConnectionDescriptor descriptor) throws CMException {
        return this.getConnection(descriptor, this.getDefaultPrompter());
    }

    public ConnectionWrapper getConnection(ConnectionDescriptor descriptor, ConnectInfoPrompter prompter) throws CMException {
        return this.createNewConnectionImpl(descriptor, prompter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDescriptor getUniqueConnectionDescriptor(String base) throws IOException {
        if (null == base) {
            base = "Connection";
        }
        int count = 1;
        ConnectionDescriptor desc = null;
        String uniqueName = base + count;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            while ((desc = this.getConnectionDescriptorImpl(uniqueName)) != null) {
                uniqueName = base + ++count;
            }
        }
        desc = new ConnectionDescriptor();
        desc.put("ConnectionName", uniqueName);
        return desc;
    }

    public ConnectionDescriptor getConnectionDescriptor(String name) throws IOException {
        ConnectionDescriptor desc = this.getConnectionDescriptorImpl(name);
        return desc != null ? (ConnectionDescriptor)desc.clone() : null;
    }

    public boolean connectionDescriptorExists(String name) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        return this._connectionDescriptors.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionNames() throws IOException {
        String[] names;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            if (!this._loadedConnectionDescriptors) {
                this.loadConnectionDescriptors();
            }
            names = new String[this._connectionDescriptors.size()];
            Iterator e = this._connectionDescriptors.values().iterator();
            int i = 0;
            int blanks = 0;
            while (e.hasNext()) {
                Object o = e.next();
                names[i] = ((ConnectionDescriptor)o).getProperty("ConnectionName");
                if (names[i] == null) {
                    ++blanks;
                    continue;
                }
                ++i;
            }
            if (blanks > 0) {
                String[] nonBlanks = new String[names.length - blanks];
                try {
                    System.arraycopy(names, 0, nonBlanks, 0, nonBlanks.length);
                    names = nonBlanks;
                }
                catch (Exception ex) {
                    throw new IOException();
                }
            }
        }
        return names;
    }

    public String[] getConnectionNames(String type) throws IOException {
        return this.getConnectionNames(type, false);
    }

    public String[] getConnectionNames(String type, boolean oracleOnly) throws IOException {
        Properties p = new Properties();
        if (type != null) {
            p.put("ConnectionType", type);
        }
        if (oracleOnly && (type == null || type.equals("JDBC") || type.equals("JDBC") || type.equals("ORACLE_JSERVER"))) {
            ArrayList<String> names = new ArrayList<String>();
            p.put("JdbcDriver", "oracle.jdbc.driver.OracleDriver");
            names.addAll(Arrays.asList(this.getConnectionNames(p)));
            p.put("JdbcDriver", "oracle.jdbc.OracleDriver");
            names.addAll(Arrays.asList(this.getConnectionNames(p)));
            return names.toArray(new String[names.size()]);
        }
        return this.getConnectionNames(p);
    }

    public String[] getConnectionNames(Properties properties) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (ConnectionDescriptor d : this._connectionDescriptors.values()) {
            boolean addIt = true;
            Enumeration<Object> p = properties.keys();
            while (addIt && p.hasMoreElements()) {
                Object key = p.nextElement();
                String s1 = (String)properties.get(key);
                String s2 = (String)d.get(key);
                if (!(null == s2 && null != s1 || null == s1 && null != s2) && (null == s1 || s1.equals(s2))) continue;
                addIt = false;
            }
            if (!addIt) continue;
            l.add(d.getConnectionName());
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getConnectionNamesForClass(String connectionClassName) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (ConnectionDescriptor d : this._connectionDescriptors.values()) {
            String className;
            ConnectionType t;
            String typeName = d.getConnectionType();
            if (typeName == null || (t = this.getConnectionType(typeName)) == null || !(className = t.getConnectionClassName()).equals(connectionClassName)) continue;
            l.add(d.getConnectionName());
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getConnectionTypeNamesForClass(String connectionClassName) throws IOException {
        if (connectionClassName == null) {
            return null;
        }
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        ArrayList<String> l = new ArrayList<String>();
        Iterator e = this.getConnectionTypes();
        while (e.hasNext()) {
            ConnectionType d = (ConnectionType)e.next();
            String className = d.getConnectionClassName();
            if (!className.equals(connectionClassName)) continue;
            l.add(d.getTypeName());
        }
        return l.toArray(new String[l.size()]);
    }

    public ConnectInfoPrompter getDefaultPrompter() {
        if (null == this._defaultPrompter && !this._defaultPrompterSet) {
            try {
                this._defaultPrompter = (ConnectInfoPrompter)Class.forName("oracle.jdeveloper.cm.ConnectInformationDialog").newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this._defaultPrompter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionDescriptor removeConnectionDescriptor(String name) throws IOException {
        ConnectionDescriptor oldDescriptor;
        Map map = this._connectionDescriptors;
        synchronized (map) {
            oldDescriptor = this.getConnectionDescriptorImpl(name);
            this._connectionDescriptors.remove(name);
        }
        if (null != oldDescriptor) {
            this.fireConnectionEvent(4, oldDescriptor);
        }
        return oldDescriptor;
    }

    public void setPrompter(ConnectInfoPrompter prompter) {
        this.setDefaultPrompter(prompter);
    }

    public void setDefaultPrompter(ConnectInfoPrompter prompter) {
        this._defaultPrompterSet = true;
        this._defaultPrompter = prompter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(listener);
        }
    }

    void fireConnectionEvent(int id, Object source) {
        this.fireConnectionEvent(id, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireConnectionEvent(int id, Object source, Object data) {
        ArrayList l = new ArrayList();
        List list = this._connectionListeners;
        synchronized (list) {
            if (this._connectionListeners.size() == 0) {
                return;
            }
            l.addAll(this._connectionListeners);
        }
        ConnectionEvent evt = new ConnectionEvent(id, source, data);
        Iterator iter = l.iterator();
        switch (id) {
            case 1: {
                this.fireConnectionModified(iter, evt);
                break;
            }
            case 0: {
                this.fireConnectionAdded(iter, evt);
                break;
            }
            case 4: {
                this.fireConnectionRemoved(iter, evt);
                break;
            }
            case 2: {
                this.fireConnectionOpened(iter, evt);
                break;
            }
            case 3: {
                this.fireConnectionClosed(iter, evt);
            }
        }
    }

    private void fireConnectionModified(Iterator i, ConnectionEvent evt) {
        while (i.hasNext()) {
            ((ConnectionListener)i.next()).connectionModified(evt);
        }
    }

    private void fireConnectionAdded(Iterator i, ConnectionEvent evt) {
        while (i.hasNext()) {
            ((ConnectionListener)i.next()).connectionAdded(evt);
        }
    }

    private void fireConnectionRemoved(Iterator i, ConnectionEvent evt) {
        while (i.hasNext()) {
            ((ConnectionListener)i.next()).connectionRemoved(evt);
        }
    }

    private void fireConnectionOpened(Iterator i, ConnectionEvent evt) {
        while (i.hasNext()) {
            ((ConnectionListener)i.next()).connectionOpened(evt);
        }
    }

    private void fireConnectionClosed(Iterator i, ConnectionEvent evt) {
        while (i.hasNext()) {
            ((ConnectionListener)i.next()).connectionClosed(evt);
        }
    }

    private ConnectionDescriptor getConnectionDescriptorImpl(String name) throws IOException {
        if (!this._loadedConnectionDescriptors) {
            this.loadConnectionDescriptors();
        }
        return (ConnectionDescriptor)this._connectionDescriptors.get(name);
    }

    private void loadConnectionDescriptors() throws IOException {
        if (!this._loadedConnectionDescriptors) {
            List cl = this._cStore.read();
            if (null == cl) {
                return;
            }
            for (ConnectionDescriptor cDesc : cl) {
                this._connectionDescriptors.put(cDesc.getProperty("ConnectionName"), cDesc);
            }
            this._loadedConnectionDescriptors = true;
        }
    }

    public void setConnectionStore(ConnectionStore store) {
        this._loadedConnectionDescriptors = false;
        this._cStore = store;
    }

    public ConnectionStore getConnectionStore() {
        return this._cStore;
    }

    void registerConnectionType(ConnectionType connType) {
        try {
            String type = connType.getTypeName();
            if (this._connectionTypes.put(type, connType) == null) {
                this._connectionTypeNames.add(type);
            }
            this.registerFactory(type, connType.getFactoryClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void registerConnectionTypes() {
        ctypes = new Properties();
        nc = 0;
        try {
            is = null;
            try {
                is = ConnectionManager.getInputStream(this.getClass(), this._connectionTypesProperties);
                ctypes.load(is);
                nc = Integer.parseInt((String)ctypes.get("nc"));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        if (nc == 0) {
            try {
                c = Class.forName("oracle.jdeveloper.cm.OracleJdbcConnectionType");
                this.registerConnectionType((ConnectionType)c.newInstance());
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) ** GOTO lbl39
                throw (ThreadDeath)t;
            }
        } else {
            for (i = 1; i <= nc; ++i) {
                block14: {
                    cTypeClass = null;
                    clazz = (String)ctypes.get("c" + i);
                    try {
                        cTypeClass = (ConnectionType)Class.forName(clazz).newInstance();
                    }
                    catch (Throwable t) {
                        System.err.println("Unable to create instance of ConnectionType");
                        System.err.println("Type=[ " + clazz + "]");
                        if (!(t instanceof ThreadDeath)) break block14;
                        throw (ThreadDeath)t;
                    }
                }
                this.registerConnectionType(cTypeClass);
            }
        }
lbl39:
        // 3 sources

        this._loadedConnectionTypes = true;
    }

    private void registerFactory(String type, String className) {
        try {
            this._connectionFactories.put(type, Class.forName(className).newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConnectionWrapper createNewConnection(String name, ConnectInfoPrompter prompter) throws IOException, CMException {
        ConnectionDescriptor cDesc = this.getConnectionDescriptorImpl(name);
        if (null == cDesc) {
            return null;
        }
        return this.createNewConnectionImpl(cDesc, prompter);
    }

    private ConnectionWrapper createNewConnectionImpl(ConnectionDescriptor descriptor, ConnectInfoPrompter prompter) throws CMException {
        ConnectionFactory factory;
        if (!this._loadedConnectionTypes) {
            this.registerConnectionTypes();
        }
        if (null == (factory = (ConnectionFactory)this._connectionFactories.get(descriptor.getConnectionType()))) {
            throw new CMException("Unable to instantiate connection factory (" + descriptor.getConnectionType() + ")");
        }
        ConnectionWrapper wrapper = factory.createConnection(descriptor, prompter, this);
        this.fireConnectionEvent(2, wrapper);
        return wrapper;
    }

    static InputStream getInputStream(Class clazz, String fName) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (fName.startsWith("/")) {
            fName = fName.substring(1);
        }
        InputStream inputStream = is = cl != null ? cl.getResourceAsStream(fName) : null;
        if (is == null) {
            is = clazz.getResourceAsStream(fName);
        }
        return is;
    }
}

