/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMXSLParamNames;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.InsertedDiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.ModifiedDiffTreeNode;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DiffTreeNode
extends DefaultMutableTreeNode
implements CMXSLParamNames {
    protected short m_diffType;
    protected int m_position = 0;
    protected boolean m_hasDiffDesc = false;
    private Node m_treeNode;
    private int m_attrNodes = 0;
    protected boolean m_isRootElement = false;
    public static final short NODE_NODIFFDESC = 0;
    public static final short NODE_INSERTED = 1;
    public static final short NODE_DELETED = 2;
    public static final short NODE_SAME = 3;
    public static final short NODE_MODIFIED = 4;
    public static final short NODE_MOVE_INSERTED = 5;

    public DiffTreeNode(Node node) {
        super(node);
        this.m_treeNode = node;
        this.m_diffType = (short)3;
    }

    public Node getNodeObject() {
        return this.m_treeNode;
    }

    public short getDiffType() {
        return this.m_diffType;
    }

    public void insert(DiffTreeNode newChildNode, int pos) {
        if (this.getChildCount() <= pos) {
            super.add(newChildNode);
        } else {
            super.insert(newChildNode, pos);
        }
    }

    protected void addXMLNode(Node node) {
        this.insert(new DiffTreeNode(node), this.m_position++);
    }

    protected void createTree() {
        Node node = this.getNodeObject();
        NamedNodeMap namednodemap = node.getAttributes();
        if (namednodemap != null) {
            this.setAttrNum(namednodemap.getLength());
            for (int j = 0; j < this.getAttrNum(); ++j) {
                this.addXMLNode(namednodemap.item(j));
            }
        }
        NodeList nodelist = node.getChildNodes();
        int k = nodelist.getLength();
        for (int l = 0; l < k; ++l) {
            this.addXMLNode(nodelist.item(l));
        }
    }

    @Override
    public String toString() {
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 2: {
                return ((Attr)node).getName() + "=\"" + ((Attr)node).getValue() + "\"";
            }
            case 8: {
                return "comment:" + ((Comment)node).getNodeValue();
            }
            case 10: {
                return "[DOCUMENT]";
            }
            case 11: {
                return "[DOCUMENT FRAGMENT]";
            }
            case 1: {
                return "<" + ((Element)node).getTagName() + ">";
            }
            case 7: {
                return "pi:" + ((ProcessingInstruction)node).getData();
            }
            case 3: {
                return "text:" + ((Text)node).getNodeValue();
            }
        }
        return "unknown";
    }

    protected void setAttrNum(int attrNum) {
        this.m_attrNodes = attrNum;
    }

    protected int getAttrNum() {
        return this.m_attrNodes;
    }

    protected String getDiffTypeDisplayString() {
        switch (this.m_diffType) {
            case 1: {
                return "INSERTED ++ ";
            }
            case 2: {
                return "DELETED  -- ";
            }
            case 4: {
                return "MODIFIED != ";
            }
            case 3: {
                return "            ";
            }
        }
        return "";
    }

    protected void printNode(BufferedWriter log) throws IOException {
        String s = this.toString();
        if (s != null && !s.trim().equals("")) {
            log.write(this.getDiffTypeDisplayString() + s);
            log.newLine();
        }
        int children = this.getChildCount();
        for (int i = 0; i < children; ++i) {
            ((DiffTreeNode)this.getChildAt(i)).printNode(log);
        }
    }

    private static boolean checkParentAttribute(Node node, String attrName, String attrValue) {
        XMLElement n = null;
        if (node == null) {
            return false;
        }
        Node p = node;
        if (!(p instanceof XMLElement)) {
            p = p.getParentNode();
        }
        if (!(p instanceof XMLElement)) {
            return false;
        }
        n = (XMLElement)p;
        if (n.getAttribute("src").compareToIgnoreCase(attrValue) == 0) {
            return true;
        }
        return DiffTreeNode.checkParentAttribute(n.getParentNode(), attrName, attrValue);
    }

    public void applyDiffToXml(XMLDocument xml1, XMLDocument xml2) {
        this.applyDiffToXml(xml1, xml2, "", false);
    }

    private void applyDiffToXml(XMLDocument xml1, XMLDocument xml2, String parentXPath, boolean setParent) {
        XMLNode xml = (XMLNode)this.getUserObject();
        String thisXPath = null;
        if (xml.getNodeType() == 1) {
            String nameAttr = "";
            if (((XMLElement)xml).hasAttribute("NAME")) {
                nameAttr = "[@NAME='" + ((XMLElement)xml).getAttribute("NAME") + "']";
            }
            StringBuffer xpsb = new StringBuffer(parentXPath).append("/sxml:").append(((XMLElement)xml).getTagName()).append(nameAttr);
            thisXPath = xpsb.toString();
        } else {
            thisXPath = parentXPath;
        }
        short diffType = this.getDiffType();
        switch (this.m_diffType) {
            case 1: {
                if (xml instanceof XMLText || xml instanceof XMLAttr) break;
                InsertedDiffTreeNode insNode = (InsertedDiffTreeNode)this;
                Node parNode = insNode.getDestNode();
                if (DiffTreeNode.checkParentAttribute((Node)xml, "src", "1")) break;
                ((XMLElement)xml).setAttribute("src", "1");
                Node importXml = xml2.importNode((Node)xml, true);
                parNode.appendChild(importXml);
                ((XMLElement)importXml).setAttribute("xpath", thisXPath);
                if (!setParent || ((XMLElement)importXml.getParentNode()).hasAttribute("xpath")) break;
                ((XMLElement)importXml.getParentNode()).setAttribute("xpath", parentXPath);
                break;
            }
            case 2: {
                if (xml instanceof XMLText || xml instanceof XMLAttr || DiffTreeNode.checkParentAttribute((Node)xml, "src", "2")) break;
                ((XMLElement)xml).setAttribute("src", "2");
                ((XMLElement)xml).setAttribute("xpath", thisXPath);
                if (!setParent || ((XMLElement)xml.getParentNode()).hasAttribute("xpath")) break;
                ((XMLElement)xml.getParentNode()).setAttribute("xpath", parentXPath);
                setParent = false;
                break;
            }
            case 4: {
                XMLElement modNode = (XMLElement)((XMLNode)((ModifiedDiffTreeNode)this).getModifiedNode().getUserObject()).getParentNode();
                if (modNode == null) break;
                String srcVal = xml.getNodeValue();
                modNode.setAttribute("value1", srcVal);
                modNode.setAttribute("xpath", thisXPath);
                if (!setParent || ((XMLElement)modNode.getParentNode()).hasAttribute("xpath")) break;
                ((XMLElement)modNode.getParentNode()).setAttribute("xpath", parentXPath);
            }
        }
        int children = this.getChildCount();
        boolean setThisParentsXpath = setParent || xml.getNodeType() == 1 && ((XMLElement)xml).getTagName().equals("COL_LIST_ITEM");
        for (int i = 0; i < children; ++i) {
            ((DiffTreeNode)this.getChildAt(i)).applyDiffToXml(xml1, xml2, thisXPath, setThisParentsXpath);
        }
    }

    protected void setDiffDesc() {
        this.m_hasDiffDesc = true;
    }

    protected void setParentDiffDesc() {
        TreeNode[] nodes = this.getPath();
        if (nodes != null) {
            int l = nodes.length;
            for (int i = 0; i < l; ++i) {
                DiffTreeNode n = (DiffTreeNode)nodes[i];
                if (n == null || n.hasDiffDesc()) continue;
                n.setDiffDesc();
            }
        }
    }

    protected boolean hasDiffDesc() {
        return this.m_diffType != 3 || this.m_hasDiffDesc;
    }

    protected void writeXMLNode(OutputStream os, String ddl1, String ddl2) throws IOException {
        this.startXMLNode(os);
        int children = this.getChildCount();
        for (int i = 0; i < children; ++i) {
            DiffTreeNode oneChild = (DiffTreeNode)this.getChildAt(i);
            if (oneChild == null || !oneChild.hasDiffDesc()) continue;
            oneChild.writeXMLNode(os, ddl1, ddl2);
        }
        if (ddl1 != null && ddl2 != null && this.m_isRootElement) {
            DiffTreeNode.writeDDLs(os, ddl1, ddl2);
        }
        this.endXMLNode(os);
    }

    private static void writeDDLs(OutputStream os, String ddl1, String ddl2) throws IOException {
        String ddlxmlstr1 = "<MDAPIDDL><![CDATA[" + ddl1 + "]]></MDAPIDDL>";
        String ddlxmlstr2 = "<MDAPIDDL><![CDATA[" + ddl2 + "]]></MDAPIDDL>";
        os.write(ddlxmlstr1.getBytes("UTF-8"));
        os.write(ddlxmlstr2.getBytes("UTF-8"));
    }

    protected void endXMLNode(OutputStream os) throws IOException {
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 1: {
                os.write(("</" + ((Element)node).getTagName() + ">").getBytes("UTF-8"));
            }
        }
    }

    protected void startXMLNode(OutputStream os) throws IOException {
        Node node = (Node)this.getUserObject();
        switch (node.getNodeType()) {
            case 1: {
                String s = "";
                if (this.m_diffType != 3) {
                    s = " DIFF=\"" + this.m_diffType + "\"";
                }
                if (((Element)node).hasAttribute("NAME")) {
                    s = s + " NAME=\"" + ((Element)node).getAttribute("NAME") + "\"";
                }
                if (((Element)node).hasAttribute("ENCRYPTED")) {
                    s = s + " ENCRYPTED=\"" + ((Element)node).getAttribute("ENCRYPTED") + "\"";
                }
                os.write(("<" + ((Element)node).getTagName() + s + ">").getBytes("UTF-8"));
                return;
            }
            case 3: {
                String s = "";
                if (this.m_diffType == 1) {
                    s = "<?INSERT ?>";
                } else if (this.m_diffType == 2) {
                    s = "<?DELETE ?>";
                }
                ((XMLText)node).print(os);
                os.write(s.getBytes("UTF-8"));
                return;
            }
        }
    }

    private String stripLF(String text) {
        int maxLength = 1000;
        StringBuffer sb = new StringBuffer(text);
        int len = sb.length();
        char[] textChars = new char[len];
        sb.getChars(0, len, textChars, 0);
        for (int i = 0; i < len; ++i) {
            if (textChars[i] != '\n') continue;
            sb.setCharAt(i, ' ');
        }
        if (sb.length() > maxLength) {
            sb.setLength(maxLength);
            sb.append("... (string truncated)");
        }
        return sb.toString();
    }
}

