/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.Colors;

public final class FieldLayoutBuilder {
    private static final int GAP = 5;
    private final GridBagConstraints _gbc = this.createInitialConstraints();
    private final Container _container;
    private boolean alignLabelsLeft = false;
    private boolean stretchComponentsWithNoButton = false;

    public FieldLayoutBuilder(Container container) {
        this._container = container;
        container.setLayout(new GridBagLayout());
    }

    public void setAlignLabelsLeft(boolean alignLabelsLeft) {
        this.alignLabelsLeft = alignLabelsLeft;
    }

    public void setStretchComponentsWithNoButton(boolean stretchComponents) {
        this.stretchComponentsWithNoButton = stretchComponents;
    }

    public void setMinimumWidth(int width) {
        this.addRow(Box.createHorizontalStrut(width));
    }

    private LabelSetup field(boolean indented) {
        FieldSetup f = new FieldSetup();
        f.indented = indented;
        return new LabelSetup(f);
    }

    public LabelSetup field() {
        return this.field(false);
    }

    public LabelSetup indentedField() {
        return this.field(true);
    }

    public HeaderSetup headerField() {
        FieldSetup f = new FieldSetup();
        f.spanWholeRow = true;
        return new HeaderSetup(f);
    }

    public void add(ComponentTextSetup c) {
        this.add(c.fieldSetup);
    }

    public void add(FieldSetup f) {
        this.startField();
        this.associateLabelAndComponent(f);
        if (f.spanWholeRow) {
            this.addRowSpanningComponent(f);
            this.addRowSpanningComponentHint(f);
        } else {
            this.addLabel(f);
            this.addComponent(f);
            this.addButton(f);
            this.addComponentHint(f);
        }
        this.endField();
    }

    private Component createHintComponent(String text) {
        MultiLineLabel l = new MultiLineLabel(WordWrapper.getTextWrapper(), text);
        l.setForeground(Colors.HINT_TEXT);
        return l;
    }

    private void addRowSpanningComponentHint(FieldSetup f) {
        if (f.componentHint == null) {
            return;
        }
        ++this._gbc.gridy;
        this._gbc.gridx = 0;
        this._gbc.gridwidth = 3;
        this._gbc.insets = new Insets(0, 0, 5, 0);
        this._gbc.weightx = 1.0;
        this._container.add(this.createHintComponent(f.componentHint), this._gbc);
        this._gbc.gridwidth = 1;
    }

    private void addComponentHint(FieldSetup f) {
        if (f.componentHint == null) {
            return;
        }
        ++this._gbc.gridy;
        this._gbc.gridx = 1;
        this._gbc.insets = new Insets(0, 0, 5, 0);
        this._gbc.weightx = 1.0;
        this._container.add(this.createHintComponent(f.componentHint), this._gbc);
    }

    private void addButton(FieldSetup f) {
        if (f.button == null) {
            return;
        }
        ++this._gbc.gridx;
        this._gbc.insets = new Insets(0, 5, 5, 0);
        this._gbc.weightx = 0.0;
        this._container.add((Component)f.button, this._gbc);
    }

    private void addRowSpanningComponent(FieldSetup f) {
        this._gbc.gridx = 0;
        this._gbc.gridwidth = 3;
        this._gbc.anchor = 17;
        this._gbc.fill = 2;
        this._gbc.insets = new Insets(0, 0, 5, 0);
        this._gbc.weightx = 1.0;
        this._container.add((Component)f.component, this._gbc);
        this._gbc.gridwidth = 1;
    }

    private void addComponent(FieldSetup f) {
        ++this._gbc.gridx;
        this._gbc.anchor = 17;
        this._gbc.fill = 2;
        this._gbc.insets = new Insets(0, 0, 5, 0);
        this._gbc.weightx = 1.0;
        if (f.button == null && this.stretchComponentsWithNoButton) {
            this._gbc.gridwidth = 2;
        }
        this._container.add((Component)f.component, this._gbc);
        this._gbc.gridwidth = 1;
    }

    private void addLabel(FieldSetup f) {
        if (f.label == null) {
            return;
        }
        int leftInset = f.indented ? 16 : 0;
        this._gbc.insets = new Insets(0, leftInset, 5, 5);
        this._gbc.anchor = this.alignLabelsLeft ? 17 : 13;
        this._container.add((Component)f.label, this._gbc);
    }

    private void startField() {
        this._gbc.gridx = 0;
        this._gbc.fill = 0;
        this._gbc.weightx = 0.0;
    }

    private void endField() {
        ++this._gbc.gridy;
    }

    private void associateLabelAndComponent(FieldSetup f) {
        if (f.label == null || f.component == null) {
            return;
        }
        f.label.setLabelFor(f.component);
    }

    private static void setText(JComponent component, String text) {
        String labelText = StringUtils.stripMnemonic((String)text);
        int mnemonicIndex = StringUtils.getMnemonicIndex((String)text);
        int mnemonicKey = StringUtils.getMnemonicKeyCode((String)text);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(labelText);
            label.setDisplayedMnemonic(mnemonicKey);
            label.setDisplayedMnemonicIndex(mnemonicIndex);
        } else if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            button.setText(labelText);
            button.setMnemonic(mnemonicKey);
            button.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private GridBagConstraints createInitialConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        return gbc;
    }

    public void addVerticalGap() {
        this.addRow(Box.createVerticalStrut(5));
    }

    public void addRow(Component c) {
        this.addRow(c, 0, 0.0f, 0.0f, 0);
    }

    public void addHintText(String text) {
        JLabel l = new JLabel(text);
        l.setForeground(Colors.HINT_TEXT);
        this.addRow(l);
        this.addVerticalGap();
        this.addVerticalGap();
    }

    private void addRow(Component c, int vgap, float weightx, float weighty, int fill) {
        this.startField();
        this._gbc.gridwidth = 3;
        this._gbc.insets = new Insets(0, 0, vgap, 0);
        this._gbc.weightx = weightx;
        this._gbc.weighty = weighty;
        int oldFill = this._gbc.fill;
        this._gbc.fill = fill;
        this._container.add(c, this._gbc);
        this._gbc.gridwidth = 1;
        this._gbc.weightx = 0.0;
        this._gbc.weighty = 0.0;
        this._gbc.fill = oldFill;
        this.endField();
    }

    public void addVerticalField(JLabel label, Component c) {
        this.addVerticalField(label, c, 0.0f);
    }

    public void addVerticalField(JLabel label, Component c, float componentVerticalWeight) {
        this.addRow(label, 5, 0.0f, 0.0f, 0);
        this.addRow(c, 5, 1.0f, componentVerticalWeight, 1);
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        label.setLabelFor(c);
    }

    public void addVerticalField(String labelText, Component c) {
        this.addVerticalField(labelText, c, 0.0f);
    }

    public void addVerticalField(String labelText, Component c, float componentVerticalWeight) {
        this.addVerticalField(new JLabel(labelText), c, componentVerticalWeight);
    }

    public void addVerticalSpring() {
        this.startField();
        this._gbc.gridwidth = 3;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        this._gbc.weighty = 1.0;
        this._container.add(Box.createVerticalStrut(0), this._gbc);
        this._gbc.gridwidth = 1;
        this._gbc.weighty = 0.0;
        this.endField();
    }

    public static final class FieldSetup {
        private JLabel label;
        private JComponent component;
        private String componentHint;
        private AbstractButton button;
        private boolean indented;
        private boolean spanWholeRow;

        public ButtonTextSetup button(AbstractButton button) {
            this.button = button;
            return new ButtonTextSetup(this);
        }
    }

    public static final class HeaderSetup {
        private FieldSetup fieldSetup;

        HeaderSetup(FieldSetup fieldSetup) {
            this.fieldSetup = fieldSetup;
        }

        public ComponentTextSetup component(JComponent component) {
            this.fieldSetup.component = component;
            return new ComponentTextSetup(this.fieldSetup);
        }
    }

    public static final class ButtonTextSetup {
        private FieldSetup fieldSetup;

        ButtonTextSetup(FieldSetup fieldSetup) {
            this.fieldSetup = fieldSetup;
        }

        public FieldSetup withText(String text) {
            FieldLayoutBuilder.setText(this.fieldSetup.button, text);
            return this.fieldSetup;
        }
    }

    public static final class ButtonSetup {
        private FieldSetup fieldSetup;

        ButtonSetup(FieldSetup feildSetup) {
            this.fieldSetup = feildSetup;
        }

        public ButtonTextSetup button(AbstractButton button) {
            this.fieldSetup.button = button;
            return new ButtonTextSetup(this.fieldSetup);
        }
    }

    public static final class ComponentTextSetupWithButton
    extends ComponentTextSetup {
        ComponentTextSetupWithButton(FieldSetup fieldSetup) {
            super(fieldSetup);
        }

        public ButtonTextSetup button(AbstractButton button) {
            this.fieldSetup.button = button;
            return new ButtonTextSetup(this.fieldSetup);
        }
    }

    public static class ComponentTextSetup {
        protected final FieldSetup fieldSetup;

        ComponentTextSetup(FieldSetup fieldSetup) {
            this.fieldSetup = fieldSetup;
        }

        public FieldSetup withText(String text) {
            FieldLayoutBuilder.setText(this.fieldSetup.component, text);
            return this.fieldSetup;
        }

        public FieldSetup withHint(String hint) {
            this.fieldSetup.componentHint = hint;
            return this.fieldSetup;
        }
    }

    public static final class ComponentSetup {
        private final FieldSetup fieldSetup;

        ComponentSetup(FieldSetup fieldSetup) {
            this.fieldSetup = fieldSetup;
        }

        public ComponentTextSetupWithButton component(JComponent component) {
            this.fieldSetup.component = component;
            return new ComponentTextSetupWithButton(this.fieldSetup);
        }
    }

    public static final class LabelTextSetup {
        private final FieldSetup fieldSetup;

        LabelTextSetup(FieldSetup fieldSetUp) {
            this.fieldSetup = fieldSetUp;
        }

        public ComponentSetup withText(String text) {
            FieldLayoutBuilder.setText(this.fieldSetup.label, text);
            return new ComponentSetup(this.fieldSetup);
        }
    }

    public static final class LabelSetup {
        private final FieldSetup fieldSetup;

        LabelSetup(FieldSetup fieldSetup) {
            this.fieldSetup = fieldSetup;
        }

        public LabelTextSetup label(JLabel label) {
            this.fieldSetup.label = label;
            return new LabelTextSetup(this.fieldSetup);
        }

        public LabelTextSetup label() {
            return this.label(new JLabel());
        }

        public ComponentTextSetupWithButton component(JComponent component) {
            this.fieldSetup.component = component;
            return new ComponentTextSetupWithButton(this.fieldSetup);
        }
    }
}

