/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchField;

public final class MiniSearchField {
    private JPanel content = new JPanel();
    private final JButton button;
    private final SearchField searchField;
    private boolean active;

    public MiniSearchField(SearchField.Style style) {
        this.content.setOpaque(false);
        this.button = new JButton(OracleIcons.getIcon((String)"search.png"));
        this.button.addActionListener(e -> this.setActive(true));
        this.active = false;
        this.searchField = new SearchField(style);
        this.content.add(this.button);
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.content.removeAll();
        this.content.add(active ? this.searchField : this.button);
    }

    public boolean isActive() {
        return this.active;
    }

    public JComponent getGUI() {
        return this.content;
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(200, 50);
        frame.setLocationRelativeTo(null);
        MiniSearchField sf = new MiniSearchField(SearchField.Style.FILTER);
        frame.add(sf.getGUI());
        frame.setVisible(true);
    }
}

