/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.simplestyle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;

public class StyledTextModel {
    private List<TextRun> runList = new LinkedList<TextRun>();
    private List<List<TextRun>> lineList = new LinkedList<List<TextRun>>();

    public StyledTextModel() {
        this.lineList.add(this.runList);
    }

    public StyledTextModel(String initialText) {
        this(initialText, new StyledTextAttribute());
    }

    public StyledTextModel(String initialText, StyledTextAttribute initialStyle) {
        this();
        this.addText(initialText, initialStyle);
    }

    public void append(StyledTextModel model) {
        this.lineList.get(this.lineList.size() - 1).addAll(model.runList);
        for (int line = 1; line < model.lineList.size(); ++line) {
            this.lineList.add(model.lineList.get(line));
        }
    }

    public void addText(String text) {
        TextRun pair = new TextRun();
        pair.text = text;
        pair.attr = StyledTextAttribute.defaultStyledTextAttribute;
        this.runList.add(pair);
    }

    public void addText(String text, StyledTextAttribute attr) {
        TextRun pair = new TextRun();
        pair.text = text;
        pair.attr = attr;
        this.runList.add(pair);
    }

    public void prependText(String text, StyledTextAttribute attr) {
        TextRun pair = new TextRun();
        pair.text = text;
        pair.attr = attr;
        this.runList.add(0, pair);
    }

    public void addLineBreak() {
        this.runList = new LinkedList<TextRun>();
        this.lineList.add(this.runList);
    }

    Iterator<TextRun> runIterator(int line) {
        return this.lineList.get(line).iterator();
    }

    int getLineCount() {
        return this.lineList.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StyledTextModel)) {
            return false;
        }
        StyledTextModel that = (StyledTextModel)o;
        if (!this.lineList.equals(that.lineList)) {
            return false;
        }
        return this.runList.equals(that.runList);
    }

    public String toString() {
        String s = "";
        for (List<TextRun> runList : this.lineList) {
            for (TextRun run : runList) {
                s = s + run.attr + " : " + run.text;
            }
            s = s + "\n";
        }
        return this.toSimpleString(true);
    }

    public String toSimpleString(boolean includeAttr) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (List<TextRun> runList : this.lineList) {
            for (TextRun run : runList) {
                if (includeAttr) {
                    sb.append(run.attr);
                    sb.append(" : ");
                }
                sb.append(run.text);
            }
            sb.append(sep);
            sep = "\n";
        }
        return sb.toString();
    }

    static class TextRun {
        String text;
        StyledTextAttribute attr;

        TextRun() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof TextRun)) {
                return false;
            }
            TextRun that = (TextRun)o;
            if (!this.text.equals(that.text)) {
                return false;
            }
            return this.attr.equals(that.attr);
        }
    }
}

