/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.PopupButton;
import oracle.bali.ewt.menu.ToggleMenuItem;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.TableUIManager;

class ColumnSelector
extends PopupButton {
    private static Icon _sArrowIcon;
    private JTable _table;
    private boolean _dirty;
    private Map _hiddenColumns;
    private Listener _listener;
    private boolean _focusHighlight;
    private Action _selectColumns;
    private Action[] _columnSelectorActions;

    public ColumnSelector(JTable table) {
        super(ColumnSelector._sGetArrowIcon());
        this.setBorder(new MatteBorder(0, 1, 1, 0, Colors.FLAT_EDITOR_BORDER));
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this._table = table;
        this._hiddenColumns = new HashMap();
        this._dirty = true;
        JPopupMenu multiMenu = new JPopupMenu();
        this.setPopupMenu(multiMenu);
        this.setDelay(0);
        this._listener = new Listener();
        multiMenu.addPopupMenuListener(this._listener);
        this._table.getColumnModel().addColumnModelListener(this._listener);
        this._table.addPropertyChangeListener("columnModel", this._listener);
        this._table.addPropertyChangeListener("model", this._listener);
        this._table.getModel().addTableModelListener(this._listener);
        this.putClientProperty("AccessibleName", UIBundle.get("TABLE_COL_SELECTOR_ACC_NAME"));
        this.enableEvents(48L);
    }

    public void dispose() {
        JPopupMenu colSelMenu = this.getPopupMenu();
        if (colSelMenu != null) {
            colSelMenu.removePopupMenuListener(this._listener);
        }
        this._table.getColumnModel().removeColumnModelListener(this._listener);
        this._table.removePropertyChangeListener("columnModel", this._listener);
        this._table.removePropertyChangeListener("model", this._listener);
        this._table.getModel().removeTableModelListener(this._listener);
    }

    public JTable getTable() {
        return this._table;
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        JTableHeader header;
        if (hiddenColumns == null) {
            hiddenColumns = new int[]{};
        }
        if (hiddenColumns.length == 0) {
            this._hiddenColumns.clear();
        }
        if ((header = this._table.getTableHeader()) == null) {
            return;
        }
        TableColumnModel cModel = header.getColumnModel();
        for (int i = 0; i < hiddenColumns.length; ++i) {
            int modelCol = hiddenColumns[i];
            if (this._hiddenColumns.containsKey(modelCol)) continue;
            int viewCol = this._table.convertColumnIndexToView(modelCol);
            TableColumn tc = cModel.getColumn(viewCol);
            this.setColumnVisible(tc, modelCol, false);
        }
    }

    public int[] getHiddenColumns() {
        if (this._hiddenColumns == null) {
            return new int[0];
        }
        int[] colIdx = new int[this._hiddenColumns.size()];
        int i = 0;
        Iterator it = this._hiddenColumns.keySet().iterator();
        while (it.hasNext()) {
            colIdx[i++] = (Integer)it.next();
        }
        return colIdx;
    }

    final Map getHiddenColumnsMap() {
        return Collections.unmodifiableMap(this._hiddenColumns);
    }

    public void setHiddenColumnsVisible(int[] columns) {
        if (columns == null) {
            return;
        }
        for (int column : columns) {
            TableColumn tableColumn = (TableColumn)this._hiddenColumns.get(column);
            if (tableColumn == null) continue;
            this.setColumnVisible(tableColumn, column, true);
        }
    }

    public void setSelectColumnsAction(Action selectColumns) {
        if (this._selectColumns != selectColumns) {
            this._selectColumns = selectColumns;
            this._dirty = true;
        }
    }

    public Action getSelectColumnsAction() {
        return this._selectColumns;
    }

    public void setColumnSelectorActions(Action ... actions) {
        if (this._columnSelectorActions != actions) {
            this._columnSelectorActions = actions;
            this._dirty = true;
        }
    }

    public Action[] getColumnSelectorActions() {
        return this._columnSelectorActions;
    }

    public void paintComponent(Graphics g) {
        int height = this.getHeight();
        ButtonModel model = this.getModel();
        if (this.hasFocus() || this._focusHighlight) {
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Paint oldP = g2.getPaint();
                Color top = Color.white;
                Color bottom = TableUIManager.COL_SEL_FOCUS_GRAD;
                GradientPaint grad = new GradientPaint(0.0f, 0.0f, top, 0.0f, height, bottom);
                g2.setPaint(grad);
                g.fillRect(0, 0, this.getWidth(), height);
                g2.setPaint(oldP);
            }
        } else {
            Color newC = model.isArmed() && model.isPressed() ? Colors.FLAT_EDITOR_BORDER : TableUIManager.COL_SEL_BACK;
            Color old = g.getColor();
            g.setColor(newC);
            g.fillRect(0, 0, this.getWidth(), height);
            g.setColor(old);
        }
        super.paintComponent(g);
    }

    protected void setColumnVisible(TableColumn column, int modelColumn, boolean isVisible) {
        TableColumnModel columnModel = this._table.getTableHeader().getColumnModel();
        if (isVisible) {
            this._hiddenColumns.remove(new Integer(modelColumn));
            columnModel.addColumn(column);
            int destColumn = modelColumn < columnModel.getColumnCount() ? modelColumn : columnModel.getColumnCount() - 1;
            columnModel.moveColumn(columnModel.getColumnCount() - 1, destColumn);
        } else {
            TableModel model = this._table.getModel();
            if (!(model instanceof GenericTableModel) || ((GenericTableModel)((Object)model)).canHide(modelColumn)) {
                columnModel.removeColumn(column);
                this._hiddenColumns.put(new Integer(modelColumn), column);
            }
        }
    }

    protected void processMouseEvent(MouseEvent me) {
        super.processMouseEvent(me);
        switch (me.getID()) {
            case 504: {
                this._focusHighlight = true;
                break;
            }
            default: {
                this._focusHighlight = false;
            }
        }
        this.repaint();
    }

    protected void processMouseMotionEvent(MouseEvent me) {
        super.processMouseMotionEvent(me);
        switch (me.getID()) {
            case 503: {
                this._focusHighlight = true;
                break;
            }
            default: {
                this._focusHighlight = false;
            }
        }
        this.repaint();
    }

    private static Icon _sGetArrowIcon() {
        if (_sArrowIcon == null) {
            _sArrowIcon = new ArrowIcon();
        }
        return _sArrowIcon;
    }

    private void _updatePopupMenu() {
        if (this._dirty) {
            JPopupMenu popupMenu = this.getPopupMenu();
            popupMenu.removeAll();
            int modelColCount = this._table.getModel().getColumnCount();
            TableModel model = this._table.getModel();
            for (int modelColumn = 0; modelColumn < modelColCount; ++modelColumn) {
                boolean isVisible;
                TableColumn tc;
                int viewColumn = this._table.convertColumnIndexToView(modelColumn);
                if (viewColumn > -1) {
                    tc = this._table.getTableHeader().getColumnModel().getColumn(viewColumn);
                    isVisible = true;
                } else {
                    tc = (TableColumn)this._hiddenColumns.get(new Integer(modelColumn));
                    isVisible = false;
                }
                if (tc == null) continue;
                TableColumnToggleAction action = new TableColumnToggleAction(tc, modelColumn, isVisible);
                ToggleMenuItem mi = new ToggleMenuItem((Action)action);
                mi.setSelected(isVisible);
                if (model instanceof GenericTableModel) {
                    mi.setEnabled(((GenericTableModel)((Object)model)).canHide(modelColumn));
                } else if (modelColumn == 0) {
                    mi.setEnabled(false);
                }
                popupMenu.add((JMenuItem)mi);
            }
            Action selectAllAction = this.getSelectColumnsAction();
            Action[] selectorActions = this.getColumnSelectorActions();
            if (selectAllAction != null || selectorActions != null && selectorActions.length > 0) {
                popupMenu.addSeparator();
            }
            if (selectAllAction != null) {
                popupMenu.add(selectAllAction);
            }
            if (selectorActions != null) {
                for (int i = 0; i < selectorActions.length; ++i) {
                    popupMenu.add(selectorActions[i]);
                }
            }
            this._dirty = false;
        }
    }

    private class TableColumnToggleAction
    extends AbstractAction {
        private boolean _visible;
        private final int _modelColumn;
        private final TableColumn _column;

        private TableColumnToggleAction(TableColumn column, int modelColumn, boolean isVisible) {
            Object headerValue = column.getHeaderValue();
            this.putValue("Name", headerValue == null ? "(No Column Name)" : headerValue.toString());
            this._column = column;
            this._modelColumn = modelColumn;
            this._visible = isVisible;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ColumnSelector.this.setColumnVisible(this._column, this._modelColumn, !this._visible);
            this._visible = !this._visible;
        }
    }

    private class Listener
    implements PopupMenuListener,
    TableColumnModelListener,
    PropertyChangeListener,
    TableModelListener {
        private Listener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ColumnSelector.this._updatePopupMenu();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            ColumnSelector.this._dirty = true;
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            ColumnSelector.this._dirty = true;
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            ColumnSelector.this._dirty = true;
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            ColumnSelector.this._dirty = true;
            if ("model".equals(pe.getPropertyName())) {
                ColumnSelector.this._hiddenColumns.clear();
            } else {
                TableColumnModel oldModel = (TableColumnModel)pe.getOldValue();
                if (oldModel != null) {
                    oldModel.removeColumnModelListener(this);
                }
                ColumnSelector.this._hiddenColumns.clear();
                TableColumnModel newModel = (TableColumnModel)pe.getOldValue();
                if (newModel != null) {
                    newModel.addColumnModelListener(this);
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1) {
                int i;
                TableColumn[] columns = ColumnSelector.this._hiddenColumns.values().toArray(new TableColumn[0]);
                if (columns == null || columns.length == 0) {
                    return;
                }
                ColumnSelector.this._hiddenColumns.clear();
                TableModel model = ColumnSelector.this._table.getModel();
                int colCount = model.getColumnCount();
                block0: for (i = 0; i < columns.length; ++i) {
                    TableColumn c = columns[i];
                    Object hV = c.getHeaderValue();
                    for (int j = 0; j < colCount; ++j) {
                        if (!hV.equals(colCount)) continue;
                        c.setModelIndex(j);
                        continue block0;
                    }
                }
                for (i = 0; i < columns.length; ++i) {
                    ColumnSelector.this._hiddenColumns.put(new Integer(columns[i].getModelIndex()), columns[i]);
                }
            }
        }
    }

    private static class ArrowIcon
    implements Icon {
        private static final Dimension SORT_ICON_SIZE = new Dimension(8, 4);

        private ArrowIcon() {
        }

        @Override
        public int getIconHeight() {
            return ArrowIcon.SORT_ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return ArrowIcon.SORT_ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawLine(x, y, x + 7, y);
            g.drawLine(x + 1, y + 1, x + 6, y + 1);
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 3, y + 3, x + 4, y + 3);
        }
    }
}

