/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.javatools.ui.table.DisplayableTable;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.LegacyTableModel;
import oracle.javatools.ui.table.TableUIManager;

public class GenericTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer _defaultRenderer;

    public GenericTableCellRenderer() {
        this(new DefaultTableCellRenderer());
    }

    public GenericTableCellRenderer(TableCellRenderer defaultRenderer) {
        this._defaultRenderer = defaultRenderer;
    }

    public TableCellRenderer getBaseRenderer() {
        return this._defaultRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        List<RowSorter.SortKey> sortKeys;
        RowSorter<? extends TableModel> sorter;
        Component comp;
        String convertValue;
        if (value != null && table instanceof DisplayableTable && (convertValue = ((DisplayableTable)((Object)table)).convertValueToText(value, isSelected, hasFocus, row, column)) != null) {
            value = convertValue;
        }
        if ((comp = this._defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel) {
            comp.setEnabled(table.isEnabled());
            TableModel model = table.getModel();
            if (model instanceof GenericTableModel) {
                ((JLabel)comp).setHorizontalAlignment(((GenericTableModel)((Object)model)).getColumnAlignment(table.convertColumnIndexToModel(column)));
            } else if (model instanceof LegacyTableModel) {
                ((JLabel)comp).setHorizontalAlignment(((LegacyTableModel)((Object)model)).getColumnAlignment(table.convertColumnIndexToModel(column)));
            }
        }
        boolean setDefaultBackground = true;
        if (!isSelected && (sorter = table.getRowSorter()) != null && (sortKeys = sorter.getSortKeys()).size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
            switch (sortKeys.get(0).getSortOrder()) {
                case ASCENDING: 
                case DESCENDING: {
                    Color c = TableUIManager.SORTED_COL_BACK;
                    if (table instanceof GenericTable) {
                        c = ((GenericTable)table).getSortColumnBackgroundColor();
                    }
                    comp.setBackground(c);
                    setDefaultBackground = false;
                }
            }
        }
        if (setDefaultBackground) {
            if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
            } else {
                comp.setBackground(table.getBackground());
            }
        }
        if (isSelected) {
            comp.setForeground(table.getSelectionForeground());
        } else {
            comp.setForeground(table.getForeground());
        }
        return comp;
    }
}

