/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ideimpl.webupdate.InstallProgressPanel;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.AnimatedCellIcon;

public class InstallProgressMonitor {
    private InstallProgressPanel owner;
    private boolean cancelled;

    public InstallProgressMonitor(InstallProgressPanel owner) {
        this.owner = owner;
    }

    public void setStatus(final String id, final InstallStatus status, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallProgressMonitor.this.owner.setStatus(id, status, message);
            }
        });
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static enum InstallStatus {
        INSTALLED(UpdateArb.getString(225), "check.png"),
        INSTALLING(UpdateArb.getString(226), "throbber.gif"),
        WAITING_TO_INSTALL(UpdateArb.getString(227), "tasks.png"),
        UNINSTALLED(UpdateArb.getString(228), "check.png"),
        UNINSTALLING(UpdateArb.getString(229), "throbber.gif"),
        WAITING_TO_UNINSTALL(UpdateArb.getString(230), "tasks.png"),
        CANCELLED(UpdateArb.getString(231), "exception.png"),
        FAILED(UpdateArb.getString(232), "error.png");

        private static Icon installingIcon;
        private String displayText;
        private String iconKey;

        private InstallStatus(String displayText, String iconKey) {
            this.displayText = displayText;
            this.iconKey = iconKey;
        }

        public String toString() {
            return this.displayText;
        }

        public Icon getIcon() {
            if (this == INSTALLING || this == UNINSTALLING) {
                return installingIcon;
            }
            return OracleIcons.getIcon((String)this.iconKey);
        }

        static {
            installingIcon = new AnimatedCellIcon(OracleIcons.getIcon((String)"throbber.gif"));
        }
    }
}

