/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ant.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class DBToolsAntlrTask
extends Task {
    private String m_grammars;
    private File m_sourceDirectory;
    private String m_outputDirectory;
    private CommandlineJava commandline = new CommandlineJava();
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public void setupAntlr() {
        System.out.println("DBToolsAntlrTask in use");
        this.commandline = new CommandlineJava();
        this.commandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.commandline.setClassname("antlr.Tool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        StringTokenizer st = new StringTokenizer(this.getGrammars(), ",");
        while (st.hasMoreTokens()) {
            this.init();
            String eachGrammar = st.nextToken().trim();
            String traceStr = null;
            if (eachGrammar.indexOf("-traceParser") != -1) {
                StringTokenizer trace = new StringTokenizer(eachGrammar, " ");
                traceStr = trace.nextToken();
                eachGrammar = trace.nextToken();
            }
            String superStr = null;
            if (eachGrammar.indexOf("-glib") != -1) {
                StringTokenizer glib = new StringTokenizer(eachGrammar, " ");
                String glibStr = glib.nextToken();
                superStr = glib.nextToken();
                eachGrammar = glib.nextToken();
            }
            File grammar = new File(this.getSourceDirectory(), eachGrammar);
            String superGramStr = "";
            if (superStr != null) {
                if (superStr.indexOf(";") != -1) {
                    String superGram = null;
                    File superGramFile = null;
                    StringTokenizer superGrams = new StringTokenizer(superStr, ";");
                    while (superGrams.hasMoreTokens()) {
                        superGram = superGrams.nextToken();
                        superGramFile = new File(this.getSourceDirectory(), superGram);
                        superGramStr = superGramStr + ";" + superGramFile.getAbsolutePath();
                    }
                    superGramStr = superGramStr.substring(1);
                } else {
                    File superGramFile = new File(this.getSourceDirectory(), superStr);
                    superGramStr = superGramFile.getAbsolutePath();
                }
            }
            File generated = null;
            try {
                generated = this.getGeneratedFile(grammar.getPath(), this.getOutputDirectory());
            }
            catch (Exception e) {
                System.out.println(e.getLocalizedMessage());
                throw new BuildException("Failed to get generated file", (Throwable)e);
            }
            if (generated.exists() && generated.lastModified() > grammar.lastModified()) continue;
            if (!generated.getParentFile().exists()) {
                generated.getParentFile().mkdirs();
            }
            String[] args = null;
            args = superStr == null ? (traceStr == null ? new String[]{"-o", generated.getParentFile().getPath(), grammar.getPath()} : new String[]{"-o", generated.getParentFile().getPath(), traceStr, grammar.getPath()}) : (traceStr == null ? new String[]{"-o", generated.getParentFile().getPath(), "-glib", superGramStr, grammar.getPath()} : new String[]{"-o", generated.getParentFile().getPath(), traceStr, "-glib", superGramStr, grammar.getPath()});
            try {
                String commandLineStr = "";
                for (String arg : args) {
                    commandLineStr = commandLineStr + " " + arg;
                    this.commandline.createArgument().setValue(arg);
                }
                System.out.println(commandLineStr);
                this.log(this.commandline.describeCommand(), 3);
                int err = this.run(this.commandline.getCommandline());
                System.out.println("DBToolsAntlrTask 7");
                if (err != 0) {
                    throw new BuildException("ANTLR returned: " + err, this.getLocation());
                }
                String output = this.bos.toString();
                if (output.indexOf("error:") > -1) {
                    throw new BuildException("ANTLR signaled an error: " + output, this.getLocation());
                }
            }
            catch (SecurityException e) {
                System.out.println(e.getLocalizedMessage());
                if (!e.getMessage().equals("exitVM-0")) {
                    throw new BuildException("Execution failed", (Throwable)e);
                }
            }
            catch (Exception e2) {
                System.out.println(e2.getLocalizedMessage());
                e2.printStackTrace();
            }
            catch (Throwable t) {
                System.out.println(t.getLocalizedMessage());
                t.printStackTrace();
            }
            System.out.println("Antlr SuccessFull");
        }
    }

    private int run(String[] command) throws BuildException {
        System.out.println("DBToolsAntlrTask 1");
        OutputStream dummy = new OutputStream(){

            @Override
            public void write(int i) {
            }
        };
        System.out.println("DBToolsAntlrTask 2");
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.out);
        System.out.println("DBToolsAntlrTask 3");
        Execute exe = new Execute((ExecuteStreamHandler)psh, null);
        System.out.println("DBToolsAntlrTask 4");
        AntClassLoader l = this.getProject().createClassLoader(this.commandline.getClasspath());
        System.out.println("ANT CLASSPATH:" + l.getClasspath());
        exe.setAntRun(this.getProject());
        System.out.println("DBToolsAntlrTask 5");
        exe.setCommandline(command);
        System.out.println("DBToolsAntlrTask 6");
        try {
            int n = exe.execute();
            return n;
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            FileUtils.close((OutputStream)this.bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean is272() {
        AntClassLoader l = null;
        try {
            l = this.getProject().createClassLoader(this.commandline.getClasspath());
            l.loadClass("antlr.Version");
            boolean bl = true;
            return bl;
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (l != null) {
                l.cleanup();
            }
        }
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        this.setupAntlr();
        this.addClasspathEntry("/antlr/ANTLRGrammarParseBehavior.class");
    }

    protected void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.createClasspath().setLocation(f);
        } else {
            this.log("Couldn't find " + resource, 3);
        }
    }

    protected File getGeneratedFile(String grammar, String outputDirectory) throws Exception {
        String generatedFileName = null;
        String packageName = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(grammar));
            while ((line = in.readLine()) != null) {
                line = line.trim();
                int extendsIndex = line.indexOf(" extends ");
                if (line.startsWith("class ") && extendsIndex > -1) {
                    generatedFileName = line.substring(6, extendsIndex).trim();
                    break;
                }
                if (!line.startsWith("package")) continue;
                packageName = line.substring(8).trim();
            }
            in.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to determine generated class", e);
        }
        if (generatedFileName == null) {
            return null;
        }
        File genFile = null;
        if ("".equals(packageName)) {
            System.out.println("no package info");
            genFile = new File(outputDirectory, generatedFileName + ".java");
        } else {
            String packagePath = packageName.replace('.', File.separatorChar);
            packagePath = packagePath.replace(';', File.separatorChar);
            genFile = new File(new File(outputDirectory, packagePath), generatedFileName + ".java");
        }
        return genFile;
    }

    public String getGrammars() {
        return this.m_grammars;
    }

    public void setGrammars(String grammars) {
        this.m_grammars = grammars;
    }

    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.m_outputDirectory = outputDirectory;
    }

    public File getSourceDirectory() {
        return this.m_sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.m_sourceDirectory = sourceDirectory;
    }
}

