/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester.extensions;

import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.Robot;
import abbot.tester.extensions.CustomTabLocation;
import abbot.util.Condition;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;

public class CustomTabTester
extends JComponentTester {
    public void actionClick(final Component c, ComponentLocation loc) {
        if (loc instanceof CustomTabLocation) {
            final FetchTab mo = new FetchTab(c, loc);
            CustomTabTester.wait((Condition)new Robot.ConditionEDTDecorator(c, new Condition(){

                public boolean test() {
                    return mo.call() != null;
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder("Page not found in list [");
                    CustomTab ct = (CustomTab)c;
                    int i = ct.getPageCount();
                    for (int j = 0; j < i; ++j) {
                        CustomTabPage ctp = ct.getPage(j);
                        String label = ctp.getLabel();
                        sb.append(label);
                    }
                    sb.append("]  in component ");
                    sb.append(c);
                    return sb.toString();
                }
            }), (long)(defaultDelay / 4));
            CustomTabPage found = mo.call();
            if (found == null) {
                throw new IllegalStateException("Page not found");
            }
            Rectangle bounds = found.getBounds();
            this.actionClick(c, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        } else {
            super.actionClick(c, loc);
        }
    }

    public ComponentLocation getLocation(Component c, Point where) {
        CustomTab ct = (CustomTab)c;
        int index = ct.getPageAt(where);
        if (index != -1) {
            CustomTabPage ctp = ct.getPage(index);
            String label = ctp.getLabel();
            return new CustomTabLocation(label);
        }
        return super.getLocation(c, where);
    }

    public ComponentLocation parseLocation(String encoded) {
        if (encoded.startsWith("(")) {
            return super.parseLocation(encoded);
        }
        return new CustomTabLocation(encoded);
    }

    private class FetchTab
    implements Callable<CustomTabPage> {
        private Component c;
        private ComponentLocation loc;
        private CustomTabPage found;

        public FetchTab(Component c, ComponentLocation loc) {
            this.c = c;
            this.loc = loc;
        }

        @Override
        public CustomTabPage call() {
            CustomTab ct = (CustomTab)this.c;
            String tab = ((CustomTabLocation)this.loc).getTab();
            this.found = null;
            int i = ct.getPageCount();
            for (int j = 0; j < i; ++j) {
                CustomTabPage ctp = ct.getPage(j);
                String label = ctp.getLabel();
                if (!tab.equals(label)) continue;
                this.found = ctp;
                break;
            }
            return this.found;
        }

        public CustomTabPage getFound() {
            return this.found;
        }

        public Component getC() {
            return this.c;
        }

        public ComponentLocation getLoc() {
            return this.loc;
        }
    }
}

