/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester.extensions;

import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.Matcher;
import abbot.finder.matchers.ClassMatcher;
import abbot.tester.JComboBoxTester;
import abbot.tester.JTreeTester;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.combo.JTreeCombo;

public class JTreeComboTester
extends JComboBoxTester {
    private JTreeTester tester = new JTreeTester();

    public JComponent findPopupFromUI(JComboBox sb) {
        try {
            Method $getTree = JTreeCombo.class.getDeclaredMethod("getTree", new Class[0]);
            $getTree.setAccessible(true);
            JTree jtree = (JTree)$getTree.invoke((Object)sb, new Object[0]);
            for (int i = 0; i < jtree.getRowCount(); ++i) {
                jtree.expandRow(i);
            }
            return jtree;
        }
        catch (Exception e) {
            throw new RuntimeException("The implementation of the tree has changed", e);
        }
    }

    public String getValueAsString(JComboBox combo, JComponent popupComponent, Object item, int index) {
        if (index == -1) {
            return null;
        }
        JTree tree = (JTree)popupComponent;
        TreePath path = tree.getPathForRow(index);
        TreePath stringPath = JTreeTester.pathToStringPath((JTree)tree, (TreePath)path);
        String suggestedValue = stringPath.toString();
        if (suggestedValue.startsWith("[ROOT, ")) {
            suggestedValue = '[' + suggestedValue.substring("[ROOT, ".length());
        }
        return suggestedValue;
    }

    protected void selectIndexInPopup(Component popup, int index) {
        JTree tree = (JTree)popup;
        this.tester.actionSelectRow((Component)tree, index);
    }

    protected Component findPopupComponent(Container parent) {
        try {
            ComponentFinder finder = BasicFinder.getDefault();
            return finder.find(parent, (Matcher)new ClassMatcher(JTree.class));
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public Class getTargetClass() {
        return JTreeCombo.class;
    }
}

