/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester.extensions;

import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.extensions.GutterLocation;
import abbot.util.AWT;
import abbot.util.Condition;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;

public class LineGutterPluginTester
extends JComponentTester {
    public void actionClick(Component c, int line) {
        this.actionClick(c, new GutterLocation(line, null));
    }

    public void actionClick(Component c, int line, String column) {
        this.actionClick(c, new GutterLocation(line, column));
    }

    public void actionClick(Component c, ComponentLocation loc) {
        if (loc instanceof GutterLocation) {
            GutterLocation gl = (GutterLocation)loc;
            LineGutterPlugin lgp = (LineGutterPlugin)c;
            BasicEditorPane bep = lgp.getEditor();
            Point clickPoint = LineGutterPluginTester.convertLocationToPoint(lgp, bep, gl.getLine(), gl.getColumn());
            this.actionClick(c, clickPoint.x, clickPoint.y);
        } else {
            super.actionClick(c, loc);
        }
    }

    public void actionSelectPopupMenuItem(Component c, int line, String path) {
        this.actionSelectPopupMenuItem(c, new GutterLocation(line, null), path);
    }

    public void actionSelectPopupMenuItem(Component c, int line, String column, String path) {
        this.actionSelectPopupMenuItem(c, new GutterLocation(line, column), path);
    }

    public void actionSelectPopupMenuItem(final Component c, ComponentLocation loc, final String path) {
        if (loc instanceof GutterLocation) {
            GutterLocation gl = (GutterLocation)loc;
            LineGutterPlugin lgp = (LineGutterPlugin)c;
            BasicEditorPane bep = lgp.getEditor();
            final Point clickPoint = LineGutterPluginTester.convertLocationToPoint(lgp, bep, gl.getLine(), gl.getColumn());
            LineGutterPluginTester.wait((Condition)new abbot.script.Condition(){

                public boolean test() {
                    try {
                        JPopupMenu popup = AWT.findActivePopupMenu();
                        if (popup != null) {
                            popup.setVisible(false);
                            LineGutterPluginTester.this.waitForIdle();
                        }
                        LineGutterPluginTester.this.actionSelectPopupMenuItem(c, clickPoint.x, clickPoint.y, path);
                        return true;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }

                public String toString() {
                    return "Looking for menu path";
                }
            }, (long)10000L, (int)250);
        } else {
            super.actionSelectPopupMenuItem(c, loc, path);
        }
    }

    public void assertMark(Component c, int line) {
        this.assertMark(c, line, null);
    }

    public boolean assertMark(Component c, int line, String column) {
        LineGutterPlugin lgp = (LineGutterPlugin)c;
        ArrayList marks = new ArrayList();
        marks.clear();
        lgp.getMarksOnLine(marks, line);
        boolean found = false;
        for (GutterMark mark : marks) {
            if (!column.equals(mark.getGutterColumn().getColumnName())) continue;
            found = true;
        }
        return found;
    }

    public ComponentLocation parseLocation(String encoded) {
        return new GutterLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point where) {
        int line;
        LineGutterPlugin lgp = (LineGutterPlugin)c;
        String column = null;
        GutterMark mark = lgp.getMarkAtLocation(where.x, where.y);
        if (mark != null) {
            line = mark.getLine();
            column = mark.getGutterColumn().getColumnName();
        } else {
            BasicEditorPane bep = lgp.getEditor();
            int position = bep.viewToModel(new Point(0, where.y));
            line = bep.getLineFromOffset(position);
        }
        return new GutterLocation(line, column);
    }

    private static Point convertLocationToPoint(LineGutterPlugin lgp, final BasicEditorPane bep, int line, String column) {
        Point clickPoint = new Point();
        if (column != null) {
            Rectangle rolloverRect = null;
            ArrayList marks = new ArrayList();
            lgp.getMarksOnLine(marks, line);
            for (GutterMark mark : marks) {
                if (!column.equals(mark.getGutterColumn().getColumnName())) continue;
                rolloverRect = lgp.getRolloverRectFor(mark);
                break;
            }
            if (rolloverRect == null) {
                throw new ActionFailedException("Cannot find column " + column + " on line " + line);
            }
            clickPoint.setLocation(rolloverRect.x + rolloverRect.width / 2, rolloverRect.y + rolloverRect.height / 2);
        } else {
            Point offsetPoint;
            final int offset = bep.getLineStartOffset(line);
            try {
                Rectangle modelToView = (Rectangle)LineGutterPluginTester.callAndWait((Component)bep, (Callable)new Callable<Rectangle>(){

                    @Override
                    public Rectangle call() throws Exception {
                        return bep.modelToView(offset);
                    }
                });
                if (modelToView == null) {
                    throw new BadLocationException("Cannot convert to view", offset);
                }
                offsetPoint = modelToView.getLocation();
            }
            catch (BadLocationException e) {
                ActionFailedException afe = new ActionFailedException("Line " + line + " is bad");
                afe.initCause((Throwable)e);
                throw afe;
            }
            clickPoint.setLocation(offsetPoint.x + 3, offsetPoint.y - 5);
        }
        return clickPoint;
    }
}

