/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester.extensions;

import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.extensions.TabDisplayerLocation;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;

public class TabDisplayerTester
extends JComponentTester {
    public void actionClick(Component c, ComponentLocation loc) {
        if (loc instanceof TabDisplayerLocation) {
            TabDisplayer ct = (TabDisplayer)c;
            String tab = ((TabDisplayerLocation)loc).getTab();
            int found = -1;
            TabDataModel dataModel = ct.getModel();
            int i = dataModel.size();
            for (int j = 0; j < i; ++j) {
                TabData ctp = dataModel.getTab(j);
                String label = ctp.getText();
                if (!tab.equals(label) && !ExtendedComparator.stringsMatch((String)tab, (String)label)) continue;
                found = j;
                break;
            }
            if (found == -1) {
                throw new IllegalStateException("Page not found");
            }
            Rectangle bounds = ct.getTabRect(found, new Rectangle());
            this.actionClick(c, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        } else {
            super.actionClick(c, loc);
        }
    }

    public ComponentLocation getLocation(Component c, Point where) {
        TabDisplayer ct = (TabDisplayer)c;
        Rectangle bounds = new Rectangle();
        TabDataModel model = ct.getModel();
        int index = -1;
        int i = model.size();
        for (int tab = 0; tab < i && index == -1; ++tab) {
            ct.getTabRect(tab, bounds);
            if (!bounds.contains(where)) continue;
            index = tab;
            break;
        }
        if (index != -1) {
            TabData tab = model.getTab(index);
            String label = tab.getText();
            return new TabDisplayerLocation(label);
        }
        return super.getLocation(c, where);
    }

    public ComponentLocation parseLocation(String encoded) {
        if (encoded.startsWith("(")) {
            return super.parseLocation(encoded);
        }
        return new TabDisplayerLocation(encoded);
    }
}

