/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.editor.FileSystemHelper;
import abbot.tester.Robot;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import javax.ide.extension.Extension;
import oracle.abbot.AbbotRunner;
import oracle.abbot.AbbotTestSuite;
import oracle.abbot.AbbotUncaughtExceptionHandler;
import oracle.abbot.TestFinder;
import oracle.abbot.TestHelper;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ChainingUncaughtExceptionHandler;
import oracle.ide.util.JDevUncaughtExceptionHandler;

public class AbbotAddin
implements Addin {
    public static final String AUTOMATION_MENU = "oracle.abbot.automation";
    public static final String LAST_ZIP_FILE = "Abbot.lastZipFile";
    public static final String LAST_ZIP_FILE_REMOTE = "Abbot.lastZipFileRemote";
    public static final String SELECTED_EXTENSION = "Abbot.selectedExtension";
    public static final String SELECTED_LEVEL = "Abbot.selectedLevel";
    public static final String SCRIPT_FILTER = "Abbot.scriptFilter";
    public static final String LAST_SELECTED_SCRIPT = "Abbot.lastSelectedScript";
    public static final String SCRIPT_REPEAT = "Abbot.scriptRepeat";
    public static final String DIALOG_RUN_SCRIPT = "Abbot.runScript";
    public static final String DISABLE_AWT_LOCK = "oracle.awt-lock-check-disabled";
    public static FileSystemHelper HELPER;

    public static Preferences getPreferences() {
        return Preferences.userNodeForPackage(AbbotAddin.class);
    }

    public void initialize() {
        System.getProperties().setProperty("abbot.script.validate", "false");
        System.getProperties().setProperty("abbot.editor.app_already_running", "true");
        System.setProperty("abbot.keystroke_map_generator", "oracle.abbot.JDevKeyStrokeMapProvider");
        System.setProperty("oracle.bali.xml.treeCellRenderer.disableTruncate", "true");
        System.setProperty("oracle.ide.model.Project.synchronousFeatureSearch", "true");
        System.setProperty("oracle.ide.net.URLChooser.suppressProgressDialog", "true");
        System.setProperty("oracle.ide.extension.logging.defaultThreshold", "SEVERE");
        System.setProperty("abbot.no_security_manager", "true");
        System.setProperty("abbot.robot.popup_retry", "5");
        String ABBOT_ROBOT_AUTO_DELAY = "abbot.robot.auto_delay";
        String autoDelay = System.getProperty("abbot.robot.auto_delay", "70");
        System.setProperty("abbot.robot.auto_delay", autoDelay);
        ChainingUncaughtExceptionHandler.registerHandler((JDevUncaughtExceptionHandler)new JDevUncaughtExceptionHandler(){

            public boolean uncaughtException(Thread t, Throwable e) {
                String name = e.getClass().getName();
                return name.endsWith("DummyException") && name.startsWith("abbot");
            }
        }, (int)-1);
        ChainingUncaughtExceptionHandler.registerHandler((JDevUncaughtExceptionHandler)new AbbotUncaughtExceptionHandler(), (int)0);
        System.setProperty("abbot.assert.default_timeout", Long.toString(TimeUnit.SECONDS.toMillis(30L)));
        System.setProperty("abbot.assert.default_interval", "500");
        String configFile = System.getProperty("oracle.abbot.config");
        if (configFile != null) {
            Ide.addIdeListener((IdeListener)new IdeListener(){

                public void addinsLoaded(IdeEvent e) {
                }

                public void mainWindowOpened(IdeEvent e) {
                    AbbotAddin.runTests(false);
                }

                public void mainWindowClosing(IdeEvent e) {
                }
            });
        }
        try {
            final ServerSocket ss = new ServerSocket(0);
            new Thread("LockBreakerSocket " + ss.getLocalPort()){

                @Override
                public void run() {
                    try {
                        do {
                            Socket s;
                            if ((s = ss.accept()) == null) continue;
                            OutputStream os = s.getOutputStream();
                            PrintWriter pw = new PrintWriter(os);
                            pw.println("Attemping to break all locks");
                            pw.flush();
                            TestHelper.breakLocks(pw);
                            pw.flush();
                            os.close();
                        } while (!ss.isClosed());
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }.start();
        }
        catch (IOException ieo) {
            ieo.printStackTrace();
        }
    }

    public static void runTests(boolean holdOff) {
        if (holdOff) {
            Thread waitForIDEToSettle = new Thread(new Runnable(){

                @Override
                public void run() {
                    Extension abbot;
                    long difference;
                    AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());
                    long thirtySeconds = TimeUnit.SECONDS.toMillis(30L);
                    do {
                        try {
                            TimeUnit.SECONDS.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while ((difference = System.currentTimeMillis() - lastTime.get()) < thirtySeconds);
                    ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                    if (!er.isFullyLoaded(abbot = er.findExtension("oracle.abbot"))) {
                        System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                        System.err.println("     Loading oracle.abbot extension      ");
                        System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                        er.fullyLoadExtension(abbot);
                    }
                    Robot.getRobot().waitForIdle();
                    AbbotAddin.runTestsIntl();
                }
            }, "Wait for IDE idle thread");
            waitForIDEToSettle.start();
        } else {
            Extension abbot;
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            if (!er.isFullyLoaded(abbot = er.findExtension("oracle.abbot"))) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.err.println("     Loading oracle.abbot extension      ");
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                er.fullyLoadExtension(abbot);
            }
            AbbotAddin.runTestsIntl();
        }
    }

    private static void runTestsIntl() {
        String configFile = System.getProperty("oracle.abbot.config");
        Properties props = new Properties();
        try {
            String[] extensionIds;
            if (!new File(configFile).exists()) {
                System.err.println(" ERROR: abbot config file '" + configFile + "' doesn't exist!");
                Ide.quit();
            }
            props.load(new FileInputStream(configFile));
            String extensions = props.getProperty("oracle.abbot.extensions", "").trim();
            String levelsProperty = props.getProperty("oracle.abbot.levels", "").trim();
            String testsProperty = props.getProperty("oracle.abbot.tests", "").trim();
            int repeat = Integer.parseInt(props.getProperty("oracle.abbot.repeat", "1").trim());
            if (props.getProperty("oracle.abbot.profiler") != null) {
                System.setProperty("oracle.abbot.profiler", props.getProperty("oracle.abbot.profiler"));
            }
            String name = props.getProperty("oracle.abbot.name", extensions + " [" + levelsProperty + "]");
            IdeAbbotRunner runner = new IdeAbbotRunner(name);
            String resultsDir = props.getProperty("oracle.abbot.results.dir");
            if (resultsDir == null) {
                System.err.println("\nERROR: oracle.abbot.results.dir must be defined in " + configFile + "\n");
                Ide.quit();
            }
            if (!URLFileSystem.canCreate((URL)URLFactory.newDirURL((String)resultsDir))) {
                System.err.println("\nERROR: oracle.abbot.results.dir is not writable. Use another location.\n");
                Ide.quit();
            }
            runner.setResultsDir(URLFactory.newDirURL((String)resultsDir));
            TestFinder testFinder = new TestFinder();
            testFinder.setTestFilter(testsProperty);
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            for (String extensionId : extensionIds = extensions.split(",")) {
                if ("*".equals(extensionId = extensionId.trim())) {
                    testFinder.addExtensions(registry.getExtensions());
                    continue;
                }
                Extension extension = registry.findExtension(extensionId);
                if (extension == null) {
                    AbbotAddin.writeOutFailedTestResults(runner.getResultsDir(), extensionId, "LoadFailure.xml", null);
                    System.err.println("Extension " + extensionId + " is not available");
                    continue;
                }
                testFinder.addExtensions(extension);
            }
            String[] levels = levelsProperty.split(",");
            for (int i = 0; i < repeat; ++i) {
                runner.addSuites(AbbotTestSuite.setRepetition(i, testFinder.getSuites(levels)));
            }
            runner.start();
        }
        catch (Exception ioe) {
            FeedbackManager.reportException((String)"Exception setting up tests", (Throwable)ioe);
            Ide.quit();
        }
    }

    static void writeOutFailedTestResults(URL resultsDir, String extension, String template, String filename) {
        AbbotAddin.writeOutFailedTestResults(resultsDir, extension, template, filename, null);
    }

    static void writeOutFailedTestResults(URL resultsDir, String extension, String template, String filename, Throwable th) {
        try {
            String readLine;
            if (filename == null) {
                filename = template;
            }
            String exceptionText = "";
            if (th != null) {
                StringWriter sw = new StringWriter();
                th.printStackTrace(new PrintWriter(sw));
                exceptionText = sw.toString();
                exceptionText = exceptionText.replace("<", "&lt;");
            }
            PrintWriter writer = new PrintWriter(URLFileSystem.openOutputStream((URL)URLFactory.newURL((URL)resultsDir, (String)("ABBOT-" + extension + "." + filename))));
            BufferedReader reader = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)AbbotAddin.class.getResource(template))));
            String name = extension;
            while ((readLine = reader.readLine()) != null) {
                String suiteReplaced = readLine.replace("@@suite@@", name);
                String exceptionReplaced = suiteReplaced.replace("@@exception@@", exceptionText);
                writer.println(exceptionReplaced);
            }
            writer.close();
            reader.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class IdeAbbotRunner
    extends AbbotRunner {
        IdeAbbotRunner(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block20: {
                boolean ignoreExit = false;
                super.run();
                URL resultsDir = this.getResultsDir();
                String testName = this.m_name + ".quit";
                URL attachments = URLFactory.newDirURL((URL)resultsDir, (String)testName);
                URLFileSystem.mkdirs((URL)attachments);
                AbbotAddin.writeOutFailedTestResults(resultsDir, testName, "QuitFailure.xml", "Quit.xml");
                if (ignoreExit) {
                    return;
                }
                Timer killTimer = new Timer(true);
                killTimer.schedule(new TimerTask(this, testName, attachments){
                    final /* synthetic */ String val$testName;
                    final /* synthetic */ URL val$attachments;
                    final /* synthetic */ IdeAbbotRunner this$0;
                    {
                        this.this$0 = this$0;
                        this.val$testName = string;
                        this.val$attachments = uRL;
                    }

                    @Override
                    public void run() {
                        URL resultsDir = this.this$0.getResultsDir();
                        System.err.println("Ide.quit() failed");
                        if (resultsDir != null) {
                            AbbotAddin.writeOutFailedTestResults(resultsDir, this.val$testName, "QuitFailure.xml", "Quit.xml");
                            try {
                                TestHelper.captureScreenshot(URLFileSystem.openOutputStream((URL)URLFactory.newURL((URL)this.val$attachments, (String)"Quit-Failed.png")));
                                TestHelper.dumpStackTrace(new PrintStream(URLFileSystem.openOutputStream((URL)URLFactory.newURL((URL)this.val$attachments, (String)"stacks.txt"))));
                                this.this$0.dumpDirtyFiles(this.val$attachments, "dirtyAfterFailedClose.txt");
                            }
                            catch (Exception ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        try {
                            SecurityManager sm = System.getSecurityManager();
                            sm.getClass().getDeclaredMethod("exit", Integer.TYPE).invoke((Object)sm, 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, 20000L);
                try {
                    this.dumpDirtyFiles(attachments, "dirtyFiles.txt");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                for (int i = 0; i < 2; ++i) {
                    Iterator it = NodeFactory.getOpenNodes();
                    while (it.hasNext()) {
                        try {
                            ((Node)it.next()).markDirty(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                try {
                    EventQueue.invokeAndWait(new Runnable(this, testName){
                        final /* synthetic */ String val$testName;
                        final /* synthetic */ IdeAbbotRunner this$0;
                        {
                            this.this$0 = this$0;
                            this.val$testName = string;
                        }

                        @Override
                        public void run() {
                            AbbotAddin.writeOutFailedTestResults(this.this$0.getResultsDir(), this.val$testName, "QuitSuccess.xml", "Quit.xml");
                            Ide.quit();
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break block20;
                catch (Throwable throwable) {
                    URL resultsDir2 = this.getResultsDir();
                    String testName2 = this.m_name + ".quit";
                    URL attachments2 = URLFactory.newDirURL((URL)resultsDir2, (String)testName2);
                    URLFileSystem.mkdirs((URL)attachments2);
                    AbbotAddin.writeOutFailedTestResults(resultsDir2, testName2, "QuitFailure.xml", "Quit.xml");
                    if (ignoreExit) {
                        return;
                    }
                    Timer killTimer2 = new Timer(true);
                    killTimer2.schedule(new /* invalid duplicate definition of identical inner class */, 20000L);
                    try {
                        this.dumpDirtyFiles(attachments2, "dirtyFiles.txt");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    for (int i = 0; i < 2; ++i) {
                        Iterator it = NodeFactory.getOpenNodes();
                        while (it.hasNext()) {
                            try {
                                ((Node)it.next()).markDirty(false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    try {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpDirtyFiles(URL attachments, String filename) throws Exception {
            try (PrintStream ps = new PrintStream(URLFileSystem.openOutputStream((URL)URLFactory.newURL((URL)attachments, (String)filename)));){
                Iterator it = NodeFactory.getOpenNodes();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    if (!next.isDirty()) continue;
                    ps.println(URLFileSystem.getPlatformPathName((URL)next.getURL()));
                }
            }
        }
    }
}

