/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.editor.Costello;
import abbot.editor.EditorContext;
import abbot.editor.ScriptEditorFrame;
import abbot.finder.TestHierarchy;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.ide.extension.Extension;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.abbot.AbbotAddin;
import oracle.abbot.AbbotDialog;
import oracle.abbot.GalleryFixture;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.abbot.TestHelper;
import oracle.abbot.util.Migrator;
import oracle.abbot.util.Unzipper;
import oracle.abbot.util.Zipper;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.log.LogManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.icons.OracleIcons;

public class AbbotController
implements Controller {
    static final String AbbotCommand = "oracle.abbot.AbbotCommand";
    static final String CostelloCommand = "oracle.abbot.CostelloCommand";
    static final String CleanUpCommand = "oracle.abbot.CleanUpCommand";
    static final String CleanUpFileCommand = "oracle.abbot.CleanUpFileCommand";
    static final String CleanUpFileMigrateCommand = "oracle.abbot.CleanUpFileMigrateCommand";
    static final String CleanUpUrlMigrateCommand = "oracle.abbot.CleanUpUrlMigrateCommand";
    static final String CreateZipCommand = "oracle.abbot.CreateZipCommand";
    static final String MigrateAndZip = "oracle.abbot.MigrateAndZipCommand";

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdid = action.getCommandId();
        if (cmdid == Ide.findOrCreateCmdID((String)AbbotCommand)) {
            AbbotDialog.runDialog((Component)Ide.getMainWindow());
        } else if (cmdid == Ide.findOrCreateCmdID((String)CostelloCommand)) {
            final String fixName = System.getProperty("oracle.abbot.modalityFix", "breakCostelloModality");
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            ThreadGroup otherApplication = new ThreadGroup(tg, "CostelloApp");
            EventQueue oldQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
            new Thread(otherApplication, "Costello Thread"){

                @Override
                public void run() {
                    try {
                        System.setProperty("oracle.awt-lock-check-disabled", Boolean.TRUE.toString());
                        new GalleryFixture().setUp(new JDevScriptFixtureContext(null, null, null, null));
                        Class.forName("abbot.editor.Costello", true, this.getClass().getClassLoader());
                        EditorContext ec = new EditorContext(){

                            public File getNewFileTemplate() {
                                File file = super.getNewFileTemplate();
                                try {
                                    File tempLocation = File.createTempFile("Script", ".xml");
                                    URLFileSystem.copy((URL)URLFactory.newFileURL((File)file), (URL)URLFactory.newFileURL((File)tempLocation));
                                    file = tempLocation;
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                }
                                return file;
                            }
                        };
                        ec.setEmbedded(true);
                        TestHierarchy th = new TestHierarchy();
                        ec.setTestHierarchy(th);
                        if (AbbotAddin.HELPER != null) {
                            ec.setFileSysteHelper(AbbotAddin.HELPER);
                        }
                        ExtensionRegistry em = ExtensionRegistry.getExtensionRegistry();
                        Extension e = em.findExtension("oracle.abbot");
                        File abbotDir = em.getInstallDirectory(e);
                        ec.setNewFileTemplate(new File(abbotDir, "templates/NewScript.xml"));
                        System.setProperty("abbot.no_security_manager", "true");
                        Costello.showCostello((EditorContext)ec);
                        th.setFiltered((Component)Ide.getMainWindow(), false);
                        if ("breakCostelloModality".equals(fixName)) {
                            for (Frame next : Frame.getFrames()) {
                                if (!(next instanceof ScriptEditorFrame)) continue;
                                next.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                            }
                        } else if ("tryToModifyDialogBeforeShow".equals(fixName)) {
                            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
                                WeakHashMap map = new WeakHashMap();

                                @Override
                                public void eventDispatched(AWTEvent event) {
                                    Object source = event.getSource();
                                    if (source instanceof Dialog && !this.map.containsKey(source)) {
                                        Dialog d;
                                        this.map.put(source, this);
                                        Container ancestorOfClass = SwingUtilities.getAncestorOfClass(MainWindow.class, (Component)source);
                                        if (ancestorOfClass != null && (d = (Dialog)source).getModalityType() == Dialog.ModalityType.APPLICATION_MODAL) {
                                            d.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                                        }
                                    }
                                }
                            }, 2L);
                        }
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException((String)"Error starting up costello", (Throwable)e);
                    }
                }
            }.start();
        } else if (cmdid == Ide.findOrCreateCmdID((String)CleanUpCommand)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TestHelper.runUnfilteredFixtures();
                }
            }).start();
        } else if (cmdid == Ide.findOrCreateCmdID((String)CleanUpFileCommand) || cmdid == Ide.findOrCreateCmdID((String)CleanUpFileMigrateCommand)) {
            Preferences cache = AbbotAddin.getPreferences();
            URLChooser chooser = this.createZipChooser(cache);
            if (chooser.showOpenDialog((Component)Ide.getMainWindow(), "Pick workspace zip to refresh from") == 0) {
                String name = URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL());
                cache.put("Abbot.lastZipFile", name);
                try {
                    cache.flush();
                }
                catch (BackingStoreException f) {
                    f.printStackTrace();
                }
                new Thread((Runnable)new Unzipper(URLFactory.newFileURL((String)name), cmdid == Ide.findOrCreateCmdID((String)CleanUpFileMigrateCommand)), "Unzip Thread").start();
            }
        } else if (cmdid == Ide.findOrCreateCmdID((String)CleanUpUrlMigrateCommand)) {
            Preferences cache = AbbotAddin.getPreferences();
            String lastFile = cache.get("Abbot.lastZipFileRemote", null);
            String newURL = null;
            newURL = JOptionPane.showInputDialog((Component)Ide.getMainWindow(), "Enter URL to unzip", lastFile);
            if (newURL != null) {
                cache.put("Abbot.lastZipFileRemote", newURL);
                try {
                    cache.flush();
                }
                catch (BackingStoreException f) {
                    f.printStackTrace();
                }
                new Thread((Runnable)new Unzipper(URLFactory.newURL((String)newURL), true), "Unzip Thread").start();
            }
        } else if (cmdid == Ide.findOrCreateCmdID((String)CreateZipCommand)) {
            Preferences cache = AbbotAddin.getPreferences();
            URLChooser chooser = this.createZipChooser(cache);
            if (chooser.showSaveDialog((Component)Ide.getMainWindow(), "Pick zip location to write working dir to") == 0) {
                String name = URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL());
                cache.put("Abbot.lastZipFile", name);
                try {
                    cache.flush();
                }
                catch (BackingStoreException f) {
                    f.printStackTrace();
                }
                new Thread((Runnable)new Zipper(URLFactory.newFileURL((String)name)), "Zip Thread").start();
            }
        } else if (cmdid == Ide.findOrCreateCmdID((String)MigrateAndZip)) {
            Preferences cache = AbbotAddin.getPreferences();
            URLChooser chooser = this.createZipChooser(cache);
            chooser.setSelectionMode(2);
            chooser.setSelectionScope(2);
            if (chooser.showOpenDialog((Component)Ide.getMainWindow(), "Pick zips, or containing folder, to try to migrate") == 0) {
                List<URL> selected = Arrays.asList(chooser.getSelectedURLs());
                ArrayList<URL> toProcess = new ArrayList<URL>(selected.size());
                for (URL next : selected) {
                    if (URLFileSystem.isDirectory((URL)next)) {
                        this.findZips(next, toProcess);
                        continue;
                    }
                    toProcess.add(next);
                }
                String name = URLFileSystem.getPlatformPathName((URL)selected.get(0));
                cache.put("Abbot.lastZipFile", name);
                if (toProcess.size() == 0) {
                    LogManager.getLogManager().getMsgPage().log((Object)"No zips found to migrate");
                    return true;
                }
                new Thread((Runnable)new Migrator(toProcess.toArray(new URL[0])), "Migrator Thread").start();
            }
        }
        return true;
    }

    private URLChooser createZipChooser(Preferences cache) {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.addShortcutButton(OracleIcons.getIcon((String)"home.png"), "Oracle Home", URLFactory.newDirURL((String)Ide.getOracleHomeDirectory()));
        chooser.addShortcutButton(OracleIcons.getIcon((String)"home.png"), "Extensions", URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getProductHomeDirectory()), (String)"extensions"));
        chooser.setShowJarsAsDirs(false);
        String lastFile = cache.get("Abbot.lastZipFile", null);
        if (lastFile != null) {
            URL url = URLFactory.newFileURL((String)lastFile);
            chooser.setSelectedURL(url);
        } else {
            chooser.setSelectedURL(URLFileSystem.getParent((URL)URLFactory.newDirURL((String)Ide.getBinDirectory())));
        }
        chooser.setURLFilter((URLFilter)new DefaultURLFilter("Zip/Jar files", new String[]{".zip", ".jar"}));
        return chooser;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    private void findZips(URL url, List<URL> resultList) {
        if (URLFileSystem.isDirectory((URL)url)) {
            for (URL next : URLFileSystem.list((URL)url, (URLFilter)new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.isDirectory((URL)url) && !".ade_path".equals(URLFileSystem.getName((URL)url)) || ".zip".equals(URLFileSystem.getSuffix((URL)url));
                }
            })) {
                this.findZips(next, resultList);
            }
        } else {
            resultList.add(url);
        }
    }
}

