/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.ide.extension.Extension;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import oracle.abbot.AbbotAddin;
import oracle.abbot.AbbotRunner;
import oracle.abbot.AbbotTestSuite;
import oracle.abbot.TestFinder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.columnlayout.LayoutBuilder;

class AbbotDialog {
    private JEWTDialog m_dialog;
    private JList m_extensionsList;
    private JComboBox m_levels;
    private JTextField m_filter;
    private JTextField m_scriptField;
    private JSpinner m_repeats;
    private boolean m_useExtensions;
    private JRadioButton m_scriptButton;
    private JRadioButton m_extensionButton;

    public AbbotDialog(Component parent) {
        TestFinder testFinder = new TestFinder();
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        testFinder.addExtensions(registry.getExtensions());
        Collection<TestFinder.ExtensionTest> extTests = testFinder.getExtensionTests();
        ArrayList<Extension> extensions = new ArrayList<Extension>(extTests.size());
        for (TestFinder.ExtensionTest extTest : extTests) {
            extensions.add(extTest.getExtension());
        }
        this.m_extensionButton = new JRadioButton("Extensions");
        Collections.sort(extensions, new Comparator<Extension>(){

            @Override
            public int compare(Extension o1, Extension o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        this.m_extensionsList = new JList<Extension>(extensions.toArray(new Extension[extensions.size()]));
        this.m_extensionsList.setSelectionMode(2);
        this.m_extensionsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((Extension)value).getID(), index, isSelected, cellHasFocus);
            }
        });
        final JScrollPane extensionsPane = new JScrollPane(this.m_extensionsList);
        JLabel levelsLabel = new JLabel("Level:");
        this.m_levels = new JComboBox<String>(new String[]{"all", "level0", "level1", "level2", "level3", "acceptance", "mats", "srg", "lrg"});
        levelsLabel.setLabelFor(this.m_levels);
        JLabel filterLable = new JLabel("Filter Scripts");
        this.m_filter = new JTextField();
        filterLable.setLabelFor(this.m_filter);
        this.m_scriptButton = new JRadioButton("Script");
        this.m_scriptField = new JTextField();
        final JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = URLFactory.newFileURL((String)AbbotDialog.this.m_scriptField.getText());
                url = url == null ? URLFactory.newFileURL((String)Ide.getOracleHomeDirectory()) : URLFileSystem.getParent((URL)url);
                URLChooser urlChooser = DialogUtil.newURLChooser((URL)url);
                urlChooser.setURLFilter((URLFilter)new DefaultURLFilter("XML Files", new String[]{".xml"}));
                urlChooser.setSelectionScope(0);
                urlChooser.setSelectionMode(0);
                urlChooser.setShowJarsAsDirs(false);
                if (urlChooser.showOpenDialog((Component)browseButton) == 0) {
                    AbbotDialog.this.m_scriptField.setText(URLFileSystem.getPlatformPathName((URL)urlChooser.getSelectedURL()));
                }
            }
        });
        JLabel repeatLabel = new JLabel("Repeat tests");
        this.m_repeats = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.m_repeats.setToolTipText("Number of repeats");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_extensionButton);
        bg.add(this.m_scriptButton);
        this.m_extensionButton.setSelected(true);
        ActionListener enabler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbbotDialog.this.m_useExtensions = AbbotDialog.this.m_extensionButton.isSelected();
                AbbotDialog.this.m_extensionsList.setEnabled(AbbotDialog.this.m_useExtensions);
                AbbotDialog.this.m_levels.setEnabled(AbbotDialog.this.m_useExtensions);
                AbbotDialog.this.m_filter.setEnabled(AbbotDialog.this.m_useExtensions);
                extensionsPane.setEnabled(AbbotDialog.this.m_useExtensions);
                AbbotDialog.this.m_scriptField.setEnabled(!AbbotDialog.this.m_useExtensions);
                browseButton.setEnabled(!AbbotDialog.this.m_useExtensions);
            }
        };
        this.m_extensionButton.addActionListener(enabler);
        this.m_scriptButton.addActionListener(enabler);
        enabler.actionPerformed(null);
        LayoutBuilder lb = new LayoutBuilder();
        lb.add((Component)this.m_extensionButton, LayoutBuilder.LABEL_INSETS, 5, false, true);
        lb.nl();
        lb.addHGap();
        lb.pushPanel();
        lb.add((Component)extensionsPane, LayoutBuilder.CONTROL_INSETS, 4, true, true);
        lb.nl();
        lb.add((Component)levelsLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
        lb.add((Component)this.m_levels, LayoutBuilder.CONTROL_INSETS, 1, false, false);
        lb.addHFiller();
        lb.nl();
        lb.add((Component)filterLable, LayoutBuilder.LABEL_INSETS, 1, false, false);
        lb.add((Component)this.m_filter, LayoutBuilder.CONTROL_INSETS, 3, false, true);
        lb.popPanel();
        lb.nl();
        lb.add((Component)this.m_scriptButton, LayoutBuilder.LABEL_INSETS, 5, false, true);
        lb.nl();
        lb.addHGap();
        lb.add((Component)this.m_scriptField, LayoutBuilder.CONTROL_INSETS, 3, false, true);
        lb.add((Component)browseButton, LayoutBuilder.CONTROL_INSETS, 1, false, false);
        lb.nl();
        lb.addVGap(10);
        lb.nl();
        lb.add((Component)repeatLabel, LayoutBuilder.LABEL_INSETS, 1, false, false);
        lb.add((Component)this.m_repeats, LayoutBuilder.CONTROL_INSETS, 4, false, true);
        lb.nl();
        JPanel panel = new JPanel();
        panel.setName("AbbotDialog");
        lb.addToPanel((Container)panel);
        this.m_dialog = JEWTDialog.createDialog((Component)parent, (String)"Abbot", (int)7);
        this.m_dialog.setName("AbbotDialog");
        this.m_dialog.setContent((Component)panel);
        this.m_dialog.setResizable(true);
        this.m_dialog.setPreferredSize(new Dimension(450, 600));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void show() {
        block11: {
            try {
                AbbotRunner runner;
                this.restoreState();
                if (!this.m_dialog.runDialog()) break block11;
                this.storeState();
                TestFinder testFinder = new TestFinder();
                if (this.m_useExtensions) {
                    Object[] selection;
                    StringBuilder sb = new StringBuilder();
                    for (Object extension : selection = this.m_extensionsList.getSelectedValues()) {
                        Extension ext = (Extension)extension;
                        testFinder.addExtensions(ext);
                        sb.append(ext.getID());
                        sb.append(',');
                    }
                    String level = (String)this.m_levels.getSelectedItem();
                    runner = new AbbotRunner(sb.append(" [" + level + "]").toString());
                    String filter = this.m_filter.getText();
                    if (filter != null && filter.length() > 0) {
                        testFinder.setTestFilter(filter);
                    }
                    int number = (Integer)this.m_repeats.getValue();
                    for (int i = 0; i < number; ++i) {
                        runner.addSuites(AbbotTestSuite.setRepetition(i, testFinder.getSuites(level)));
                    }
                } else {
                    URL url = URLFactory.newFileURL((String)this.m_scriptField.getText());
                    String name = URLFileSystem.getName((URL)url);
                    String filename = URLFileSystem.getFileName((URL)url);
                    runner = new AbbotRunner(name);
                    try {
                        AbbotTestSuite suite = new AbbotTestSuite("abbot.script", name);
                        int number = (Integer)this.m_repeats.getValue();
                        for (int i = 0; i < number; ++i) {
                            suite.addTest(i == 0 ? name : name + i, new File(url.toURI()));
                        }
                        runner.addSuites(suite);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                runner.setCollateResults(true);
                runner.start();
            }
            finally {
                this.m_dialog.dispose();
            }
        }
    }

    protected void storeState() {
        String filter;
        Preferences cache = AbbotAddin.getPreferences();
        if (!this.m_extensionsList.isSelectionEmpty()) {
            StringBuffer sb = new StringBuffer();
            Object[] selected = this.m_extensionsList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                sb.append(((Extension)selected[i]).getID());
                if (i >= selected.length - 1) continue;
                sb.append(',');
            }
            cache.put("Abbot.selectedExtension", sb.toString());
        }
        if (this.m_levels.getSelectedItem() != null) {
            cache.put("Abbot.selectedLevel", (String)this.m_levels.getSelectedItem());
        }
        if ((filter = this.m_filter.getText()) != null && filter.length() > 0) {
            cache.put("Abbot.scriptFilter", filter);
        } else {
            cache.remove("Abbot.scriptFilter");
        }
        if (this.m_scriptField.getText() != null) {
            cache.put("Abbot.lastSelectedScript", this.m_scriptField.getText());
        }
        cache.putBoolean("Abbot.runScript", this.m_scriptButton.isSelected());
        try {
            cache.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected void restoreState() {
        String scriptLocation;
        String filter;
        String selectedLevel;
        Preferences cache = AbbotAddin.getPreferences();
        String selectedExtensions = cache.get("Abbot.selectedExtension", null);
        if (selectedExtensions != null) {
            List<String> selectedExtensionList = Arrays.asList(selectedExtensions.split(","));
            ListModel lm = this.m_extensionsList.getModel();
            this.m_extensionsList.clearSelection();
            for (int extension = 0; extension < lm.getSize(); ++extension) {
                if (!selectedExtensionList.contains(((Extension)lm.getElementAt(extension)).getID())) continue;
                this.m_extensionsList.addSelectionInterval(extension, extension);
            }
        }
        if ((selectedLevel = cache.get("Abbot.selectedLevel", null)) != null) {
            this.m_levels.setSelectedItem(selectedLevel);
        }
        if ((filter = cache.get("Abbot.scriptFilter", null)) != null) {
            this.m_filter.setText(filter);
        }
        if ((scriptLocation = cache.get("Abbot.lastSelectedScript", null)) != null) {
            this.m_scriptField.setText(scriptLocation);
        }
        if (cache.getBoolean("Abbot.runScript", false)) {
            this.m_scriptButton.doClick();
        }
    }

    public static void runDialog(Component parent) {
        AbbotDialog dialog = new AbbotDialog(parent);
        dialog.show();
    }
}

