/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.javatools.util.Pair;

public class AbbotFeedbackManager
extends FeedbackManager {
    private boolean RECORD_FEEDBACK = !"true".equals(System.getProperty("oracle.abbot.ignorefeedback"));
    private boolean IGNORE_SYNC = !"false".equals(System.getProperty("oracle.abbot.ignoresync"));
    private List<Pair<String, Throwable>> m_throwables = new ArrayList<Pair<String, Throwable>>(20);

    protected void addFeedbackImpl(Feedback feedback) {
        if (feedback != null) {
            feedback.dump(System.out);
        }
    }

    protected void reportExceptionImpl(String message, Throwable exception, boolean printToConsole) {
        if (this.ignore(exception)) {
            return;
        }
        this.addThrowable(message, exception);
    }

    protected void reportExceptionImpl(String message, Throwable exception, int apiDepth, boolean printToConsole) {
        if (this.ignore(exception)) {
            return;
        }
        this.addThrowable(message, exception);
    }

    protected void reportApiExceptionImpl(String message, Throwable exception, String apiName, boolean printToConsole) {
        if (this.ignore(exception)) {
            return;
        }
        this.addThrowable(message + " on api " + apiName, exception);
    }

    protected void reportExceptionImpl(String message, Throwable exception, int apiDepth, boolean printToConsole, String dialogHeader) {
        this.reportExceptionImpl(message, exception, apiDepth, printToConsole);
    }

    private boolean ignore(Throwable exception) {
        if (!this.RECORD_FEEDBACK) {
            return true;
        }
        if (exception != null) {
            String exceptionClassName = exception.getClass().getName();
            if ("abbot.util.EventDispatchExceptionHandler$DummyException".equals(exceptionClassName)) {
                return true;
            }
            if (exceptionClassName.startsWith("sun.awt.SunToolkit") && this.IGNORE_SYNC) {
                System.err.println("Abbot: Ignoring SunToolkit Exception:");
                exception.printStackTrace();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThrowable(String message, Throwable t) {
        this.setExceptions(true);
        System.err.println("Abbot: Feedback Exception: " + message);
        t.printStackTrace();
        AbbotFeedbackManager abbotFeedbackManager = this;
        synchronized (abbotFeedbackManager) {
            if (this.m_throwables.size() < 20) {
                this.m_throwables.add((Pair<String, Throwable>)new Pair((Object)message, (Object)t));
            }
        }
    }

    public synchronized void throwFailure() throws Throwable {
        if (this.m_throwables.size() > 0) {
            throw (Throwable)this.m_throwables.get(0).getSecond();
        }
    }

    public synchronized Throwable getFirstThrowable() {
        return this.m_throwables.size() == 0 ? null : (Throwable)this.m_throwables.get(0).getSecond();
    }
}

