/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.abbot.AbbotFixture;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Filter;
import oracle.javatools.util.WeightedList;

public class AbbotFixtureHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/abbot/fixture", "abbot-fixture-hook");
    private Map<String, WeightedList<AbbotFixture>> m_pertestBySuite;
    private Map<String, WeightedList<AbbotFixture>> m_perSuite;
    private WeightedList<AbbotFixture> m_perrun;

    public AbbotFixtureHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                AbbotFixtureHook.this.m_perrun = null;
                AbbotFixtureHook.this.m_perSuite = new HashMap();
                AbbotFixtureHook.this.m_pertestBySuite = new HashMap();
            }

            public void listenerAttached(HashStructureHookEvent e) {
            }
        });
    }

    private Filter getSuiteFilter(String suite) {
        SuiteFilter filter = new SuiteFilter(suite);
        if (suite != null) {
            filter = Filter.Instances.or((Filter[])new Filter[]{filter, new SuiteFilter(null)});
        }
        return filter;
    }

    public List<AbbotFixture> getPerTestFixtures(String suite) {
        WeightedList<AbbotFixture> fixtures = this.m_pertestBySuite.get(suite);
        if (fixtures == null) {
            fixtures = this.getAbbotFixtures("pertest", (Filter<HashStructure>)this.getSuiteFilter(suite));
            this.m_pertestBySuite.put(suite, fixtures);
        }
        return Collections.unmodifiableList(new ArrayList<AbbotFixture>((Collection<AbbotFixture>)fixtures));
    }

    public List<AbbotFixture> getPerSuiteFixtures(String suite) {
        WeightedList<AbbotFixture> fixtures = this.m_perSuite.get(suite);
        if (fixtures == null) {
            fixtures = this.getAbbotFixtures("persuite", (Filter<HashStructure>)this.getSuiteFilter(suite));
            this.m_perSuite.put(suite, fixtures);
        }
        return Collections.unmodifiableList(new ArrayList<AbbotFixture>((Collection<AbbotFixture>)fixtures));
    }

    public List<AbbotFixture> getPerRunFixtures(String[] suites) {
        if (this.m_perrun == null) {
            Filter[] suiteFilter = new Filter[suites.length + 1];
            for (int i = 0; i < suites.length; ++i) {
                suiteFilter[i] = new SuiteFilter(suites[i]);
            }
            suiteFilter[suiteFilter.length - 1] = new SuiteFilter(null);
            this.m_perrun = this.getAbbotFixtures("perrun", (Filter<HashStructure>)Filter.Instances.or((Filter[])suiteFilter));
        }
        return Collections.unmodifiableList(new ArrayList<AbbotFixture>((Collection<AbbotFixture>)this.m_perrun));
    }

    private WeightedList<AbbotFixture> getAbbotFixtures(String type, Filter<HashStructure> filter) {
        WeightedList fixtures = new WeightedList();
        HashStructure hs = this.getHashStructure();
        List list = hs.getAsList(type);
        if (list == null || list.isEmpty()) {
            return fixtures;
        }
        filter = Filter.Instances.and((Filter[])new Filter[]{filter, new ExtensionFilter()});
        for (HashStructure c : list) {
            if (!filter.matches((Object)c)) continue;
            try {
                Class<?> toCreate = Class.forName(c.getString("fixture"));
                String weightString = c.getString("weight");
                double weight = 0.0;
                if (weightString != null) {
                    try {
                        weight = Double.valueOf(weightString);
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger("oracle.abbot").log(Level.WARNING, "Invalid weight \"{0}\" specified for fixture {1}", new Object[]{weightString, toCreate.getName()});
                    }
                }
                fixtures.add(toCreate.newInstance(), weight);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return fixtures;
    }

    private class ExtensionFilter
    implements Filter<HashStructure> {
        public boolean matches(HashStructure value) {
            String hValue = value.getString("extension");
            return hValue == null || ExtensionRegistry.getExtensionRegistry().findExtension(hValue) != null;
        }
    }

    class SuiteFilter
    implements Filter<HashStructure> {
        private String _suite;

        public SuiteFilter(String suite) {
            this._suite = suite;
        }

        public boolean matches(HashStructure value) {
            String hValue = value.getString("suite");
            if (hValue != null) {
                return this._suite != null ? this._suite.matches(hValue) : false;
            }
            return this._suite == null;
        }
    }
}

