/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.InterruptedAbbotException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ide.extension.Extension;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Holder;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.abbot.AbbotAddin;
import oracle.abbot.AbbotFixture;
import oracle.abbot.AbbotFixtureHook;
import oracle.abbot.AbbotTestSuite;
import oracle.abbot.JDevScriptFixture;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.abbot.QAResultPrinter;
import oracle.abbot.TestHelper;
import oracle.abbot.junit.JUnitTest;
import oracle.abbot.junit.XMLJUnitResultFormatter;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbbotRunner
implements Runnable {
    private ArrayList<AbbotTestSuite> m_suites = new ArrayList();
    private URL m_resultsDir;
    private OutputStream m_outStream = System.out;
    private boolean m_collateResults;
    private AbbotFixtureHook m_afh;
    private Integer m_maxRetries;
    private int m_retryNum = 0;
    protected final String m_name;
    private TestMonitor m_monitor;
    private volatile Thread m_currentThread;
    private static final String STRING = "Hello To Jason Issacs";

    public AbbotRunner(String name) {
        this.m_name = name;
        this.m_afh = (AbbotFixtureHook)ExtensionRegistry.getExtensionRegistry().getHook(AbbotFixtureHook.NAME);
    }

    public void start() {
        this.m_currentThread = new Thread((Runnable)this, "Abbot Tests " + this.getName());
        this.m_currentThread.start();
    }

    public String getName() {
        return this.m_name;
    }

    public void addSuites(AbbotTestSuite ... suites) {
        if (suites != null) {
            this.addSuites(Arrays.asList(suites));
        }
    }

    public void addSuites(Collection<AbbotTestSuite> suites) {
        this.m_suites.addAll(suites);
    }

    public void setResultsDir(URL resultsDir) {
        if (resultsDir == null) {
            throw new IllegalArgumentException("Missing url");
        }
        this.m_resultsDir = resultsDir;
    }

    protected URL getResultsDir() {
        return this.m_resultsDir;
    }

    public void setOutputStream(OutputStream outStream) {
        if (outStream == null) {
            throw new IllegalArgumentException("Missing outStream");
        }
        if (this.m_resultsDir != null) {
            throw new IllegalStateException("Results file set");
        }
        this.m_outStream = outStream;
    }

    public void setCollateResults(boolean collateResults) {
        this.m_collateResults = collateResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_currentThread = Thread.currentThread();
        FeedbackManager.addFeedback((String)("Starting " + this.getName()));
        final Holder statusComponent = new Holder();
        final Holder skipComponent = new Holder();
        final Holder stopComponent = new Holder();
        final Holder runningATest = new Holder((Object)false);
        final Holder stopTests = new Holder((Object)false);
        try {
            ArrayList<URL> resultsFiles;
            String lockTestState;
            block48: {
                final JLabel action = new JLabel("Abbot Status.... starting up");
                action.setEnabled(false);
                final AbstractAction skipAction = new AbstractAction(null, OracleIcons.getIcon((String)"unit_test_ignored.png")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (((Boolean)runningATest.value).booleanValue()) {
                            AbbotRunner.this.m_currentThread.interrupt();
                        }
                    }
                };
                final AbstractAction stopAction = new AbstractAction(null, OracleIcons.getIcon((String)"terminate.png")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        skipAction.actionPerformed(null);
                        stopTests.value = true;
                    }
                };
                statusComponent.value = (JLabel)Ide.getStatusBar().getToolbar().add((Component)action);
                TestHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        action.setBackground(Color.WHITE);
                        action.setOpaque(true);
                        action.setEnabled(true);
                        skipComponent.value = Ide.getStatusBar().getToolbar().add(skipAction);
                        stopComponent.value = Ide.getStatusBar().getToolbar().add(stopAction);
                    }
                });
                if (Math.random() < 0.02) {
                    try {
                        TestHelper.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((JLabel)statusComponent.value).setText(AbbotRunner.STRING);
                            }
                        });
                        TimeUnit.MILLISECONDS.sleep(300L);
                        TestHelper.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((JLabel)statusComponent.value).setText("");
                            }
                        });
                    }
                    catch (Throwable th) {
                        th.toString();
                    }
                }
                lockTestState = System.getProperty("oracle.awt-lock-check-disabled");
                System.setProperty("oracle.awt-lock-check-disabled", "true");
                if (this.m_resultsDir == null) {
                    this.m_resultsDir = TestHelper.createTemporaryDir("abbot-results", null);
                }
                resultsFiles = new ArrayList<URL>();
                if (this.m_outStream == null) {
                    throw new IllegalStateException("Missing output stream");
                }
                URLFileSystem.mkdir((URL)this.m_resultsDir);
                Collections.sort(this.m_suites, new Comparator<AbbotTestSuite>(){

                    @Override
                    public int compare(AbbotTestSuite o1, AbbotTestSuite o2) {
                        return o1.getSuiteName().compareTo(o2.getSuiteName()) * 2 + o1.getClassName().compareTo(o2.getClassName());
                    }
                });
                int totalTests = 0;
                String[] suiteNames = new String[this.m_suites.size()];
                int i = 0;
                for (AbbotTestSuite abbotTestSuite : this.m_suites) {
                    totalTests += abbotTestSuite.getTests().size();
                    suiteNames[i++] = abbotTestSuite.getSuiteName();
                }
                this.m_monitor = new TestMonitor((Holder<Boolean>)stopTests, (Holder<Boolean>)runningATest, (Holder<JLabel>)statusComponent, totalTests);
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                for (AbbotTestSuite suite : this.m_suites) {
                    String moduleName = suite.getExtensionId();
                    if (moduleName == null) continue;
                    Extension ext = er.findExtension(moduleName);
                    if (ext != null) {
                        er.fullyLoadExtension(ext, "Running abbot tests");
                        boolean loaded = er.isFullyLoaded(ext);
                        if (loaded) continue;
                        throw new IllegalStateException("Cannot fully load extension " + moduleName);
                    }
                    throw new IllegalStateException("Extension name: " + moduleName + " returned null");
                }
                List<AbbotFixture> list = this.m_afh.getPerRunFixtures(suiteNames);
                String currentSuite = suiteNames.length > 0 ? suiteNames[0] : "No suites";
                JDevScriptFixtureContext context = new JDevScriptFixtureContext(null, this.m_resultsDir, currentSuite, null);
                try {
                    for (AbbotFixture fixture : list) {
                        fixture.setUp(context);
                    }
                    for (AbbotTestSuite suite : this.m_suites) {
                        HashMap<String, JDevScriptFixture> fixtureMap = new HashMap<String, JDevScriptFixture>();
                        boolean haveAnotherGo = false;
                        int lastNumFailsAndErrors = 0;
                        this.m_retryNum = 0;
                        int testNoAtStart = this.m_monitor.getCurrentTest();
                        do {
                            int numFailsAndErrors;
                            if (((Boolean)stopTests.value).booleanValue()) {
                                break block48;
                            }
                            long time = System.currentTimeMillis();
                            String moduleName = suite.getExtensionId();
                            if (moduleName != null) {
                                String location = TestHelper.resolveExtensionFile(moduleName, "./");
                                if (!location.endsWith("/")) {
                                    location = location + "/";
                                }
                                System.setProperty("abbot.extension.dir." + moduleName, location);
                                System.setProperty("abbot.extension.dir.current", location);
                            }
                            try {
                                TestSuite ts = new TestSuite(suite.getSuiteName() + "." + suite.getClassName());
                                currentSuite = suite.getSuiteName();
                                Collection<AbbotTestSuite.AbbotTest> tests = suite.getTests();
                                for (AbbotTestSuite.AbbotTest test : tests) {
                                    JDevScriptFixture fixture;
                                    List<AbbotFixture> fixtures = this.m_afh.getPerTestFixtures(suite.getSuiteName());
                                    if (this.m_retryNum == 0) {
                                        fixture = new JDevScriptFixture(fixtures, suite.getExtensionId(), suite.getClassName(), test.getName(), test.getScript().getCanonicalPath(), this.m_resultsDir);
                                        fixtureMap.put(test.getScript().getCanonicalPath(), fixture);
                                    } else {
                                        fixture = (JDevScriptFixture)((Object)fixtureMap.get(test.getScript().getCanonicalPath()));
                                    }
                                    ts.addTest((Test)fixture);
                                }
                                JUnitTest jut = new JUnitTest(suite.getClassName());
                                final URL resultsFile = URLFactory.newURL((URL)this.m_resultsDir, (String)("ABBOT-" + ts.getName() + ".xml"));
                                final XMLJUnitResultFormatter xjrf = new XMLJUnitResultFormatter(){

                                    @Override
                                    protected OutputStream createOutput() throws IOException {
                                        return URLFileSystem.openOutputStream((URL)resultsFile);
                                    }
                                };
                                xjrf.startTestSuite(jut);
                                TestsFailedToComplete failed = new TestsFailedToComplete(suite.getExtensionId(), suite.getClassName(), this.m_resultsDir);
                                xjrf.startTest((Test)failed);
                                xjrf.addFailure((Test)failed, new XMLJUnitResultFormatter.HangingTest("The test failed to run complete, please refere to the console output to diagnose the problem. Did the tests time out?"));
                                xjrf.endTest((Test)failed);
                                QAResultPrinter rp = new QAResultPrinter(new PrintStream(this.m_outStream));
                                TestRunner tr = new TestRunner(rp){

                                    protected TestResult createTestResult() {
                                        TestResult tr = super.createTestResult();
                                        tr.addListener((TestListener)xjrf);
                                        tr.addListener((TestListener)AbbotRunner.this.m_monitor);
                                        return tr;
                                    }
                                };
                                this.m_monitor.resetCounts();
                                this.m_monitor.setCurrentTest(testNoAtStart);
                                List<AbbotFixture> perSuite = this.m_afh.getPerSuiteFixtures(suite.getSuiteName());
                                try {
                                    try {
                                        for (AbbotFixture af : perSuite) {
                                            af.setUp(context);
                                        }
                                        tr.doRun((Test)ts);
                                    }
                                    finally {
                                        for (int ifixture = perSuite.size() - 1; ifixture >= 0; --ifixture) {
                                            AbbotFixture af;
                                            af = perSuite.get(ifixture);
                                            af.tearDown(context);
                                        }
                                    }
                                }
                                finally {
                                    jut.setCounts(ts.countTestCases(), this.m_monitor.getFailureCount(), this.m_monitor.getErrorCount());
                                    jut.setRunTime(System.currentTimeMillis() - time);
                                    xjrf.removeTest((Test)failed);
                                    xjrf.endTestSuite(jut);
                                    resultsFiles.add(resultsFile);
                                }
                            }
                            catch (InterruptedAbbotException | Canceled c) {
                                c.toString();
                            }
                            catch (IOException e) {
                                FeedbackManager.reportException((String)"Exception running tests", (Throwable)e);
                            }
                            haveAnotherGo = false;
                            if (this.m_retryNum >= this.getMaxRetries() || (numFailsAndErrors = this.m_monitor.getFailureCount() + this.m_monitor.getErrorCount()) <= 0 || this.m_retryNum != 0 && numFailsAndErrors >= lastNumFailsAndErrors) continue;
                            haveAnotherGo = true;
                            lastNumFailsAndErrors = numFailsAndErrors;
                            ++this.m_retryNum;
                        } while (haveAnotherGo && !Thread.interrupted());
                    }
                }
                catch (Throwable th) {
                    AbbotAddin.writeOutFailedTestResults(this.m_resultsDir, currentSuite, "RunFailure.xml", null, th);
                    throw new Error("Failed during test run", th);
                }
                finally {
                    for (int ifixture = list.size() - 1; ifixture >= 0; --ifixture) {
                        AbbotFixture fixture = list.get(ifixture);
                        fixture.tearDown(context);
                    }
                }
            }
            if (lockTestState != null) {
                System.setProperty("oracle.awt-lock-check-disabled", lockTestState);
            } else {
                System.clearProperty("oracle.awt-lock-check-disabled");
            }
            if (this.m_collateResults && resultsFiles.size() > 0) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document testresults = db.newDocument();
                    Element testsuites = (Element)testresults.appendChild(testresults.createElement("testsuites"));
                    for (URL resultsFile : resultsFiles) {
                        Document results = db.parse(URLFileSystem.openInputStream((URL)resultsFile));
                        testsuites.appendChild(testresults.importNode(results.getFirstChild(), true));
                    }
                    InputStream stream = JUnitTest.class.getResourceAsStream("xsl/junit-noframes-xsl2.0.xsl");
                    TransformerFactory tfactory = TransformerFactory.newInstance();
                    tfactory.setErrorListener(new ErrorListener(){

                        @Override
                        public void fatalError(TransformerException e) {
                            this.process(e);
                        }

                        @Override
                        public void error(TransformerException e) {
                            this.process(e);
                        }

                        @Override
                        public void warning(TransformerException e) {
                            this.process(e);
                        }

                        private void process(TransformerException e) {
                            Assert.printStackTrace((Throwable)e);
                        }
                    });
                    Transformer t = tfactory.newTransformer(new StreamSource(stream));
                    URL htmlOutput = URLFactory.newURL((URL)this.m_resultsDir, (String)"results.html");
                    URLFileSystem.delete((URL)htmlOutput);
                    t.setParameter("output.dir", URLFileSystem.getPlatformPathName((URL)htmlOutput));
                    t.transform(new DOMSource(testresults), new StreamResult(new File(htmlOutput.toURI())));
                    Assert.println((String)("Results in " + htmlOutput));
                    BrowserRunner.getBrowserRunner().runBrowserOnURLV2(htmlOutput, null, null);
                }
                catch (Exception ex) {
                    FeedbackManager.reportException((String)"Error generating prety results file", (Throwable)ex);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        finally {
            if (statusComponent.value != null) {
                Ide.getStatusBar().getToolbar().remove((Component)statusComponent.value);
                statusComponent.value = null;
            }
            if (skipComponent.value != null) {
                Ide.getStatusBar().getToolbar().remove((Component)skipComponent.value);
                skipComponent.value = null;
            }
            if (stopComponent.value != null) {
                Ide.getStatusBar().getToolbar().remove((Component)stopComponent.value);
                stopComponent.value = null;
            }
        }
        FeedbackManager.addFeedback((String)("Finished " + this.getName()));
    }

    private int getMaxRetries() {
        if (this.m_maxRetries == null) {
            this.m_maxRetries = Integer.getInteger("abbot.maxretries", 0);
        }
        return this.m_maxRetries;
    }

    private class TestMonitor
    implements TestListener {
        private int m_totalTests;
        private int m_currentTest;
        private int m_failureCount;
        private int m_totalFailureCount;
        private int m_errorCount;
        private int m_totalErrorCount;
        private Holder<Boolean> stopTests;
        private Holder<Boolean> runningATest;
        private Holder<JLabel> statusComponent;

        public TestMonitor(Holder<Boolean> stopTests, Holder<Boolean> runningATest, Holder<JLabel> statusComponent, int totalTests) {
            this.m_totalTests = totalTests;
            this.stopTests = stopTests;
            this.runningATest = runningATest;
            this.statusComponent = statusComponent;
        }

        public void startTest(Test test) {
            if (((Boolean)this.stopTests.value).booleanValue()) {
                throw new Canceled();
            }
            ++this.m_currentTest;
            this.runningATest.value = true;
            if (test instanceof JDevScriptFixture && ((JDevScriptFixture)test).hasPassed()) {
                this.updateStatus("Skipping: ", test);
            } else {
                this.updateStatus("Running: ", test);
            }
        }

        public void endTest(Test test) {
            this.runningATest.value = false;
            this.updateStatus("Finished: ", test);
        }

        private void updateStatus(String prefix, Test test) {
            String filePath;
            if (AbbotRunner.this.m_retryNum > 0) {
                prefix = prefix + "(Retry #" + AbbotRunner.this.m_retryNum + ") ";
                System.setProperty("abbot.current.retry", Integer.toString(AbbotRunner.this.m_retryNum));
            }
            String filename = filePath = ((JDevScriptFixture)test).getFilename();
            URL fileURL = URLFactory.newFileURL((String)filePath);
            if (fileURL != null) {
                filename = URLFileSystem.getFileName((URL)fileURL);
            }
            final String message = "[" + this.m_currentTest + "/" + this.m_totalTests + " e=" + (this.m_totalErrorCount + this.m_errorCount) + " f=" + (this.m_totalFailureCount + this.m_failureCount) + "] " + prefix + filename;
            if (this.statusComponent.value != null) {
                try {
                    TestHelper.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ((JLabel)((TestMonitor)TestMonitor.this).statusComponent.value).setText(message);
                            ((JLabel)((TestMonitor)TestMonitor.this).statusComponent.value).invalidate();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    Ide.getStatusBar().setText(message);
                }
            } else {
                Ide.getStatusBar().setText(message);
            }
            System.err.println(".");
            System.err.println(".");
            System.err.println(". Abbot status is " + message);
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            memoryBean.gc();
            MemoryUsage heapMemoryUsage = memoryBean.getHeapMemoryUsage();
            System.err.println(". Memory after sync gc is heap " + this.megaBytes(heapMemoryUsage.getUsed()) + " of " + this.megaBytes(heapMemoryUsage.getCommitted()));
            System.err.println(".");
        }

        private long megaBytes(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public void addFailure(Test test, AssertionFailedError t) {
            ++this.m_failureCount;
        }

        public void addError(Test test, Throwable t) {
            ++this.m_errorCount;
        }

        public int getFailureCount() {
            return this.m_failureCount;
        }

        public int getErrorCount() {
            return this.m_errorCount;
        }

        public int getCurrentTest() {
            return this.m_currentTest;
        }

        public void setCurrentTest(int test) {
            this.m_currentTest = test;
        }

        public void resetCounts() {
            this.m_totalFailureCount += this.m_failureCount;
            this.m_failureCount = 0;
            this.m_totalErrorCount += this.m_errorCount;
            this.m_errorCount = 0;
        }
    }

    private static class Canceled
    extends Error {
        private Canceled() {
        }
    }

    private static class TestsFailedToComplete
    extends JDevScriptFixture {
        private static List<AbbotFixture> emptyList = Collections.emptyList();

        public TestsFailedToComplete(String extensionId, String suite, URL resultsDir) {
            super(emptyList, extensionId, suite, "TestsFailedToComplete", "filename.txt", resultsDir);
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult testResult) {
        }
    }
}

