/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class AbbotTestSuite {
    private String m_suiteName;
    private String m_className;
    private int m_repetition = 0;
    private String m_extensionId;
    private SortedSet<AbbotTest> m_tests = new TreeSet<AbbotTest>(new Comparator<AbbotTest>(){

        @Override
        public int compare(AbbotTest o1, AbbotTest o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public static Collection<AbbotTestSuite> setRepetition(int rep, Collection<AbbotTestSuite> suites) {
        for (AbbotTestSuite suite : suites) {
            suite.m_repetition = rep;
        }
        return suites;
    }

    public AbbotTestSuite(AbbotTestSuite copy) {
        this.m_suiteName = copy.m_suiteName;
        this.m_className = copy.m_className;
        this.m_repetition = copy.m_repetition;
        this.m_extensionId = copy.m_extensionId;
        this.m_tests = copy.m_tests;
    }

    public AbbotTestSuite(String suiteName, String className) {
        this.m_suiteName = suiteName;
        this.m_className = className;
    }

    public AbbotTestSuite(String suiteName, String className, String extensionId) {
        this.m_suiteName = suiteName;
        this.m_className = className;
        this.m_extensionId = extensionId;
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getClassName() {
        return this.m_repetition >= 1 ? this.m_className + "[" + this.m_repetition + "]" : this.m_className;
    }

    public String getExtensionId() {
        return this.m_extensionId;
    }

    public void addTest(String name, File script) {
        if (!this.m_tests.add(new AbbotTest(name, script))) {
            throw new IllegalStateException("Duplicate test name");
        }
    }

    public Collection<AbbotTest> getTests() {
        return Collections.unmodifiableCollection(this.m_tests);
    }

    public class AbbotTest {
        private String m_name;
        private File m_script;

        private AbbotTest(String name, File script) {
            this.m_name = name;
            this.m_script = script;
        }

        public String getName() {
            return this.m_name;
        }

        public File getScript() {
            return this.m_script;
        }
    }
}

