/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.tester.Robot;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import oracle.abbot.AbbotFixture;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.abbot.TestHelper;
import oracle.ide.Ide;

public class ClipboardFixture
implements AbbotFixture {
    private static Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

    @Override
    public void setUp(JDevScriptFixtureContext context) {
        Clipboard clipboard = new Clipboard("Abbot Clipboard");
        this.updateClipboard(context, clipboard);
    }

    @Override
    public void tearDown(JDevScriptFixtureContext context) {
        Clipboard currentcb = (Clipboard)Robot.callAndWait((Component)Ide.getMainWindow(), (Callable)new Callable<Clipboard>(){

            @Override
            public Clipboard call() {
                return Toolkit.getDefaultToolkit().getSystemClipboard();
            }
        });
        if (currentcb != systemClipboard) {
            this.updateClipboard(context, systemClipboard);
        }
    }

    private void updateClipboard(JDevScriptFixtureContext context, final Clipboard clipboard) {
        try {
            TestHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Class<?> $tsm = Class.forName("org.netbeans.TopSecurityManager");
                        Method $ms = $tsm.getDeclaredMethod("makeSwingUseSpecialClipboard", Clipboard.class);
                        $ms.setAccessible(true);
                        $ms.invoke($tsm, clipboard);
                    }
                    catch (Throwable th) {
                        ClipboardFixture.throwAny(th);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            context.setFailure(e);
        }
    }

    private static <E extends Throwable> void throwAny(Throwable e) throws E {
        throw e;
    }
}

