/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ide.extension.Extension;
import oracle.abbot.AbbotFixture;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.ide.ExtensionRegistry;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.util.ExtensionLoadingLogRecord;

public class ExtensionFixture
implements AbbotFixture {
    private Set<Extension> previouslyLoadedExtensions;

    @Override
    public void setUp(JDevScriptFixtureContext context) {
        this.previouslyLoadedExtensions = this.getLoadedExtensionSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown(JDevScriptFixtureContext context) {
        if (this.previouslyLoadedExtensions != null) {
            Set<Extension> loaded = this.getLoadedExtensionSet();
            loaded.removeAll(this.previouslyLoadedExtensions);
            try (PrintStream ps = new PrintStream((OutputStream)context.getResultsStream("ExtensionLoaded.txt").getSecond());){
                for (Extension ext : loaded) {
                    ExtensionLoadingLogRecord elr = new ExtensionLoadingLogRecord((IDEExtension)ext);
                    ps.println(elr.getMessage());
                    for (ExtensionLoadingLogRecord.DetailRecord dr : elr.getDetailMessages()) {
                        ps.print(" - ");
                        ps.println(dr.getMessage());
                    }
                }
            }
        }
        this.previouslyLoadedExtensions = null;
    }

    private Set<Extension> getLoadedExtensionSet() {
        LinkedHashSet<Extension> loaded = new LinkedHashSet<Extension>();
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        for (Extension ext : er.getExtensions()) {
            if (!er.isFullyLoaded(ext)) continue;
            loaded.add(ext);
        }
        return loaded;
    }
}

