/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.abbot.AbbotFeedbackManager;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.feedback.shared.MessageFeedback;

public class FeedbackManagerLogHandler
extends Handler {
    private final AbbotFeedbackManager feedbackManager;
    private static final FeedbackLogOptions NULL_OPTIONS = new FeedbackLogOptions();

    FeedbackManagerLogHandler(AbbotFeedbackManager feedbackManager) {
        this.feedbackManager = feedbackManager;
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        FeedbackLogOptions options = NULL_OPTIONS;
        Object[] parameters = record.getParameters();
        if (parameters != null) {
            int i = parameters.length;
            while (--i >= 0) {
                if (!(parameters[i] instanceof FeedbackLogOptions)) continue;
                options = (FeedbackLogOptions)parameters[i];
                break;
            }
        }
        Level level = record.getLevel();
        int levelValue = level.intValue();
        Throwable thrown = options.getException() != null ? options.getException() : record.getThrown();
        String loggerName = record.getLoggerName();
        String logMessage = record.getMessage();
        if (logMessage != null) {
            SimpleFormatter simpleFormatter = new SimpleFormatter();
            message = ((Formatter)simpleFormatter).format(record);
        } else {
            message = thrown != null ? thrown.toString() : "No Log Message";
        }
        if (thrown != null && levelValue >= Level.SEVERE.intValue()) {
            boolean printToConsole;
            Logger logger = loggerName == null ? null : Logger.getLogger(loggerName);
            boolean bl = printToConsole = logger == null || !logger.getUseParentHandlers();
            if (options.getApiDepth() != null) {
                this.feedbackManager.reportExceptionImpl(message, thrown, options.getApiDepth(), printToConsole);
            } else if (options.getApiName() != null) {
                this.feedbackManager.reportApiExceptionImpl(message, thrown, options.getApiName(), printToConsole);
            } else if (logMessage != null && logMessage.startsWith("API[") && logMessage.indexOf(93) > 4) {
                String apiName = logMessage.substring(4, logMessage.indexOf(93));
                this.feedbackManager.reportApiExceptionImpl(message, thrown, apiName, printToConsole);
            } else {
                this.feedbackManager.reportExceptionImpl(message, thrown, printToConsole);
            }
        } else if (levelValue >= Level.FINER.intValue()) {
            MessageFeedback feedback = new MessageFeedback(loggerName + ":" + message);
            this.feedbackManager.addFeedbackImpl((Feedback)feedback);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

