/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.swing.FocusManager;
import oracle.abbot.AbbotFixture;
import oracle.abbot.JDevScriptFixtureContext;

public class FocusFixture
implements AbbotFixture {
    List<String> focusList;
    private PropertyChangeListener focusListener;

    public FocusFixture() {
        boolean i = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(JDevScriptFixtureContext context) {
        FocusFixture focusFixture = this;
        synchronized (focusFixture) {
            this.focusList = new ArrayList<String>(200);
        }
        this.focusListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FocusFixture focusFixture = FocusFixture.this;
                synchronized (focusFixture) {
                    if (FocusFixture.this.focusList != null) {
                        FocusFixture.this.focusList.add(evt.toString() + "\n\n");
                        Object newValue = evt.getNewValue();
                        Object oldValue = evt.getOldValue();
                        if (oldValue instanceof Component) {
                            this.dumpComponentTree("-- oldValue", (Component)oldValue);
                        }
                        if (newValue instanceof Component) {
                            this.dumpComponentTree("++ newValue", (Component)newValue);
                        }
                    }
                }
            }

            private void dumpComponentTree(String prefix, Component comp) {
                StringBuilder sb = new StringBuilder(prefix);
                sb.append("   ");
                while (comp != null) {
                    sb.append(comp);
                    sb.append("   ===  is child of ===   ");
                    comp = comp.getParent();
                }
                FocusFixture.this.focusList.add(sb.toString());
            }
        };
        FocusManager.getCurrentManager().addPropertyChangeListener(this.focusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown(JDevScriptFixtureContext context) {
        if (this.focusListener != null) {
            FocusManager.getCurrentManager().removePropertyChangeListener(this.focusListener);
        }
        FocusFixture focusFixture = this;
        synchronized (focusFixture) {
            if (this.focusList != null) {
                try (PrintStream ps = new PrintStream(new GZIPOutputStream((OutputStream)context.getResultsStream("focusEvents.txt.gz").getSecond()));){
                    for (String next : this.focusList) {
                        ps.println(next);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

