/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.AssertionFailedError;
import abbot.Log;
import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.finder.TestHierarchy;
import abbot.script.Script;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.StepEvent;
import abbot.script.StepListener;
import abbot.script.StepRunner;
import abbot.script.XMLifiable;
import abbot.tester.FailedException;
import abbot.util.AWTFixtureHelper;
import java.awt.AWTEvent;
import java.awt.Robot;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import oracle.abbot.AbbotFeedbackManager;
import oracle.abbot.AbbotFixture;
import oracle.abbot.AbbotUncaughtExceptionHandler;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.abbot.TestHelper;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFactory;
import oracle.javatools.internal.ui.EventQueueObserver;
import oracle.javatools.internal.ui.EventQueueWrapper;
import oracle.javatools.util.ModelUtil;

public class JDevScriptFixture
extends TestCase {
    private static final Hierarchy DUMMY_HIERARCHY = new AWTHierarchy();
    private static AWTFixtureHelper s_oldContext = null;
    private static Hierarchy s_storedHierarchy = null;
    private static final boolean TIME_STEPS = Boolean.getBoolean("oracle.abbot.timeSteps");
    private static final boolean FEEDBACK_FAILS_STEP = Boolean.getBoolean("oracle.abbot.feedbackFailsStep");
    private static String retry = "";
    private String m_suiteName;
    private String m_extensionId;
    private String m_filename;
    private String m_className;
    private URL m_resultsDir;
    private JDevScriptFixtureContext m_testFixtureContext;
    private StepRunner m_runner;
    private FeedbackManager m_original;
    private AbbotFeedbackManager m_fm;
    private Script m_script;
    private Map<Object, Script> m_parentScripts = new IdentityHashMap<Object, Script>();
    private Step m_failedStep;
    private Step m_exceptionFailedStep;
    private String m_exemptUntil;
    private String m_unstable;
    private List<? extends AbbotFixture> m_perTest;
    private Status m_status;
    private long m_start = 0L;
    private long m_end = 0L;

    public JDevScriptFixture(List<? extends AbbotFixture> perTest, String extensionId, String suiteName, String name, String filename, URL resultsDir) {
        String shortName;
        this.m_perTest = perTest;
        this.m_suiteName = suiteName;
        this.m_extensionId = extensionId;
        this.m_filename = filename;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            shortName = name.substring(lastDot + 1);
            this.m_className = this.getSuiteName() + "." + name.substring(0, name.lastIndexOf("."));
        } else {
            shortName = name;
            this.m_className = this.getSuiteName();
        }
        this.setName(shortName);
        this.m_resultsDir = URLFactory.newDirURL((URL)resultsDir, (String)this.m_className);
        this.m_status = Status.OK;
    }

    public void runBare() throws Throwable {
        FeedbackManager.addFeedback((String)("Abbot replacing feedback manager : " + this.m_filename));
        this.m_original = FeedbackManager.getFeedbackManager();
        this.m_fm = new AbbotFeedbackManager();
        this.m_testFixtureContext = new JDevScriptFixtureContext(this.m_fm, this.m_resultsDir, this.m_suiteName, this.getName());
        Method method = FeedbackManager.class.getDeclaredMethod("setFeedbackManager", FeedbackManager.class);
        method.setAccessible(true);
        method.invoke(FeedbackManager.class, new Object[]{this.m_fm});
        AbbotUncaughtExceptionHandler.enable();
        try {
            super.runBare();
        }
        catch (FixtureException e) {
            try {
                throw e.getCause();
            }
            catch (Throwable throwable) {
                AbbotUncaughtExceptionHandler.disable();
                method.invoke(FeedbackManager.class, this.m_original);
                FeedbackManager.addFeedback((String)("Abbot restored feedback manager : " + this.m_filename));
                throw throwable;
            }
        }
        AbbotUncaughtExceptionHandler.disable();
        method.invoke(FeedbackManager.class, this.m_original);
        FeedbackManager.addFeedback((String)("Abbot restored feedback manager : " + this.m_filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        if (this.m_status == Status.FAILED) {
            this.m_status = Status.OK;
        }
        if (this.m_status == Status.OK) {
            FeedbackManager.addFeedback((String)("Abbot setting up: " + this.m_filename));
            this.m_end = this.m_start = System.currentTimeMillis();
            Robot robot = abbot.tester.Robot.getRobot();
            if (robot != null) {
                robot.waitForIdle();
            }
            if (s_oldContext == null) {
                s_oldContext = new AWTFixtureHelper();
            }
            if (s_storedHierarchy == null) {
                s_storedHierarchy = new TestHierarchy(false);
            }
            class ModifiedStepRunner
            extends StepRunner {
                private StringBuffer sb;

                public ModifiedStepRunner(AWTFixtureHelper helper) {
                    super(helper);
                    this.sb = new StringBuffer();
                    this.hierarchy = s_storedHierarchy;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runStep(Step step) throws Throwable {
                    block13: {
                        try {
                            this.sb.append("--");
                            if (TIME_STEPS) {
                                long startTime = System.nanoTime();
                                try {
                                    super.runStep(step);
                                }
                                finally {
                                    long elapsedTime = System.nanoTime() - startTime;
                                    System.out.println("Abbot Step Timer " + this.sb + "[" + elapsedTime / 1000000L + "]ms " + step.toString());
                                }
                            } else {
                                super.runStep(step);
                            }
                            if (FEEDBACK_FAILS_STEP) {
                                try {
                                    JDevScriptFixture.this.m_fm.throwFailure();
                                    break block13;
                                }
                                catch (Throwable t) {
                                    if (JDevScriptFixture.this.m_failedStep == null) {
                                        JDevScriptFixture.this.m_failedStep = step;
                                    }
                                    throw t;
                                }
                            }
                            if (JDevScriptFixture.this.m_fm.hasExceptions() && JDevScriptFixture.this.m_exceptionFailedStep == null) {
                                JDevScriptFixture.this.m_exceptionFailedStep = step;
                                System.err.println("Abbot: Exception During: " + step.getDescription());
                                System.err.print(JDevScriptFixture.this.createMessageStack(step));
                            }
                        }
                        finally {
                            this.sb.setLength(this.sb.length() - 2);
                        }
                    }
                }
            }
            this.m_runner = new ModifiedStepRunner(s_oldContext);
            AWTHierarchy.setDefault((Hierarchy)this.m_runner.getHierarchy());
            this.m_runner.addStepListener(new StepListener(){

                public void stateChanged(StepEvent stepEvent) {
                    if ((stepEvent.getType() == "step-failure" || stepEvent.getType() == "step-error") && JDevScriptFixture.this.m_failedStep == null) {
                        JDevScriptFixture.this.m_failedStep = stepEvent.getStep();
                    }
                }
            });
            try {
                for (AbbotFixture abbotFixture : this.m_perTest) {
                    abbotFixture.setUp(this.m_testFixtureContext);
                }
            }
            finally {
                this.m_testFixtureContext.writeOutResults();
            }
            TestHelper.ROBOT.waitForIdle();
            this.throwFixtureException("Setup Failure");
        }
    }

    public void tearDown() throws Exception {
        if (this.m_status == Status.OK || this.m_status == Status.ERROR) {
            this.m_end = System.currentTimeMillis();
            try {
                FeedbackManager.addFeedback((String)("Abbot tearing down: " + this.m_filename));
                AWTHierarchy.setDefault(null);
                this.m_runner = null;
                for (int i = this.m_perTest.size() - 1; i >= 0; --i) {
                    AbbotFixture af = this.m_perTest.get(i);
                    af.tearDown(this.m_testFixtureContext);
                }
                FeedbackManager.addFeedback((String)("Abbot finished: " + this.m_filename));
            }
            finally {
                this.m_testFixtureContext.writeOutResults();
            }
            TestHelper.ROBOT.waitForIdle();
            this.throwFixtureException("Teardown Failure");
            this.m_status = this.m_status == Status.ERROR ? Status.FAILED : Status.PASSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runTest() throws Throwable {
        Pattern pattern;
        Matcher matcher;
        if (this.m_status != Status.OK) return;
        FeedbackManager.addFeedback((String)("Abbot running: " + this.m_filename));
        this.m_script = new Script(this.m_filename, DUMMY_HIERARCHY);
        Log.log((String)("Running " + this.m_script + " with " + ((Object)((Object)this)).getClass()));
        System.out.println("Running " + this.m_script + " with " + ((Object)((Object)this)).getClass());
        this.findParentScripts(this.m_script, (Sequence)this.m_script);
        String description = this.m_script.getDescription();
        if (ModelUtil.hasLength((String)description) && (matcher = (pattern = Pattern.compile("@Exempt\\((.*?)\\)")).matcher(description)).find()) {
            this.m_exemptUntil = matcher.group(1);
            System.out.println("Script exempt until " + this.m_exemptUntil);
        }
        if (ModelUtil.hasLength((String)description) && (matcher = (pattern = Pattern.compile("@Unstable\\((.*?)\\)")).matcher(description)).find()) {
            this.m_unstable = matcher.group(1);
            System.out.println("Script is unstable, bug(s): " + this.m_unstable);
        }
        try {
            Thread deadLockMonitor = new Thread("Monitoring tests " + this.getFilename()){

                @Override
                public void run() {
                }
            };
            deadLockMonitor.start();
            EventQueueWrapper eqw = null;
            EventQueueObserver observer = null;
            if (Boolean.TRUE.equals(Boolean.getBoolean("abbot.captureEvents"))) {
                final PrintStream ps = new PrintStream((OutputStream)this.m_testFixtureContext.getResultsStream("EventStream.txt").getSecond());
                eqw = EventQueueWrapper.install();
                observer = new EventQueueObserver(){

                    public void postDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
                        ps.println(event);
                        super.postDispatchEvent(eventQueue, event);
                    }

                    public void preDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
                        super.preDispatchEvent(eventQueue, event);
                    }
                };
                eqw.addObserver(observer);
            }
            try {
                TestHelper.ROBOT.waitForIdle();
                this.m_runner.run((Step)this.m_script);
                TestHelper.ROBOT.waitForIdle();
                this.m_fm.throwFailure();
                if (eqw == null) return;
            }
            catch (Throwable throwable) {
                if (eqw == null) throw throwable;
                eqw.removeObserver(observer);
                throw throwable;
            }
            eqw.removeObserver(observer);
            return;
        }
        catch (Throwable t) {
            this.m_status = Status.ERROR;
            retry = System.getProperty("abbot.current.retry") == null ? "" : "-retry_" + System.getProperty("abbot.current.retry");
            TestHelper.captureScreenshot(this.m_testFixtureContext, "");
            if (t instanceof FailedException) {
                FailedException e = (FailedException)t;
                PrintStream ps = new PrintStream((OutputStream)this.m_testFixtureContext.getResultsStream("FailedException.SystemState" + retry + ".txt").getSecond());
                ps.append(e.getSystemState());
                ps.close();
            }
            try {
                TestHelper.zipTestCaseFromMyWork((OutputStream)this.m_testFixtureContext.getResultsStream("Workspace" + retry + ".zip").getSecond(), false, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_testFixtureContext.setFailed();
            this.throwScriptFailure("Test Failure", t);
            return;
        }
        finally {
            Log.log((String)(this.m_script.toString() + " finished"));
        }
    }

    private void throwScriptFailure(String failureType, Throwable t) throws Throwable {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        sb.append(failureType);
        sb.append(": ");
        String message = ((Throwable)t).getMessage();
        if (message != null) {
            message = message.replace("<", "&amp;lt;");
        }
        sb.append(message);
        sb.append(lineSep);
        sb.append(lineSep);
        if (this.m_failedStep != null) {
            this.appendStep(sb, this.m_failedStep);
            sb.append(lineSep);
            Step step = this.m_failedStep;
            Script script = this.m_parentScripts.get(step);
            while (script != null) {
                elements.add(this.createStackTraceElement(script, step));
                step = script;
                script = this.m_parentScripts.get(step);
            }
        } else {
            if (this.m_exceptionFailedStep != null) {
                this.appendStep(sb, this.m_exceptionFailedStep);
                sb.append(lineSep);
                sb.append(lineSep);
                sb.append(this.createMessageStack(this.m_exceptionFailedStep));
            }
            elements.add(this.createStackTraceElement(this.m_script, null));
        }
        elements.addAll(Arrays.asList(((Throwable)t).getStackTrace()));
        sb.append(lineSep);
        sb.append(t.getClass().getName());
        sb.append(": ");
        sb.append(message);
        message = sb.toString();
        Throwable cause = ((Throwable)t).getCause();
        t = t instanceof AssertionFailedError ? new AssertionFailedError(message) : (t instanceof AssertionError ? new AssertionError((Object)message) : new Exception(message));
        ((Throwable)t).initCause(cause);
        ((Throwable)t).setStackTrace(elements.toArray(new StackTraceElement[elements.size()]));
        throw t;
    }

    private String createMessageStack(Step step) {
        StringBuilder sb = new StringBuilder();
        Script script = this.m_parentScripts.get(step);
        while (script != null) {
            sb.append(script.getContext(step));
            sb.append('\n');
            step = script;
            script = this.m_parentScripts.get(step);
        }
        return sb.toString();
    }

    private StackTraceElement createStackTraceElement(Script script, Step step) {
        File file = script.getFile();
        return new StackTraceElement(this.m_className + "." + file.getName().replace(".xml", ""), "script", file.getAbsolutePath(), step != null ? JDevScriptFixture.getLine(script, step) : -1);
    }

    public static int getLine(Script resolver, Step step) {
        try {
            Method method = Script.class.getDeclaredMethod("getLine", Sequence.class, Step.class);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)resolver, resolver, step);
        }
        catch (Exception ex) {
            return Script.getLine((Step)step);
        }
    }

    private void appendStep(StringBuffer sb, Step step) {
        sb.append("Script step : ");
        sb.append(Step.toXMLString((XMLifiable)step).replace("<", "&amp;lt;"));
    }

    private void findParentScripts(Script script, Sequence sequence) {
        for (Object step : sequence.steps()) {
            this.m_parentScripts.put(step, script);
            if (step instanceof Script) {
                Script childScript = (Script)step;
                this.findParentScripts(childScript, (Sequence)childScript);
                continue;
            }
            if (!(step instanceof Sequence)) continue;
            this.findParentScripts(script, (Sequence)step);
        }
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getExemptUntil() {
        return this.m_exemptUntil;
    }

    public String getUnstable() {
        return this.m_unstable;
    }

    public String getClassName() {
        return this.m_className;
    }

    public boolean hasPassed() {
        return this.m_status == Status.PASSED;
    }

    public long getDuration() {
        return this.m_end - this.m_start;
    }

    private void throwFixtureException(String failureType) throws FixtureException {
        try {
            this.m_fm.throwFailure();
        }
        catch (Throwable t) {
            try {
                this.throwScriptFailure(failureType, t);
            }
            catch (Throwable t2) {
                this.m_status = Status.FAILED;
                throw new FixtureException(t);
            }
        }
    }

    private class FixtureException
    extends Exception {
        public FixtureException(Throwable cause) {
            super(cause);
        }
    }

    private static enum Status {
        OK,
        ERROR,
        PASSED,
        FAILED;

    }
}

