/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.abbot.AbbotFeedbackManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.Pair;

public class JDevScriptFixtureContext {
    private Map<URL, ByteArrayOutputStream> m_diagnostics = new HashMap<URL, ByteArrayOutputStream>();
    private AbbotFeedbackManager m_fm;
    private URL m_resultsDir;
    private String m_suiteName;
    private String m_testName;
    private boolean m_failed = false;

    public JDevScriptFixtureContext() {
        this.m_resultsDir = null;
    }

    public JDevScriptFixtureContext(AbbotFeedbackManager fm, URL resultsDir, String suiteName, String testName) {
        this.m_fm = fm;
        this.m_resultsDir = resultsDir;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
    }

    public void setFailure(Exception failure) {
        FeedbackManager.reportException((Throwable)failure);
    }

    public Throwable getFailure() {
        return this.m_fm == null ? null : this.m_fm.getFirstThrowable();
    }

    public void setFailed() {
        this.m_failed = true;
    }

    private boolean isFailed() {
        return this.m_failed || this.getFailure() != null;
    }

    private URL getResultsDir() {
        if (this.m_resultsDir != null) {
            URLFileSystem.mkdirs((URL)this.m_resultsDir);
        }
        return this.m_resultsDir;
    }

    public boolean isResultsDirDefined() {
        return this.m_resultsDir != null;
    }

    public URL getResultsFilename(String postfix) {
        return URLFactory.newURL((URL)this.getResultsDir(), (String)(this.getTestName() + "-" + postfix));
    }

    public Pair<URL, OutputStream> getResultsStream(String postfix) {
        URL resultsURL = URLFactory.encodeURL((URL)URLFactory.newURL((URL)this.m_resultsDir, (String)(this.getTestName() + "-" + postfix)));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.m_diagnostics.put(resultsURL, os);
        return new Pair((Object)resultsURL, (Object)os);
    }

    public URL getResultsDir(String postfix) {
        URL dirURL = URLFactory.newDirURL((URL)this.getResultsDir(), (String)(this.getTestName() + "-" + postfix));
        URLFileSystem.mkdirs((URL)dirURL);
        return dirURL;
    }

    public void setResultsDir(URL resultsDir) {
        this.m_resultsDir = resultsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutResults() {
        if (this.isFailed()) {
            if (!this.m_diagnostics.isEmpty()) {
                URLFileSystem.mkdirs((URL)this.m_resultsDir);
            }
            for (Map.Entry<URL, ByteArrayOutputStream> entry : this.m_diagnostics.entrySet()) {
                OutputStream os = null;
                try {
                    os = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)entry.getKey()));
                    byte[] data = entry.getValue().toByteArray();
                    os.write(data);
                    os.flush();
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
                finally {
                    if (os == null) continue;
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        Assert.printStackTrace((Throwable)ioe);
                    }
                }
            }
        }
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.m_suiteName = suiteName;
    }

    public String getTestName() {
        return this.m_testName;
    }

    public void setTestName(String testName) {
        this.m_testName = testName;
    }
}

